/*
 * Decompiled with CFR 0.152.
 */
package hmi.speechengine.ttsbinding;

import hmi.bml.core.SpeechBehaviour;
import hmi.bml.ext.msapi.MSApiBehaviour;
import hmi.bml.ext.ssml.SSMLBehaviour;
import hmi.elckerlyc.planunit.InvalidParameterException;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.speechengine.ttsbinding.TTSBinding;
import hmi.tts.AbstractTTSGenerator;
import hmi.tts.BMLTTSBridge;
import hmi.tts.sapi5.SAPI5SSMLTTSBridge;
import hmi.tts.sapi5.SAPI5TTSGenerator;
import hmi.tts.sapi5.SAPITTSBridge;
import hmi.util.StringUtil;

public class SAPITTSBinding
extends TTSBinding {
    private final SAPI5TTSGenerator sapiTTSGenerator = new SAPI5TTSGenerator();

    public SAPITTSBinding() {
        this.ttsGenerator = this.sapiTTSGenerator;
        this.ttsBridgeMap.put(SpeechBehaviour.class, new BMLTTSBridge((AbstractTTSGenerator)this.sapiTTSGenerator));
        this.ttsBridgeMap.put(MSApiBehaviour.class, new SAPITTSBridge(this.sapiTTSGenerator));
        this.ttsBridgeMap.put(SSMLBehaviour.class, new SAPI5SSMLTTSBridge(this.sapiTTSGenerator));
        this.supportedBehaviours.add(SSMLBehaviour.class);
        this.supportedBehaviours.add(MSApiBehaviour.class);
    }

    @Override
    public void setParameterValue(String parameter, String value) throws ParameterException {
        if (StringUtil.isNumeric((String)value)) {
            this.setFloatParameterValue(parameter, Float.parseFloat(value));
        }
        throw new InvalidParameterException(parameter, value);
    }

    @Override
    public float getFloatParameterValue(String parameter) throws ParameterException {
        if (parameter.equals("rate")) {
            return this.sapiTTSGenerator.getRate();
        }
        if (parameter.equals("volume")) {
            return this.sapiTTSGenerator.getVolume();
        }
        throw new ParameterNotFoundException(parameter);
    }

    @Override
    public String getParameterValue(String parameter) throws ParameterException {
        return "" + this.getFloatParameterValue(parameter);
    }

    @Override
    public void setFloatParameterValue(String parameter, float value) throws ParameterException {
        if (parameter.equals("rate")) {
            this.sapiTTSGenerator.setRate((int)value);
        } else if (parameter.equals("volume")) {
            this.sapiTTSGenerator.setVolume((int)value);
        } else {
            throw new ParameterNotFoundException(parameter);
        }
    }

    @Override
    public void cleanup() {
        this.sapiTTSGenerator.cleanup();
    }
}

