/*
 * Decompiled with CFR 0.152.
 */
package hmi.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.speechengine.TextOutput;
import hmi.speechengine.TimedTextSpeechUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPlanner
extends AbstractPlanner<TimedTextSpeechUnit> {
    private static Logger logger = LoggerFactory.getLogger((String)TextPlanner.class.getName());
    private TextOutput textOutput;

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[" + this.textOutput.getClass().getName() + "]";
    }

    public TextPlanner(FeedbackManager bfm, TextOutput output, PlanManager<TimedTextSpeechUnit> planManager) {
        super(bfm, planManager);
        this.textOutput = output;
    }

    public void setTextOutput(TextOutput to) {
        this.textOutput = to;
    }

    private TimedTextSpeechUnit createSpeechUnit(BMLBlockPeg bbPeg, Behaviour b) {
        SpeechBehaviour bSpeech = (SpeechBehaviour)b;
        TimedTextSpeechUnit bs = new TimedTextSpeechUnit(this.fbManager, bbPeg, bSpeech.getContent(), bSpeech.getBmlId(), bSpeech.id, this.textOutput);
        return bs;
    }

    private void validateSacs(Behaviour b, TimedTextSpeechUnit bs, List<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        for (TimePegAndConstraint sac : sacs) {
            if (bs.hasSync(sac.syncId)) continue;
            throw new BehaviourPlanningException(b, "Invalid synchronization constraint " + sac + " syncId " + sac.syncId + " not found in speech unit");
        }
    }

    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs, TimedTextSpeechUnit bs) throws BehaviourPlanningException {
        ArrayList<SyncAndTimePeg> satp = new ArrayList<SyncAndTimePeg>();
        if (bs == null) {
            bs = this.createSpeechUnit(bbPeg, b);
        }
        this.validateSacs(b, bs, sacs);
        for (TimePegAndConstraint sac : sacs) {
            OffsetPeg p;
            if (sac.syncId.equals("start")) {
                if (sac.offset == 0.0) {
                    bs.setStart(sac.peg);
                    satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, "start", sac.peg));
                } else {
                    p = new OffsetPeg(sac.peg, -sac.offset);
                    bs.setStart((TimePeg)p);
                    satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, "start", (TimePeg)p));
                }
            }
            if (!sac.syncId.equals("end")) continue;
            if (sac.offset == 0.0) {
                bs.setEnd(sac.peg);
                satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, "end", sac.peg));
                continue;
            }
            p = new OffsetPeg(sac.peg, -sac.offset);
            bs.setEnd((TimePeg)p);
            satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, "end", (TimePeg)p));
        }
        this.linkSyncs(bs, sacs);
        for (String sync : bs.getSyncs()) {
            if (bs.getTimePeg(sync) == null) continue;
            satp.add(new SyncAndTimePeg(b.getBmlId(), b.id, sync, bs.getTimePeg(sync)));
        }
        this.planManager.addPlanUnit((TimedPlanUnit)bs);
        return satp;
    }

    public TimedTextSpeechUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, List<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        TimedTextSpeechUnit bs = this.createSpeechUnit(bbPeg, b);
        this.validateSacs(b, bs, sacs);
        ArrayList<TimePegAndConstraint> sortedSac = new ArrayList<TimePegAndConstraint>();
        block0: for (String sync : bs.getSyncs()) {
            for (TimePegAndConstraint s : sacs) {
                if (!s.syncId.equals(sync)) continue;
                sortedSac.add(s);
                continue block0;
            }
        }
        this.linkSyncs(bs, sortedSac);
        int sections = 0;
        double totalStretch = 0.0;
        TimePegAndConstraint sPrev = null;
        for (TimePegAndConstraint s : sortedSac) {
            if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            if (sPrev != null) {
                double duration = bs.getTime(s.syncId) - bs.getTime(sPrev.syncId);
                double startKey = 0.0;
                double endKey = 0.0;
                for (String sync : bs.getSyncs()) {
                    TimePeg tp = bs.getTimePeg(sync);
                    if (tp == null) continue;
                    if (tp.getLink() == sPrev.peg.getLink()) {
                        startKey = bs.getRelativeTime(sync);
                    }
                    if (tp.getLink() != s.peg.getLink()) continue;
                    endKey = bs.getRelativeTime(sync);
                }
                double nominalDuration = (endKey - startKey) * bs.getPreferedDuration();
                if (!(nominalDuration > 0.0)) continue;
                totalStretch += duration / nominalDuration;
                ++sections;
                continue;
            }
            sPrev = s;
        }
        double avgStretch = 1.0;
        if (sections > 0) {
            avgStretch = totalStretch / (double)sections;
        }
        if (sortedSac.size() > 0) {
            TimePegAndConstraint sacStart = sortedSac.get(0);
            if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacNext = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacNext = s;
                    break;
                }
                if (sacNext == null) {
                    sacStart.peg.setLocalValue(0.0);
                } else {
                    double nextKey = bs.getRelativeTime(sacNext.syncId);
                    double nextTime = bs.getTime(sacNext.syncId);
                    double tStart = nextTime - nextKey * avgStretch * bs.getPreferedDuration();
                    if (sacStart.resolveAsStartOffset) {
                        OffsetPeg os = (OffsetPeg)sacStart.peg;
                        os.setLink(bs.getTimePeg(sacNext.syncId));
                        os.setOffset(tStart - nextTime);
                    } else {
                        sacStart.peg.setGlobalValue(tStart + sacStart.offset);
                    }
                }
            }
            TimePegAndConstraint sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (sacEnd.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacPrev = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacPrev = s;
                }
                if (sacPrev == null) {
                    sacEnd.peg.setGlobalValue(bs.getPreferedDuration());
                } else {
                    double keyPrev = bs.getRelativeTime(sacPrev.syncId);
                    double keyNext = 1.0;
                    double keyCurr = bs.getRelativeTime(sacEnd.syncId);
                    double timePrev = bs.getTime(sacPrev.syncId);
                    double timeNext = timePrev + (keyNext - keyPrev) * avgStretch * bs.getPreferedDuration();
                    sacEnd.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + sacEnd.offset);
                }
            }
            TimePegAndConstraint sacPrev = sacStart;
            TimePegAndConstraint sacNext = null;
            for (TimePegAndConstraint s : sortedSac) {
                if (s.peg.getGlobalValue() == -1.7976931348623157E308) {
                    for (TimePegAndConstraint s2 : sortedSac.subList(sortedSac.indexOf(s), sortedSac.size())) {
                        if (s2.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                        sacNext = s2;
                        break;
                    }
                    double keyPrev = bs.getRelativeTime(sacPrev.syncId);
                    double keyNext = bs.getRelativeTime(sacNext.syncId);
                    double keyCurr = bs.getRelativeTime(s.syncId);
                    double timePrev = bs.getTime(sacPrev.syncId);
                    double timeNext = bs.getTime(sacNext.syncId);
                    s.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + s.offset);
                }
                sacPrev = s;
            }
            sacEnd = sortedSac.get(sortedSac.size() - 1);
            logger.debug(sacEnd.syncId);
            if (!sacEnd.syncId.equals("end") && bs.getPreferedDuration() > 0.0) {
                double keyPrev = bs.getRelativeTime(sacEnd.syncId);
                double keyEnd = bs.getRelativeTime("end");
                OffsetPeg op = new OffsetPeg(bs.getTimePeg(sacEnd.syncId), (keyEnd - keyPrev) * avgStretch * bs.getPreferedDuration());
                bs.setEnd((TimePeg)op);
            }
        }
        return bs;
    }

    private void linkSyncs(TimedTextSpeechUnit su, List<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint s : sacs) {
            for (String sync : su.getSyncs()) {
                if (!s.syncId.equals(sync)) continue;
                if (s.offset == 0.0) {
                    su.setTimePeg(sync, s.peg);
                    continue;
                }
                su.setTimePeg(sync, (TimePeg)new OffsetPeg(s.peg, -s.offset));
            }
        }
    }

    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(SpeechBehaviour.class);
        return list;
    }

    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        return list;
    }

    public double getRigidity(Behaviour beh) {
        return 0.5;
    }
}

