/*
 * Decompiled with CFR 0.152.
 */
package hmi.renderenvironment;

import asap.utils.AnimationSync;
import asap.utils.CopyEmbodiment;
import asap.utils.CopyEnvironment;
import asap.utils.Environment;
import asap.utils.RenderSync;
import hmi.animation.VJoint;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.model.Head;
import hmi.faceanimation.model.HeadManager;
import hmi.faceanimation.model.LowerJaw;
import hmi.facegraphics.GLHead;
import hmi.facegraphics.HMIFaceController;
import hmi.graphics.jogl.JOGLRenderer;
import hmi.graphics.opengl.GLBinding;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShader;
import hmi.graphics.opengl.GLShaderProgramLoader;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLSkinnedMesh;
import hmi.graphics.opengl.GLTextureLoader;
import hmi.graphics.opengl.GLUtil;
import hmi.graphics.opengl.geometry.BoxGeometry;
import hmi.graphics.opengl.geometry.CapsuleGeometry;
import hmi.graphics.opengl.geometry.DiscGeometry;
import hmi.graphics.opengl.geometry.LineGeometry;
import hmi.graphics.opengl.geometry.SphereGeometry;
import hmi.graphics.opengl.renderobjects.GLCheckerBoardGround;
import hmi.graphics.opengl.renderobjects.GLNavigation2;
import hmi.graphics.opengl.renderobjects.LightBox;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.opengl.state.GLLine;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.opengl.state.GLPoint;
import hmi.graphics.util.BufferUtil;
import hmi.graphics.util.HumanoidLoader;
import hmi.graphics.util.SceneIO;
import hmi.util.ClockListener;
import hmi.util.Resources;
import hmi.util.SystemClock;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmiRenderEnvironment
implements GLRenderObject,
Environment,
CopyEnvironment {
    private static final Logger log = LoggerFactory.getLogger(HmiRenderEnvironment.class);
    private String id = "hmirenderenvironment";
    public volatile boolean render = true;
    public boolean useVsync = true;
    public int numStencilBits = 1;
    public boolean enableFSAA = true;
    public int FSAA_samples = 4;
    public boolean weakGraphicsCard = false;
    public double fovy = 40.0;
    public double fovyNear = 0.1;
    public double fovyFar = 100.0;
    public long defaultClockFrequency = 50L;
    protected GLCanvas glCanvas;
    private float bgRed = 0.0f;
    private float bgGreen = 0.0f;
    private float bgBlue = 0.0f;
    private float bgAlpha = 1.0f;
    protected GLNavigation2 glNavControl;
    protected VJoint vjCamera;
    protected LightBox lights;
    protected JOGLRenderer renderer;
    public SystemClock renderClock;
    protected List<Runnable> renderRunners = Collections.synchronizedList(new ArrayList());
    protected volatile boolean shutdownPrepared = false;
    protected volatile boolean shutdownComplete = false;
    @GuardedBy(value="itself")
    protected Set<CopyEmbodiment> copyEmbodiments = new HashSet<CopyEmbodiment>();
    @GuardedBy(value="visualisations")
    protected HashSet<VGLNode> visualisations = new HashSet();
    protected HashSet<VGLNode> hiddenVisualisations = new HashSet();
    @GuardedBy(value="visualisationsUninitialized")
    protected HashSet<VGLNode> visualisationsUninitialized = new HashSet();
    @GuardedBy(value="glScenes")
    protected Map<String, GLScene> glScenes = new HashMap<String, GLScene>();
    protected List<String> objectIds = new ArrayList<String>();
    protected Map<String, VJoint> objectAnimationJoints = new HashMap<String, VJoint>();
    protected Map<String, VGLNode> objectVGLNodes = new HashMap<String, VGLNode>();
    protected List<String> humanoidIds = new ArrayList<String>();
    protected Map<String, VJoint> humanoidAnimationJoints = new HashMap<String, VJoint>();
    protected Map<String, VGLNode> humanoidVGLNodes = new HashMap<String, VGLNode>();
    protected Map<String, GLHead> humanoidHeads = new HashMap<String, GLHead>();
    protected Map<String, HeadManager> humanoidHeadManagers = new HashMap<String, HeadManager>();

    public HmiRenderEnvironment(boolean useVsync, int numStencilBits, boolean enableFSAA, int FSAA_samples, double fovy, double fovyNear, double fovyFar, boolean weakGraphicsCard) {
        this.useVsync = useVsync;
        this.numStencilBits = numStencilBits;
        this.enableFSAA = enableFSAA;
        this.FSAA_samples = FSAA_samples;
        this.fovy = fovy;
        this.fovyNear = fovyNear;
        this.fovyFar = fovyFar;
        this.weakGraphicsCard = weakGraphicsCard;
    }

    public HmiRenderEnvironment() {
        this(false, 1, true, 4, 40.0, 0.1, 100.0, false);
    }

    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HmiRenderEnvironment.this.initCanvas();
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.initRender();
        this.initNavigation();
        this.initLights();
    }

    protected void initCanvas() {
        GLCapabilities cap = new GLCapabilities();
        cap.setSampleBuffers(this.enableFSAA);
        cap.setNumSamples(this.FSAA_samples);
        cap.setStencilBits(this.numStencilBits);
        this.glCanvas = new GLCanvas(cap);
    }

    protected void initRender() {
        this.renderer = new JOGLRenderer((GLAutoDrawable)this.glCanvas);
        this.renderer.setFOVY(this.fovy);
        this.renderer.setNear(this.fovyNear);
        this.renderer.setFar(this.fovyFar);
        this.renderClock = new SystemClock(1000L / this.defaultClockFrequency, "DefaultRenderEnvironmentClock");
        this.renderClock.addClockListener((ClockListener)new MyRenderClockCallback());
        this.renderClock.addClockListener((ClockListener)this.renderer);
        this.renderer.setScene((GLRenderObject)this);
        this.renderer.setVsync(this.useVsync);
    }

    protected void initNavigation() {
        this.glNavControl = new GLNavigation2((Component)this.glCanvas);
        this.glNavControl.setPosition(0.0f, 1.2f, 4.0f);
        this.glNavControl.time(0.0);
        this.vjCamera = new VJoint("Camera");
        this.vjCamera.setTranslation(0.0f, 1.2f, 4.0f);
    }

    protected void initLights() {
        this.lights = new LightBox(3);
        this.lights.get(0).setDiffuseColor(0.8f, 0.8f, 0.8f);
        this.lights.get(1).setDiffuseColor(0.6f, 0.6f, 0.6f);
        this.lights.get(2).setDiffuseColor(0.6f, 0.6f, 0.6f);
        this.lights.get(0).setPosition(2.6777346f, 2.5676637f, 1.4689378f);
        this.lights.get(1).setPosition(-0.040819082f, 2.066795f, 2.1057882f);
        this.lights.get(2).setPosition(-1.7811359f, 2.6335182f, 1.9070864f);
        this.lights.get(0).setVisible(true);
        this.lights.get(1).setVisible(true);
        this.lights.get(2).setVisible(true);
        this.lights.setControl(this.glNavControl);
    }

    public void startRenderClock() {
        this.glCanvas.requestFocusInWindow();
        this.renderClock.start();
    }

    public void setViewPoint(final float[] fs) {
        if (fs.length != 3) {
            log.error("Viewpoint coordinates must be a float array of length 3");
        } else {
            this.addRenderRunner(new Runnable(){

                @Override
                public void run() {
                    HmiRenderEnvironment.this.glNavControl.setPosition(fs[0], fs[1], fs[2]);
                }
            });
        }
    }

    public void setNear(double near) {
        this.renderer.setNear(near);
    }

    public void setFar(double far) {
        this.renderer.setFar(far);
    }

    public void setFOVY(double fovy) {
        this.renderer.setFOVY(fovy);
    }

    public void setLinearVelocity(float f) {
        this.glNavControl.setLinearVelocity(f);
    }

    public void setVerticalVelocity(float f) {
        this.glNavControl.setVerticalVelocity(f);
    }

    public void setAngularVelocityY(float f) {
        this.glNavControl.setAngularVelocityY(f);
    }

    public void setStrafeVelocity(float f) {
        this.glNavControl.setStrafeVelocity(f);
    }

    public Component getAWTComponent() {
        if (this.glCanvas == null) {
            log.error("Trying to access glCanvas before HmiRenderEnvironment was properly initialised");
        }
        return this.glCanvas;
    }

    public SystemClock getRenderClock() {
        return this.renderClock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTime(double currentTime) {
        this.navigate(currentTime);
        List<Runnable> list = this.renderRunners;
        synchronized (list) {
            for (Runnable r : this.renderRunners) {
                r.run();
            }
            this.renderRunners.clear();
        }
    }

    public void addRenderRunner(Runnable r) {
        this.renderRunners.add(r);
    }

    protected void play() {
        this.renderClock.start();
    }

    public void requestPlay() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                HmiRenderEnvironment.this.play();
            }
        });
    }

    protected void pause() {
        this.renderClock.pause();
    }

    public void requestPause() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                HmiRenderEnvironment.this.pause();
            }
        });
    }

    protected void reset() {
        this.renderClock.setMediaSeconds(0.0);
    }

    public void requestReset() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                HmiRenderEnvironment.this.reset();
            }
        });
    }

    protected void shutdown() {
        this.renderClock.terminate();
    }

    public void requestShutdown() {
        this.addRenderRunner(new Runnable(){

            @Override
            public void run() {
                HmiRenderEnvironment.this.shutdown();
                HmiRenderEnvironment.this.shutdownComplete = true;
            }
        });
        this.shutdownPrepared = true;
    }

    public boolean isShutdown() {
        return this.shutdownComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addVisualisation(VGLNode viz) {
        HashSet<VGLNode> hashSet = this.visualisations;
        synchronized (hashSet) {
            if (this.hasVisualisation(viz)) {
                log.warn("Trying to add visualsation twice");
                return;
            }
            this.visualisationsUninitialized.add(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHumanoidGLScene(String id, GLScene gls) {
        Map<String, GLScene> map = this.glScenes;
        synchronized (map) {
            this.glScenes.put(id, gls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHumanoidGLScene(String id) {
        Map<String, GLScene> map = this.glScenes;
        synchronized (map) {
            this.glScenes.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasVisualisation(VGLNode viz) {
        HashSet<VGLNode> hashSet = this.visualisations;
        synchronized (hashSet) {
            if (this.visualisationsUninitialized.contains(viz)) {
                return true;
            }
            if (this.visualisations.contains(viz)) {
                return true;
            }
            if (this.hiddenVisualisations.contains(viz)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isVisualisationVisible(VGLNode viz) {
        HashSet<VGLNode> hashSet = this.visualisations;
        synchronized (hashSet) {
            return this.visualisations.contains(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVisualisationVisible(VGLNode viz, boolean enabled) {
        HashSet<VGLNode> hashSet = this.visualisations;
        synchronized (hashSet) {
            if (!enabled) {
                if (this.visualisations.contains(viz)) {
                    this.hiddenVisualisations.add(viz);
                    this.visualisations.remove(viz);
                } else if (this.visualisationsUninitialized.contains(viz)) {
                    this.hiddenVisualisations.add(viz);
                } else if (!this.hiddenVisualisations.contains(viz)) {
                    log.error("Attempting to hide non-existing VGLNode " + viz.getRoot().getId());
                }
            } else if (this.hiddenVisualisations.contains(viz)) {
                this.hiddenVisualisations.remove(viz);
                this.visualisations.add(viz);
            } else if (!this.visualisationsUninitialized.contains(viz) && !this.visualisations.contains(viz)) {
                log.error("Attempting to show non-existing VGLNode " + viz.getRoot().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeVisualisation(VGLNode viz) {
        HashSet<VGLNode> hashSet = this.visualisations;
        synchronized (hashSet) {
            this.visualisationsUninitialized.remove(viz);
            this.visualisations.remove(viz);
            this.hiddenVisualisations.remove(viz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCopyEmbodiment(CopyEmbodiment ce) {
        Set<CopyEmbodiment> set = this.copyEmbodiments;
        synchronized (set) {
            this.copyEmbodiments.add(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCopyEmbodiments(List<CopyEmbodiment> ces) {
        Set<CopyEmbodiment> set = this.copyEmbodiments;
        synchronized (set) {
            this.copyEmbodiments.addAll(ces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCopyEmbodiments(List<CopyEmbodiment> ces) {
        Set<CopyEmbodiment> set = this.copyEmbodiments;
        synchronized (set) {
            this.copyEmbodiments.removeAll(ces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCopyEmbodiment(CopyEmbodiment ce) {
        Set<CopyEmbodiment> set = this.copyEmbodiments;
        synchronized (set) {
            this.copyEmbodiments.remove(ce);
        }
    }

    protected void glPreInit(GLRenderContext glc) {
        glc.glEnable(2977);
        glc.glEnable(2929);
        glc.glCullFace(1029);
        glc.glEnable(2884);
        glc.glShadeModel(7425);
        glc.glEnable(2896);
        glc.glLightModeli(2897, 1);
        glc.glPolygonMode(1032, 6914);
        float[] global_amb = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        FloatBuffer global_ambient = BufferUtil.directFloatBuffer((int)4);
        global_ambient.put(global_amb);
        global_ambient.rewind();
        glc.glLightModelfv(2899, global_ambient);
        glc.glEnable(2977);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glInit(GLRenderContext glc) {
        this.glPreInit(glc);
        this.lights.glInit(glc);
        HashSet<VGLNode> hashSet = this.visualisations;
        synchronized (hashSet) {
            for (VGLNode nextVgl : this.visualisationsUninitialized) {
                nextVgl.glInit(glc);
                HashSet<VGLNode> hashSet2 = this.visualisations;
                synchronized (hashSet2) {
                    this.visualisations.add(nextVgl);
                }
            }
            this.visualisationsUninitialized.clear();
        }
        this.glNavControl.glInit(glc);
        GLUtil.reportGLErrors((GLBinding)glc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void glPreRender(GLRenderContext glc) {
        glc.glDisable(3042);
        glc.glDepthMask(true);
        glc.glClear(17664);
        glc.glClearColor(this.bgRed, this.bgGreen, this.bgBlue, this.bgAlpha);
        glc.glMatrixMode(5888);
        glc.glLoadIdentity();
        HashSet<VGLNode> hashSet = this.visualisations;
        synchronized (hashSet) {
            for (VGLNode nextVgl : this.visualisationsUninitialized) {
                nextVgl.glInit(glc);
                if (this.hiddenVisualisations.contains(nextVgl)) continue;
                this.visualisations.add(nextVgl);
            }
            this.visualisationsUninitialized.clear();
        }
    }

    protected void glPostRender(GLRenderContext glc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnimationResultForRender(GLRenderContext glc) {
        Object object = AnimationSync.getSync();
        synchronized (object) {
            for (VJoint vj : this.objectAnimationJoints.values()) {
                vj.calculateMatrices();
            }
            for (CopyEmbodiment ce : this.copyEmbodiments) {
                ce.copy();
            }
            Map<String, GLScene> map = this.glScenes;
            synchronized (map) {
                for (GLScene gls : this.glScenes.values()) {
                    gls.doMorph();
                    gls.deform();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glRender(GLRenderContext glc) {
        if (!this.render) {
            return;
        }
        Object object = RenderSync.getSync();
        synchronized (object) {
            if (this.shutdownPrepared) {
                return;
            }
            this.glPreRender(glc);
            this.glNavControl.glRender(glc);
            this.lights.glRender(glc);
            this.processAnimationResultForRender(glc);
            HashSet<VGLNode> hashSet = this.visualisations;
            synchronized (hashSet) {
                for (VGLNode nextVgl : this.visualisations) {
                    if (this.weakGraphicsCard) {
                        glc.glPushAttrib(1048575);
                        glc.glPushClientAttrib(-1);
                    }
                    if (this.hiddenVisualisations.contains(nextVgl)) {
                        log.error("HELP!");
                    }
                    nextVgl.glRender(glc);
                    glc.glDisable(3042);
                    glc.glDepthMask(true);
                    if (!this.weakGraphicsCard) continue;
                    glc.glPopClientAttrib();
                    glc.glPopAttrib();
                }
            }
            this.glPostRender(glc);
            GLUtil.reportGLErrors((GLBinding)glc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void navigate(double currentTime) {
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.glNavControl.time(currentTime);
            this.vjCamera.setTranslation(this.glNavControl.getPosition());
        }
    }

    public VJoint getCameraTarget() {
        return this.vjCamera;
    }

    public void setObjectVisible(String id, boolean visible) {
        if (!this.objectAnimationJoints.containsKey(id)) {
            log.error("Trying to show or hide a rendering object with an ID that does not exist");
            return;
        }
        VGLNode obj = this.objectVGLNodes.get(id);
        this.setVisualisationVisible(obj, visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadObject(String id) {
        if (!this.objectAnimationJoints.containsKey(id)) {
            log.error("Trying to unload a rendering object with an ID that does not exist: {}", (Object)id);
            return;
        }
        VGLNode model = this.objectVGLNodes.get(id);
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.removeVisualisation(model);
            this.objectIds.remove(id);
            this.objectAnimationJoints.remove(id);
            this.objectVGLNodes.remove(id);
        }
    }

    public VJoint getObjectRootJoint(String id) {
        return this.objectAnimationJoints.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectParent(String childId, String parentId) {
        VGLNode child = this.objectVGLNodes.get(childId);
        if (child == null) {
            log.error("Adding nonexisting child to parent");
        }
        this.objectVGLNodes.get(parentId).addChild(child);
        HashSet<VGLNode> hashSet = this.visualisations;
        synchronized (hashSet) {
            if (this.hiddenVisualisations.contains(child)) {
                this.hiddenVisualisations.add(this.objectVGLNodes.get(parentId));
            }
            this.visualisations.remove(this.objectVGLNodes.get(parentId));
            this.visualisationsUninitialized.add(this.objectVGLNodes.get(parentId));
        }
        this.unloadObject(childId);
    }

    public VJoint insertParentJointForObject(String id) {
        this.loadEmptyObject("parent_" + id);
        this.setObjectParent(id, "parent_" + id);
        return this.getObjectRootJoint("parent_" + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadObject(String id, String texturedirectory, String resourcedirectory, String filename) {
        if (this.objectAnimationJoints.containsKey(id)) {
            log.error("Trying to load a rendering object with an ID that already exists");
            return;
        }
        if (texturedirectory != null) {
            GLTextureLoader.addTextureDirectory((String)texturedirectory);
        }
        GLScene theGLScene = null;
        theGLScene = SceneIO.readGLScene((String)resourcedirectory, (String)filename);
        VJoint modelRenderJoint = new VJoint(id);
        for (VJoint nextJoint : theGLScene.getVJointRoots()) {
            modelRenderJoint.addChild(nextJoint);
        }
        VGLNode model = new VGLNode(modelRenderJoint, theGLScene.getGLShapeList());
        GLShape state = new GLShape();
        state.addGLState((GLRenderObject)new GLFill());
        model.getGLShapeList().prepend((GLRenderObject)state);
        VJoint modelAnimationJoint = modelRenderJoint.masterCopyTree("");
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.addVisualisation(model);
            this.objectIds.add(id);
            this.objectAnimationJoints.put(id, modelAnimationJoint);
            this.objectVGLNodes.put(id, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEmptyObject(String id) {
        if (this.objectAnimationJoints.containsKey(id)) {
            log.error("Trying to construct an empty object with an ID that already exists: {}", (Object)id);
            return;
        }
        VJoint bsRenderJoint = new VJoint(id);
        GLRenderList shapeList = new GLRenderList(1);
        VGLNode vglBS = new VGLNode(bsRenderJoint, shapeList);
        VJoint bsAnimationJoint = vglBS.getRoot();
        bsAnimationJoint.setId(id);
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.addVisualisation(vglBS);
            this.objectIds.add(id);
            this.objectAnimationJoints.put(id, bsAnimationJoint);
            this.objectVGLNodes.put(id, vglBS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBasicShape(String id, GLRenderObject glro, RenderStyle style, float[] diffuse, float[] specular, float[] ambient, float[] emission) {
        if (this.objectAnimationJoints.containsKey(id)) {
            log.error("Trying to construct a basic object with an ID that already exists: {}", (Object)id);
            return;
        }
        VJoint bsRenderJoint = new VJoint("render joint " + id);
        GLShape bsShape = new GLShape("shape " + id);
        GLRenderList shapeList = new GLRenderList(1);
        GLMaterial colorState = new GLMaterial();
        colorState.setDiffuseColor(diffuse);
        colorState.setSpecularColor(specular);
        colorState.setAmbientColor(ambient);
        colorState.setEmissionColor(emission);
        colorState.setGLShader(new GLShader("blinnBasic", new String[0]));
        switch (style) {
            case FILL: {
                bsShape.addGLGeometry((GLRenderObject)new GLFill());
                break;
            }
            case LINE: {
                bsShape.addGLGeometry((GLRenderObject)new GLLine());
                break;
            }
            case VERTEX: {
                bsShape.addGLGeometry((GLRenderObject)new GLPoint());
            }
        }
        bsShape.addGLGeometry((GLRenderObject)colorState);
        bsShape.addGLGeometry(glro);
        bsShape.linkToTransformMatrix(bsRenderJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)bsShape);
        VGLNode vglBS = new VGLNode(bsRenderJoint, shapeList);
        VJoint bsAnimationJoint = vglBS.getRoot();
        bsAnimationJoint.setId(id);
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.addVisualisation(vglBS);
            this.objectIds.add(id);
            this.objectAnimationJoints.put(id, bsAnimationJoint);
            this.objectVGLNodes.put(id, vglBS);
        }
    }

    public void loadDisc(String id, float radius1, float radius2, float radius3, int numSlices, int numStacks, RenderStyle style, float[] diffuse, float[] specular, float[] ambient, float[] emission) {
        DiscGeometry discGeometry = new DiscGeometry(radius1, radius2, radius3, numSlices, numStacks);
        this.loadBasicShape(id, (GLRenderObject)discGeometry, style, diffuse, specular, ambient, emission);
    }

    public void loadBox(String id, float[] halfExtends, RenderStyle style, float[] diffuse, float[] specular, float[] ambient, float[] emission) {
        BoxGeometry boxGeometry = new BoxGeometry(halfExtends);
        this.loadBasicShape(id, (GLRenderObject)boxGeometry, style, diffuse, specular, ambient, emission);
    }

    public void loadSphere(String id, float radius, int numSlices, int numStacks, RenderStyle style, float[] diffuse, float[] specular, float[] ambient, float[] emission) {
        SphereGeometry sphereGeometry = new SphereGeometry(radius, numSlices, numStacks);
        this.loadBasicShape(id, (GLRenderObject)sphereGeometry, style, diffuse, specular, ambient, emission);
    }

    public void loadCapsule(String id, float radius, float height, int numSlices, int numStacks, RenderStyle style, float[] diffuse, float[] specular, float[] ambient, float[] emission) {
        CapsuleGeometry capsuleGeometry = new CapsuleGeometry(radius, height, numSlices, numStacks);
        this.loadBasicShape(id, (GLRenderObject)capsuleGeometry, style, diffuse, specular, ambient, emission);
    }

    public void loadLine(String id, float[] vertices, float[] diffuse, float[] specular, float[] ambient, float[] emission) {
        LineGeometry lineGeometry = new LineGeometry(vertices);
        this.loadBasicShape(id, (GLRenderObject)lineGeometry, RenderStyle.LINE, diffuse, specular, ambient, emission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisCross(String id, float axisLengthCm) {
        if (this.objectAnimationJoints.containsKey(id)) {
            log.error("Trying to construct an axis cross object with an ID that already exists: {}", (Object)id);
            return;
        }
        VJoint axisRenderJoint = new VJoint(id);
        GLShape axisAttrs = new GLShape("axis attributes " + id);
        GLRenderList shapeList = new GLRenderList(1);
        GLMaterial shaderMat = new GLMaterial();
        shaderMat.setGLShader(new GLShader("blinnBasic", new String[0]));
        axisAttrs.addGLGeometry((GLRenderObject)new GLFill());
        axisAttrs.addGLGeometry((GLRenderObject)shaderMat);
        shapeList.add((GLRenderObject)axisAttrs);
        GLShape glsShape = null;
        SphereGeometry geometry = null;
        GLMaterial material = null;
        float[] red = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
        float[] green = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
        float[] blue = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
        float[] white = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        material = new GLMaterial();
        material.setEmissionColor(white);
        material.setDiffuseColor(white);
        material.setSpecularColor(white);
        material.setAmbientColor(white);
        material.setGLShader(new GLShader("blinnBasic", new String[0]));
        geometry = new SphereGeometry(axisLengthCm * 0.001f, 4, 4);
        glsShape = new GLShape("axis shape white " + id);
        glsShape.addGLState((GLRenderObject)material);
        glsShape.addGLGeometry((GLRenderObject)geometry);
        glsShape.linkToTransformMatrix(axisRenderJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)glsShape);
        material = new GLMaterial();
        material.setEmissionColor(red);
        material.setDiffuseColor(red);
        material.setSpecularColor(red);
        material.setAmbientColor(red);
        material.setGLShader(new GLShader("blinnBasic", new String[0]));
        geometry = new BoxGeometry(new float[]{axisLengthCm * 0.005f, axisLengthCm * 5.0E-4f, axisLengthCm * 5.0E-4f}, new float[]{axisLengthCm * 0.005f, 0.0f, 0.0f});
        glsShape = new GLShape("axis shape red " + id);
        glsShape.addGLState((GLRenderObject)material);
        glsShape.addGLGeometry((GLRenderObject)geometry);
        glsShape.linkToTransformMatrix(axisRenderJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)glsShape);
        material = new GLMaterial();
        material.setEmissionColor(green);
        material.setDiffuseColor(green);
        material.setSpecularColor(green);
        material.setAmbientColor(green);
        material.setGLShader(new GLShader("blinnBasic", new String[0]));
        geometry = new BoxGeometry(new float[]{axisLengthCm * 5.0E-4f, axisLengthCm * 0.005f, axisLengthCm * 5.0E-4f}, new float[]{0.0f, axisLengthCm * 0.005f, 0.0f});
        glsShape = new GLShape("axis shape green " + id);
        glsShape.addGLState((GLRenderObject)material);
        glsShape.addGLGeometry((GLRenderObject)geometry);
        glsShape.linkToTransformMatrix(axisRenderJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)glsShape);
        material = new GLMaterial();
        material.setEmissionColor(blue);
        material.setDiffuseColor(blue);
        material.setSpecularColor(blue);
        material.setAmbientColor(blue);
        material.setGLShader(new GLShader("blinnBasic", new String[0]));
        geometry = new BoxGeometry(new float[]{axisLengthCm * 5.0E-4f, axisLengthCm * 5.0E-4f, axisLengthCm * 0.005f}, new float[]{0.0f, 0.0f, axisLengthCm * 0.005f});
        glsShape = new GLShape("axis shape blue " + id);
        glsShape.addGLState((GLRenderObject)material);
        glsShape.addGLGeometry((GLRenderObject)geometry);
        glsShape.linkToTransformMatrix(axisRenderJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)glsShape);
        VGLNode vglAxis = new VGLNode(axisRenderJoint, shapeList);
        VJoint axisAnimationJoint = vglAxis.getRoot();
        axisAnimationJoint.setId(id);
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.addVisualisation(vglAxis);
            this.objectIds.add(id);
            this.objectAnimationJoints.put(id, axisAnimationJoint);
            this.objectVGLNodes.put(id, vglAxis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCheckerBoardGround(String id, float width, float height) {
        if (this.objectAnimationJoints.containsKey(id)) {
            log.error("Trying to construct a checkerboardground with an ID that already exists");
            return;
        }
        VJoint groundRenderJoint = new VJoint("Ground render joint");
        GLShape groundShape = new GLShape("Ground shape");
        GLRenderList shapeList = new GLRenderList(1);
        groundShape.addGLGeometry((GLRenderObject)new GLCheckerBoardGround(width, height));
        groundShape.linkToTransformMatrix(groundRenderJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)groundShape);
        VGLNode vglGround = new VGLNode(groundRenderJoint, shapeList);
        VJoint groundAnimationJoint = vglGround.getRoot();
        groundAnimationJoint.setId(id);
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.addVisualisation(vglGround);
            this.objectIds.add(id);
            this.objectAnimationJoints.put(id, groundAnimationJoint);
            this.objectVGLNodes.put(id, vglGround);
        }
    }

    public void setBackground(float r, float g, float b) {
        this.bgRed = r;
        this.bgGreen = g;
        this.bgBlue = b;
    }

    public void setHumanoidVisible(String id, boolean visible) {
        if (!this.humanoidAnimationJoints.containsKey(id)) {
            log.error("Trying to show or hide a virtual human with an ID that does not exist");
            return;
        }
        VGLNode vglVH = this.humanoidVGLNodes.get(id);
        this.setVisualisationVisible(vglVH, visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHumanoid(String id, String resourcedirectory, String texturedirectory, String shaderdirectory, String filename, String postprocessing, HashMap<String, Float> permanentmorphtargets) {
        Object object = RenderSync.getSync();
        synchronized (object) {
            Object object2 = AnimationSync.getSync();
            synchronized (object2) {
                if (this.humanoidAnimationJoints.containsKey(id)) {
                    log.error("Trying to load a humanoid with an ID that already exists");
                    return;
                }
                if (texturedirectory != null) {
                    GLTextureLoader.addTextureDirectory((String)texturedirectory);
                }
                if (shaderdirectory != null) {
                    GLTextureLoader.addTextureDirectory((String)shaderdirectory);
                }
                if (shaderdirectory != null) {
                    GLShaderProgramLoader.addShaderDirectory((String)shaderdirectory);
                }
                HumanoidLoader humanoidLoader = null;
                try {
                    humanoidLoader = new HumanoidLoader(id, resourcedirectory, filename, postprocessing);
                }
                catch (IOException ex) {
                    log.error("Error loading humanoid: {}", (Throwable)ex);
                    return;
                }
                VGLNode model = humanoidLoader.getAvatarRenderNode();
                VJoint humanoidAnimationRoot = humanoidLoader.getAvatarAnimationRootJoint();
                GLScene theGLScene = humanoidLoader.getGLScene();
                for (Map.Entry<String, Float> entry : permanentmorphtargets.entrySet()) {
                    theGLScene.addMorphTargets(new String[]{entry.getKey()}, new float[]{entry.getValue().floatValue()});
                }
                Object object3 = AnimationSync.getSync();
                synchronized (object3) {
                    this.addVisualisation(model);
                    this.humanoidIds.add(id);
                    this.addHumanoidGLScene(id, theGLScene);
                    this.humanoidAnimationJoints.put(id, humanoidAnimationRoot);
                    this.humanoidVGLNodes.put(id, model);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadHumanoid(String id) {
        if (!this.humanoidAnimationJoints.containsKey(id)) {
            log.error("Trying to unload a humanoid with an ID that does not exist");
            return;
        }
        VGLNode model = this.humanoidVGLNodes.get(id);
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.removeVisualisation(model);
            this.humanoidIds.remove(id);
            this.removeHumanoidGLScene(id);
            this.humanoidAnimationJoints.remove(id);
            this.humanoidVGLNodes.remove(id);
        }
    }

    public VJoint getHumanoidRootJoint(String id) {
        return this.humanoidAnimationJoints.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaceController loadFace(String id, String fapDeformFile, String fapDeformResources, String fapDeformMesh, Collection<String> faceExpressionMorphTargets) {
        HMIFaceController fc = null;
        Object object = RenderSync.getSync();
        synchronized (object) {
            Object object2 = AnimationSync.getSync();
            synchronized (object2) {
                GLHead head = null;
                GLScene gls = this.glScenes.get(id);
                HeadManager headManager = null;
                if (fapDeformFile != null) {
                    BufferedReader br = new Resources(fapDeformResources).getReader(fapDeformFile);
                    headManager = new HeadManager(br);
                    headManager.setHead((Head)new GLHead());
                    head = (GLHead)headManager.readXMLFile();
                    if (head == null) {
                        throw new RuntimeException("did not manage to load facemesh data from " + fapDeformFile);
                    }
                    GLRenderList geomList = this.getFaceShape(fapDeformMesh, this.humanoidVGLNodes.get(id)).getGeometryList();
                    int geomListSize = geomList.size();
                    if (geomListSize == 0) {
                        throw new RuntimeException("no geomlist");
                    }
                    GLSkinnedMesh faceMesh = (GLSkinnedMesh)geomList.get(0);
                    head.setFaceMesh(faceMesh);
                    LowerJaw lowerJaw = new LowerJaw(this.humanoidAnimationJoints.get(id).getPart("temporomandibular"));
                    head.setLowerJaw(lowerJaw);
                }
                fc = new HMIFaceController(gls, head);
                this.humanoidHeads.put(id, head);
                this.humanoidHeadManagers.put(id, headManager);
                fc.setPossibleFaceMorphTargetNames(faceExpressionMorphTargets);
            }
        }
        return fc;
    }

    private GLShape getFaceShape(String shapeId, VGLNode renderNode) {
        GLRenderList shapeList = renderNode.getGLShapeList();
        for (int i = 0; i < shapeList.size(); ++i) {
            GLShape shape = (GLShape)shapeList.get(i);
            if (shape.getId() == null || !shape.getId().equals(shapeId)) continue;
            return shape;
        }
        throw new RuntimeException("Cannot find face shape with id " + shapeId);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static enum RenderStyle {
        LINE,
        VERTEX,
        FILL;

    }

    class MyRenderClockCallback
    implements ClockListener {
        MyRenderClockCallback() {
        }

        public void initTime(double time) {
        }

        public void time(double currentTime) {
            HmiRenderEnvironment.this.renderTime(currentTime);
        }
    }
}

