/*
 * Decompiled with CFR 0.152.
 */
package hmi.physicsenvironment;

import asap.environment.AsapVirtualHuman;
import asap.environment.EmbodimentLoader;
import asap.environment.Loader;
import asap.utils.Embodiment;
import asap.utils.Environment;
import hmi.physics.MixedSkeletonEmbodiment;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.assembler.PhysicalHumanoidAssembler;
import hmi.physicsenvironment.OdePhysicsEnvironment;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdePhysicalHumanoidEmbodiment
implements EmbodimentLoader,
Embodiment {
    private static final Logger log = LoggerFactory.getLogger(OdePhysicalHumanoidEmbodiment.class);
    private OdePhysicsEnvironment ope = null;
    private AsapVirtualHuman theVirtualHuman = null;
    private PhysicalHumanoid pHuman;
    private MixedSkeletonEmbodiment mse;
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private String id = "";

    public void unload() {
        log.debug("Removing VH from Physics");
        this.ope.clearPhysicalHumanoid(this.pHuman);
    }

    public void readXML(XMLTokenizer tokenizer, String newId, AsapVirtualHuman avh, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        this.theVirtualHuman = avh;
        for (Environment environment : environments) {
            if (!(environment instanceof OdePhysicsEnvironment)) continue;
            this.ope = (OdePhysicsEnvironment)environment;
        }
        for (Environment environment : requiredLoaders) {
            if (!(environment instanceof EmbodimentLoader) || !(((EmbodimentLoader)environment).getEmbodiment() instanceof MixedSkeletonEmbodiment)) continue;
            this.mse = (MixedSkeletonEmbodiment)((EmbodimentLoader)environment).getEmbodiment();
        }
        if (this.ope == null) {
            throw new RuntimeException("OdePhysicalEmbodiment requires an Environment of type OdePhysicalEnvironment");
        }
        if (this.mse == null) {
            throw new RuntimeException("OdePhysicalEmbodiment requires an EmbodimentLoader containing a MixedSkeletonEmbodiment");
        }
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        if (!tokenizer.atSTag("PhysicalHumanoidDef")) {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
        HashMap attrMap2 = tokenizer.getAttributes();
        String msFile = this.adapter.getRequiredAttribute("filename", attrMap2, tokenizer);
        String msResources = this.adapter.getRequiredAttribute("resources", attrMap2, tokenizer);
        this.pHuman = this.ope.createPhysicalHumanoid(this.theVirtualHuman.getId() + "_" + this.getId());
        PhysicalHumanoidAssembler psa = new PhysicalHumanoidAssembler(this.mse.getCurrentVJoint(), this.pHuman);
        psa.readXML((Reader)new Resources(msResources).getReader(msFile));
        tokenizer.takeSTag("PhysicalHumanoidDef");
        tokenizer.takeETag("PhysicalHumanoidDef");
    }

    public Embodiment getEmbodiment() {
        return this;
    }

    public PhysicalHumanoid getPhysicalHuman() {
        return this.pHuman;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

