/*
 * Decompiled with CFR 0.152.
 */
package hmi.physicsenvironment;

import asap.environment.AsapVirtualHuman;
import asap.environment.EmbodimentLoader;
import asap.environment.Loader;
import asap.utils.Embodiment;
import asap.utils.Environment;
import hmi.physics.MixedSkeletonEmbodiment;
import hmi.physics.PhysicalEmbodiment;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.mixed.MixedSystem;
import hmi.physics.ode.OdeHumanoid;
import hmi.physicsenvironment.OdePhysicsEnvironment;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.odejava.JointGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdePhysicalEmbodiment
implements PhysicalEmbodiment,
EmbodimentLoader {
    private static final Logger log = LoggerFactory.getLogger(OdePhysicalEmbodiment.class);
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private boolean glueFeetToFloor = false;
    private MixedSkeletonEmbodiment mse = null;
    private OdePhysicsEnvironment ope = null;
    private AsapVirtualHuman theVirtualHuman = null;
    private ArrayList<MixedSystem> mixedSystems = null;
    private ArrayList<PhysicalHumanoid> physicalHumans = null;
    private JointGroup feetGlueJointGroup = new JointGroup();
    private String id = "";

    public void unload() {
        log.debug("Removing VH from Physics");
        for (PhysicalHumanoid nextPH : this.getPhysicalHumans()) {
            this.ope.clearPhysicalHumanoid(nextPH);
        }
        this.ope.clearFeetGlueJointGroup(this.feetGlueJointGroup);
    }

    public ArrayList<MixedSystem> getMixedSystems() {
        return this.mixedSystems;
    }

    public ArrayList<PhysicalHumanoid> getPhysicalHumans() {
        return this.physicalHumans;
    }

    public void readXML(XMLTokenizer tokenizer, String newId, AsapVirtualHuman avh, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        this.theVirtualHuman = avh;
        for (Environment environment : environments) {
            if (!(environment instanceof OdePhysicsEnvironment)) continue;
            this.ope = (OdePhysicsEnvironment)environment;
        }
        for (Environment environment : requiredLoaders) {
            if (!(environment instanceof EmbodimentLoader) || !(((EmbodimentLoader)environment).getEmbodiment() instanceof MixedSkeletonEmbodiment)) continue;
            this.mse = (MixedSkeletonEmbodiment)((EmbodimentLoader)environment).getEmbodiment();
        }
        if (this.ope == null) {
            throw new RuntimeException("OdePhysicalEmbodiment requires an Environment of type OdePhysicalEnvironment");
        }
        if (this.mse == null) {
            throw new RuntimeException("OdePhysicalEmbodiment requires an EmbodimentLoader containing a MixedSkeletonEmbodiment");
        }
        this.physicalHumans = new ArrayList();
        this.mixedSystems = new ArrayList();
        OdeHumanoid pHumanEmpty = this.ope.createPhysicalHumanoid(this.theVirtualHuman.getId() + "_empty_" + newId);
        this.physicalHumans.add((PhysicalHumanoid)pHumanEmpty);
        float[] g = new float[]{0.0f, 0.0f, 0.0f};
        MixedSystem mSystem = this.ope.createMixedSystem(g, pHumanEmpty);
        this.mixedSystems.add(mSystem);
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        if (tokenizer.atSTag("GlueFeetToFloor")) {
            this.glueFeetToFloor = true;
            tokenizer.takeSTag("GlueFeetToFloor");
            tokenizer.takeETag("GlueFeetToFloor");
        } else if (tokenizer.atSTag("MixedSystems")) {
            float[] g = new float[]{0.0f, 0.0f, 0.0f};
            int i = 0;
            tokenizer.takeSTag("MixedSystems");
            while (tokenizer.atSTag()) {
                String tag = tokenizer.getTagName();
                if (!tag.equals("MixedSystem")) {
                    throw new XMLScanException("Unknown tag in MixedSystemss: " + tag);
                }
                HashMap attrMap2 = tokenizer.getAttributes();
                String msFile = this.adapter.getRequiredAttribute("filename", attrMap2, tokenizer);
                String msName = this.adapter.getRequiredAttribute("name", attrMap2, tokenizer);
                String msResources = this.adapter.getOptionalAttribute("resources", attrMap2, "");
                i = this.physicalHumans.size();
                OdeHumanoid pHuman = this.ope.createPhysicalHumanoid(this.theVirtualHuman.getId() + "_" + this.getId() + "_" + i + "_" + msName);
                g = new float[]{0.0f, -9.8f, 0.0f};
                MixedSystem mSystem = null;
                try {
                    mSystem = this.ope.createMixedSystem(g, pHuman, this.mse.getCurrentVJoint(), msResources, msFile);
                }
                catch (IOException ex) {
                    log.error("Cannot load mixed system {} from file \"{}\"; dropping mixed system.", (Object)msName, (Object)msFile);
                    continue;
                }
                this.mixedSystems.add(mSystem);
                this.physicalHumans.add((PhysicalHumanoid)pHuman);
                this.ope.initPhysicalHumanoid(pHuman);
                tokenizer.takeSTag(tag);
                tokenizer.takeETag(tag);
            }
            tokenizer.takeETag("MixedSystems");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
    }

    public void glueFeetToFloor() {
        if (this.glueFeetToFloor) {
            for (int i = 1; i < this.physicalHumans.size(); ++i) {
                OdeHumanoid pHuman = (OdeHumanoid)this.physicalHumans.get(i);
                this.ope.glueFeetToFloor((PhysicalHumanoid)pHuman, this.feetGlueJointGroup);
            }
        }
    }

    public Embodiment getEmbodiment() {
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

