/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.inversedynamics;

import hmi.math.Mat4f;
import hmi.math.SpatialInertiaTensor;
import hmi.math.Vec3f;
import hmi.physics.featherstone.RNEASolver;
import hmi.physics.inversedynamics.IDSegment;

public class IDBranch {
    public RNEASolver solver;
    private IDSegment root;
    private IDSegment[] segments;
    private int chainSize = 0;

    public IDSegment[] getSegments() {
        return this.segments;
    }

    public void setRoot(IDSegment root) {
        this.root = root;
    }

    private int getSize(IDSegment seg, int startSize) {
        int size = 1;
        for (IDSegment segChild : seg.getChildren()) {
            size += this.getSize(segChild, 0);
        }
        return startSize + size;
    }

    private int fillSegments(IDSegment seg, int[] parents, int nr, int p) {
        this.segments[nr] = seg;
        parents[nr] = p;
        int par = nr;
        int number = nr;
        for (IDSegment segChild : seg.getChildren()) {
            number = this.fillSegments(segChild, parents, number + 1, par);
        }
        return number;
    }

    public float getMassOffset(IDSegment seg, float[] transform, float[] q, int qIndex, float[] result, float mass) {
        float[] tempM2 = new float[16];
        float[] tempM1 = new float[16];
        float[] c = new float[3];
        Mat4f.set((float[])tempM1, (float[])transform);
        int iq = qIndex;
        Mat4f.setIdentity((float[])tempM2);
        Mat4f.setRotation((float[])tempM2, (int)0, (float[])q, (int)iq);
        Mat4f.setTranslation((float[])tempM2, (float[])seg.translation);
        Mat4f.mul((float[])tempM1, (float[])tempM2);
        Mat4f.transformPoint((float[])tempM1, (float[])c, (float[])seg.com);
        Vec3f.scale((float)seg.mass, (float[])c);
        Vec3f.add((float[])result, (float[])c);
        mass += seg.mass;
        iq += 4;
        for (IDSegment segChild : seg.getChildren()) {
            mass = this.getMassOffset(segChild, tempM1, q, iq, result, mass);
        }
        return mass;
    }

    public float getMassOffset(float[] connectorTransform, float[] q, int qIndex, float[] result) {
        return this.getMassOffset(this.root, connectorTransform, q, qIndex, result, 0.0f);
    }

    public void setupSolver() {
        this.chainSize = this.getSize(this.root, 0);
        float[] spatialI = new float[13 * this.chainSize];
        float[] translations = new float[3 * this.chainSize];
        int[] parents = new int[this.chainSize];
        this.segments = new IDSegment[this.chainSize];
        this.fillSegments(this.root, parents, 0, -1);
        for (int i = 0; i < this.chainSize; ++i) {
            Vec3f.set((float[])translations, (int)(i * 3), (float[])this.segments[i].translation, (int)0);
            SpatialInertiaTensor.set((float[])spatialI, (int)(13 * i), (float[])this.segments[i].I, (float[])this.segments[i].com, (float)this.segments[i].mass);
        }
        this.solver = new RNEASolver(this.chainSize, translations, spatialI, parents);
    }

    public int getSize() {
        return this.chainSize;
    }

    public IDSegment getRoot() {
        return this.root;
    }
}

