/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics;

import hmi.animation.VObject;
import hmi.math.Quat4f;
import hmi.physics.CollisionBox;
import hmi.physics.CollisionCapsule;
import hmi.physics.CollisionShape;
import hmi.physics.CollisionSphere;
import hmi.physics.Mass;
import java.util.ArrayList;

public abstract class RigidBody
implements VObject {
    protected ArrayList<float[]> rotationBuffer = new ArrayList();
    protected ArrayList<float[]> translationBuffer = new ArrayList();
    protected ArrayList<CollisionShape> collisionShapes = new ArrayList();
    protected String id = "";
    protected String sid = "";
    protected String name = "";

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setMass(Mass m) {
        this.adjustMass(m.getMass());
        float[] I = new float[9];
        m.getInertiaTensor(I);
        this.setInertiaTensor(I);
    }

    public void copy() {
        for (float[] rotBuf : this.rotationBuffer) {
            this.getRotation(rotBuf);
        }
        for (float[] transBuf : this.translationBuffer) {
            this.getTranslation(transBuf);
        }
    }

    public void clear() {
        this.collisionShapes.clear();
    }

    public abstract CollisionBox addBox(float[] var1);

    public abstract CollisionBox addBox(float[] var1, float[] var2, float[] var3);

    public abstract CollisionSphere addSphere(float var1);

    public abstract CollisionSphere addSphere(float[] var1, float var2);

    public abstract CollisionCapsule addCapsule(float[] var1, float[] var2, float var3, float var4);

    public abstract CollisionCapsule addCapsule(float var1, float var2);

    public abstract void removeCollisionShape(CollisionShape var1);

    public void addRotationBuffer(float[] rotBuf) {
        this.rotationBuffer.add(rotBuf);
    }

    public void addTranslationBuffer(float[] transBuf) {
        this.translationBuffer.add(transBuf);
    }

    public abstract void setEnabled(boolean var1);

    public abstract void getCOM(float[] var1);

    public abstract void getInertiaTensor(float[] var1);

    public abstract void setCOM(float[] var1);

    public abstract void setInertiaTensor(float[] var1);

    public abstract void rotateInertiaTensor(float[] var1);

    public abstract void translateInertiaTensor(float[] var1);

    public abstract float getMass();

    public abstract void getTorque(float[] var1);

    public abstract void getForce(float[] var1);

    public abstract void setTranslation(float var1, float var2, float var3);

    public void setTranslation(float[] pos) {
        this.setTranslation(pos[0], pos[1], pos[2]);
    }

    public void setTranslation(float[] ta, int taIndex) {
        this.setTranslation(ta[taIndex], ta[taIndex + 1], ta[taIndex + 2]);
    }

    public abstract void getTranslation(float[] var1);

    public abstract void setRotation(float var1, float var2, float var3, float var4);

    public void setRotation(float[] rot) {
        this.setRotation(rot[0], rot[1], rot[2], rot[3]);
    }

    public void setRotation(float[] ra, int raIndex) {
        this.setRotation(ra[raIndex], ra[raIndex + 1], ra[raIndex + 2], ra[raIndex + 3]);
    }

    public void setAxisAngle(float ax, float ay, float az, float angle) {
        float[] tempq = new float[4];
        Quat4f.setFromAxisAngle4f((float[])tempq, (float)ax, (float)ay, (float)az, (float)angle);
        this.setRotation(tempq);
    }

    public abstract void getRotation(float[] var1);

    public abstract void getRotation(float[] var1, int var2);

    public abstract void setAngularVelocity(float var1, float var2, float var3);

    public void setAngularVelocity(float[] aVel) {
        this.setAngularVelocity(aVel[0], aVel[1], aVel[2]);
    }

    public void setAngularVelocity(float[] vc, int vcIndex) {
        this.setAngularVelocity(vc[vcIndex], vc[vcIndex + 1], vc[vcIndex + 2]);
    }

    public abstract void getAngularVelocity(float[] var1);

    public abstract void getAngularVelocity(float[] var1, int var2);

    public abstract void setVelocity(float var1, float var2, float var3);

    public void setVelocity(float[] velocity) {
        this.setVelocity(velocity[0], velocity[1], velocity[2]);
    }

    public void setVelocity(float[] vc, int vcIndex) {
        this.setVelocity(vc[vcIndex], vc[vcIndex + 1], vc[vcIndex + 2]);
    }

    public abstract void getVelocity(float[] var1);

    public abstract void setForce(float var1, float var2, float var3);

    public abstract void addForce(float var1, float var2, float var3);

    public void addForce(float[] force) {
        this.addForce(force[0], force[1], force[2]);
    }

    public abstract void addRelForce(float var1, float var2, float var3);

    public void addRelForce(float[] force) {
        this.addRelForce(force[0], force[1], force[2]);
    }

    public abstract void addForceAtPos(float var1, float var2, float var3, float var4, float var5, float var6);

    public void addForceAtPos(float[] force, float[] pos) {
        this.addForceAtPos(force[0], force[1], force[2], pos[0], pos[1], pos[2]);
    }

    public abstract void addForceAtRelPos(float var1, float var2, float var3, float var4, float var5, float var6);

    public void addForceAtRelPos(float[] force, float[] pos) {
        this.addForceAtPos(force[0], force[1], force[2], pos[0], pos[1], pos[2]);
    }

    public abstract void addRelForceAtRelPos(float var1, float var2, float var3, float var4, float var5, float var6);

    public void addRelForceAtRelPos(float[] force, float[] pos) {
        this.addRelForceAtRelPos(force[0], force[1], force[2], pos[0], pos[1], pos[2]);
    }

    public abstract void setTorque(float var1, float var2, float var3);

    public abstract void addTorque(float var1, float var2, float var3);

    public void addTorque(float[] t) {
        this.addTorque(t[0], t[1], t[2]);
    }

    public abstract void addRelTorque(float var1, float var2, float var3);

    public void addRelTorque(float[] t) {
        this.addRelTorque(t[0], t[1], t[2]);
    }

    public abstract void adjustMass(float var1);

    public abstract void getRelativePointVelocity(float[] var1, float[] var2);

    public abstract void getPointVelocity(float[] var1, float[] var2);

    public abstract void getPointRelPosition(float[] var1, float[] var2);

    public ArrayList<CollisionShape> getCollisionShapes() {
        return this.collisionShapes;
    }

    public String getId() {
        return this.id;
    }

    public String getSid() {
        return this.sid;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setScale(float[] sa) {
        throw new UnsupportedOperationException();
    }

    public void setScale(float[] sa, int saIndex) {
        throw new UnsupportedOperationException();
    }

    public float[] getTranslationBuffer() {
        throw new UnsupportedOperationException();
    }

    public void getScale(float[] r) {
        throw new UnsupportedOperationException();
    }

    public void getScale(float[] r, int index) {
        throw new UnsupportedOperationException();
    }

    public float[] getScaleBuffer() {
        throw new UnsupportedOperationException();
    }

    public float[] getRotationBuffer() {
        throw new UnsupportedOperationException();
    }

    public abstract Mass createMass();
}

