/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import hmi.animation.Hanim;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.controller.ControllerParameterNotFoundException;
import hmi.physics.controller.PhysicalController;
import java.util.Set;

public class RagdollController
implements PhysicalController {
    private Set<String> jointIDs = Sets.newHashSet((Object[])Hanim.all_body_joints);
    private Set<String> reqJointIDs = ImmutableSet.of();

    @Override
    public void reset() {
    }

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid p) {
    }

    public void setJointIDs(Set<String> newJointIDs) {
        this.jointIDs = newJointIDs;
    }

    @Override
    public Set<String> getRequiredJointIDs() {
        return this.reqJointIDs;
    }

    @Override
    public Set<String> getDesiredJointIDs() {
        return this.jointIDs;
    }

    public RagdollController(PhysicalHumanoid p, Set<String> newJointIDs) {
        this(p);
        this.setJointIDs(newJointIDs);
    }

    public RagdollController() {
    }

    public RagdollController(PhysicalHumanoid p) {
        this.setPhysicalHumanoid(p);
        this.reset();
    }

    @Override
    public void update(double timeDiff) {
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        RagdollController result = new RagdollController(ph);
        result.setJointIDs(this.jointIDs);
        return result;
    }

    @Override
    public String getParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("joints")) {
            StringBuffer result = new StringBuffer("");
            for (String s : this.jointIDs) {
                result.append("," + s);
            }
            return result.substring(1);
        }
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public void setParameterValue(String name, String value) throws ControllerParameterNotFoundException {
        Object[] ragdollJointIDs;
        if (name.equals("joints")) {
            if (value.trim().equals("")) {
                return;
            }
            ragdollJointIDs = value.split(",");
            for (int i = 0; i < ragdollJointIDs.length; ++i) {
                ragdollJointIDs[i] = ((String)ragdollJointIDs[i]).trim();
            }
        } else {
            throw new ControllerParameterNotFoundException(name);
        }
        this.setJointIDs(Sets.newHashSet((Object[])ragdollJointIDs));
    }

    @Override
    public void setParameterValue(String name, float value) throws ControllerParameterNotFoundException {
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ControllerParameterNotFoundException {
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public Set<String> getJoints() {
        return this.jointIDs;
    }
}

