/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import com.google.common.collect.ImmutableSet;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.controller.ControllerParameterException;
import hmi.physics.controller.ControllerParameterNotFoundException;
import hmi.physics.controller.PhysicalController;
import hmi.util.StringUtil;
import java.util.Set;

public class HingeJointController
implements PhysicalController {
    private PhysicalJoint joint;
    private String jointId;
    private float angle;
    private float aprev;
    private static final float KS_DEFAULT = 0.0f;
    private static final float DS_DEFAULT = 1.5f;
    private float ks;
    private float ds;
    private float avel = 0.0f;
    private int axis = 0;
    private int run = 0;
    private PhysicalHumanoid pHuman;
    private Set<String> desJointIDs = ImmutableSet.of();

    public HingeJointController(PhysicalJoint j, float a, float av, float k, float d, int ax) {
        this.joint = j;
        if (this.joint != null) {
            this.jointId = j.getName();
        }
        this.angle = -a;
        this.avel = av;
        this.ks = k;
        this.ds = d;
        this.axis = ax;
        this.aprev = 0.0f;
    }

    public HingeJointController() {
        this(null, 0.0f);
    }

    public HingeJointController(PhysicalJoint j, float a) {
        this(j, a, 0.0f, 0.0f, 1.5f, 0);
    }

    public void setDamper(float d) {
        this.ds = d;
    }

    public void setSpring(float k) {
        this.ks = k;
    }

    @Override
    public void reset() {
        this.aprev = 0.0f;
        this.run = 0;
    }

    @Override
    public void update(double timeDiff) {
        float a = this.joint.getAngle(this.axis);
        if (this.run == 0) {
            this.run = 1;
            return;
        }
        if (this.run == 1) {
            this.aprev = a;
            this.run = 2;
        }
        float da = (a - this.aprev) / (float)timeDiff;
        switch (this.axis) {
            case 0: {
                this.joint.addTorque((this.angle - a) * this.ks + (this.avel - da) * this.ds, 0.0f, 0.0f);
                break;
            }
            case 1: {
                this.joint.addTorque(0.0f, (this.angle - a) * this.ks + (this.avel - da) * this.ds, 0.0f);
                break;
            }
            case 2: {
                this.joint.addTorque(0.0f, 0.0f, (this.angle - a) * this.ks + (this.avel - da) * this.ds);
            }
        }
        this.aprev = a;
    }

    @Override
    public Set<String> getRequiredJointIDs() {
        return ImmutableSet.of((Object)this.jointId);
    }

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid ph) {
        this.joint = ph.getJoint(this.jointId);
        this.pHuman = ph;
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        HingeJointController hjc = new HingeJointController(this.joint, -this.angle, this.avel, this.ks, this.ds, this.axis);
        hjc.aprev = this.aprev;
        hjc.setPhysicalHumanoid(ph);
        try {
            hjc.setParameterValue("joint", this.jointId);
        }
        catch (ControllerParameterException e) {
            throw new AssertionError((Object)e);
        }
        return hjc;
    }

    @Override
    public String getParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("joint")) {
            return this.jointId;
        }
        if (name.equals("axis")) {
            return "" + this.axis;
        }
        return "" + this.getFloatParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("ks")) {
            return this.ks;
        }
        if (name.equals("ds")) {
            return this.ds;
        }
        if (name.equals("angle")) {
            return -this.angle;
        }
        if (name.equals("axis")) {
            return this.axis;
        }
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public void setParameterValue(String name, String value) throws ControllerParameterException {
        if (name.equals("joint")) {
            this.jointId = value;
            if (this.pHuman != null) {
                this.joint = this.pHuman.getJoint(this.jointId);
            }
        } else if (StringUtil.isNumeric((String)value)) {
            this.setParameterValue(name, Float.parseFloat(value));
        } else {
            throw new ControllerParameterException("Invalid parameter setting " + name + "=" + value);
        }
    }

    @Override
    public void setParameterValue(String name, float value) throws ControllerParameterException {
        if (name.equals("ks")) {
            this.setSpring(value);
        } else if (name.equals("ds")) {
            this.setDamper(value);
        } else if (name.equals("angle")) {
            this.angle = -value;
        } else if (name.equals("axis")) {
            this.axis = (int)value;
        } else {
            throw new ControllerParameterNotFoundException(name);
        }
    }

    @Override
    public Set<String> getDesiredJointIDs() {
        return this.desJointIDs;
    }

    @Override
    public Set<String> getJoints() {
        return this.getRequiredJointIDs();
    }
}

