/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.assembler;

import hmi.graphics.collada.Box;
import hmi.graphics.collada.Capsule;
import hmi.graphics.collada.Rotate;
import hmi.graphics.collada.Shape;
import hmi.graphics.collada.Sphere;
import hmi.graphics.collada.Translate;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.CollisionBox;
import hmi.physics.CollisionCapsule;
import hmi.physics.CollisionShape;
import hmi.physics.CollisionSphere;
import hmi.physics.RigidBody;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class CollisionModel
extends XMLStructureAdapter {
    private RigidBody body;

    public CollisionModel(RigidBody b) {
        this.body = b;
    }

    protected void addShape(Shape s) {
        float[] q = new float[4];
        float[] tr = new float[3];
        Quat4f.setIdentity((float[])q);
        Vec3f.set((float[])tr, (float)0.0f, (float)0.0f, (float)0.0f);
        if (s.getRotate() != null) {
            Quat4f.set((float[])q, (float[])s.getRotate().getRotationQuat4f());
        }
        if (s.getTranslate() != null) {
            Vec3f.set((float[])tr, (float[])s.getTranslate().getTranslation());
        }
        if (s.getBox() != null) {
            this.body.addBox(q, tr, s.getBox().getHalfExtends().getXyz());
        } else if (s.getSphere() != null) {
            this.body.addSphere(tr, s.getSphere().getRadius().getRadius());
        } else if (s.getCapsule() != null) {
            this.body.addCapsule(q, tr, s.getCapsule().getRadius().getRadius(), s.getCapsule().getHeight().getHeight());
        }
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Shape.xmlTag())) {
                this.addShape(new Shape(null, tokenizer));
                continue;
            }
            System.err.println("CollisionModel: skip : " + tokenizer.getTagName());
            tokenizer.skipTag();
        }
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        for (CollisionShape s : this.body.getCollisionShapes()) {
            Shape colladaShape = new Shape();
            float[] q = new float[4];
            s.getRotation(q);
            if (!Quat4f.isIdentity((float[])q)) {
                Rotate r = new Rotate();
                float[] aa = new float[4];
                Quat4f.setAxisAngle4fFromQuat4f((float[])aa, (float[])q);
                r.setAxisAngleRadians(aa);
                colladaShape.setRotate(r);
            }
            float[] ta = new float[3];
            s.getTranslation(ta);
            if (!Vec3f.equals((float[])ta, (float)0.0f, (float)0.0f, (float)0.0f)) {
                Translate t = new Translate();
                t.setTranslation(ta);
                colladaShape.setTranslate(t);
            }
            if (s instanceof CollisionBox) {
                CollisionBox cb = (CollisionBox)s;
                colladaShape.setBox(new Box());
                Vec3f.set((float[])colladaShape.getBox().getHalfExtends().getXyz(), (float[])cb.halfExtends);
            } else if (s instanceof CollisionSphere) {
                CollisionSphere cs = (CollisionSphere)s;
                colladaShape.setSphere(new Sphere());
                colladaShape.getSphere().getRadius().setRadius(cs.radius);
            } else if (s instanceof CollisionCapsule) {
                CollisionCapsule cc = (CollisionCapsule)s;
                colladaShape.setCapsule(new Capsule());
                colladaShape.getCapsule().getHeight().setHeight(cc.height);
                colladaShape.getCapsule().getRadius().setRadius(cc.radius);
            }
            CollisionModel.appendNewLine((StringBuilder)buf);
            colladaShape.appendXML(buf, fmt);
        }
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        return buf;
    }

    public String getXMLTag() {
        return "CollisionModel";
    }
}

