/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics;

import hmi.animation.VJoint;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.CollisionShape;
import hmi.physics.PhysicalJoint;
import hmi.physics.PhysicalSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class PhysicalHumanoid {
    private boolean bIsEnabled = true;
    private float[] COM = new float[3];
    private float[] COMDiff = new float[3];
    private float[] COMNoContacts = new float[3];
    private float[] COMNoContactsDiff = new float[3];
    private float[] COMOffset = new float[3];
    private float[] COMOffsetDiff = new float[3];
    private float[] vecTemp = new float[3];
    private float[] qTemp = new float[4];
    private List<PhysicalSegment> segments = new ArrayList<PhysicalSegment>();
    protected List<PhysicalJoint> joints = new ArrayList<PhysicalJoint>();
    private PhysicalSegment rootSegment;
    protected HashMap<String, PhysicalSegment> nameSegmentMap = new HashMap();
    protected HashMap<String, PhysicalJoint> namePhysicalJointMap = new HashMap();
    protected float[] rootTranslationBuffer;
    protected float[] rootRotationBuffer;
    protected float[] COMBuffer = new float[3];
    protected float[] COMDiffBuffer = new float[3];
    protected float[] COMOffsetBuffer = new float[3];
    protected float[] COMOffsetDiffBuffer = new float[3];
    private float offsetMass = 0.0f;
    private String id = "";
    float[] m = new float[16];
    private float[] v1 = new float[3];
    private float[] v2 = new float[3];
    private float[] v3 = new float[3];

    public void removeSegment(PhysicalSegment segment) {
        this.segments.remove(segment);
    }

    public PhysicalHumanoid(String id) {
        this.id = id;
        for (int i = 0; i < 3; ++i) {
            this.COM[i] = 0.0f;
            this.COMDiff[i] = 0.0f;
            this.COMNoContacts[i] = 0.0f;
            this.COMNoContactsDiff[i] = 0.0f;
        }
    }

    public void addSegment(PhysicalSegment segment) {
        this.segments.add(segment);
        this.setupHashMaps(segment);
    }

    public void addRootSegment(PhysicalSegment segment) {
        this.rootSegment = segment;
        this.setupHashMaps(segment);
    }

    public void set(PhysicalHumanoid ph) {
        Vec3f.set((float[])this.COM, (float[])ph.COM);
        Vec3f.set((float[])this.COMDiff, (float[])ph.COMDiff);
        Vec3f.set((float[])this.COMNoContacts, (float[])ph.COMNoContacts);
        Vec3f.set((float[])this.COMNoContactsDiff, (float[])ph.COMNoContactsDiff);
        Vec3f.set((float[])this.COMOffset, (float)0.0f, (float)0.0f, (float)0.0f);
        if (this.rootSegment != null && ph.rootSegment != null) {
            this.rootSegment.box.setTorque(0.0f, 0.0f, 0.0f);
            this.rootSegment.box.setForce(0.0f, 0.0f, 0.0f);
            if (this.rootSegment.getSid().equals(ph.rootSegment.getSid())) {
                ph.rootSegment.getRotation(this.qTemp);
                this.rootSegment.setRotation(this.qTemp);
                ph.rootSegment.getAngularVelocity(this.vecTemp);
                this.rootSegment.setAngularVelocity(this.vecTemp);
                ph.rootSegment.getTranslation(this.vecTemp);
                this.rootSegment.setTranslation(this.vecTemp);
                ph.rootSegment.getVelocity(this.vecTemp);
                this.rootSegment.setVelocity(this.vecTemp);
                ph.rootSegment.box.getForce(this.vecTemp);
                this.rootSegment.box.addForce(this.vecTemp);
                ph.rootSegment.box.getTorque(this.vecTemp);
                this.rootSegment.box.addTorque(this.vecTemp);
            }
        }
        for (PhysicalSegment ps : this.segments) {
            ps.box.setTorque(0.0f, 0.0f, 0.0f);
            ps.box.setForce(0.0f, 0.0f, 0.0f);
            for (PhysicalSegment srcPs : ph.segments) {
                if (!ps.getSid().equals(srcPs.getSid())) continue;
                srcPs.getRotation(this.qTemp);
                ps.setRotation(this.qTemp);
                srcPs.getAngularVelocity(this.vecTemp);
                ps.setAngularVelocity(this.vecTemp);
                srcPs.getTranslation(this.vecTemp);
                ps.setTranslation(this.vecTemp);
                srcPs.getVelocity(this.vecTemp);
                ps.setVelocity(this.vecTemp);
                srcPs.box.getTorque(this.vecTemp);
                ps.box.addTorque(this.vecTemp);
                srcPs.box.getForce(this.vecTemp);
                ps.box.addForce(this.vecTemp);
            }
        }
    }

    public abstract PhysicalJoint setupJoint(String var1, PhysicalSegment var2, PhysicalSegment var3, float[] var4);

    public abstract PhysicalSegment createSegment(String var1, String var2);

    public abstract PhysicalHumanoid createNew(String var1);

    public PhysicalSegment[] getSegments() {
        PhysicalSegment[] ps;
        if (this.rootSegment != null) {
            ps = new PhysicalSegment[this.segments.size() + 1];
            ps[0] = this.rootSegment;
            int i = 1;
            Iterator<PhysicalSegment> i$ = this.segments.iterator();
            while (i$.hasNext()) {
                PhysicalSegment p;
                ps[i] = p = i$.next();
                ++i;
            }
        } else {
            ps = new PhysicalSegment[]{};
        }
        return ps;
    }

    public PhysicalJoint getJoint(String name) {
        PhysicalJoint pj = this.namePhysicalJointMap.get(name);
        if (pj == null) {
            pj = this.namePhysicalJointMap.get(name + "_joint");
        }
        if (pj == null) {
            // empty if block
        }
        return pj;
    }

    public PhysicalSegment getSegment(String name) {
        PhysicalSegment seg = this.nameSegmentMap.get(name);
        if (seg == null) {
            seg = this.nameSegmentMap.get(name + "_segment");
        }
        if (seg == null) {
            // empty if block
        }
        return seg;
    }

    public void removeFromHashMap(PhysicalSegment ps) {
        this.nameSegmentMap.remove(ps.getSid());
    }

    public void setupHashMaps(PhysicalSegment ps) {
        if (ps.getSid() != null) {
            this.nameSegmentMap.put(ps.getSid(), ps);
        }
    }

    public void copy() {
        this.setRootSimInfo();
        for (PhysicalJoint pj : this.joints) {
            float[] buffer = pj.getRotationBuffer();
            if (buffer == null) continue;
            pj.getRotation(buffer);
        }
        if (this.rootSegment != null) {
            this.rootSegment.box.copy();
        }
        for (PhysicalSegment seg : this.segments) {
            seg.box.copy();
        }
        Vec3f.set((float[])this.COMBuffer, (float[])this.COM);
        Vec3f.set((float[])this.COMDiffBuffer, (float[])this.COMDiff);
        Vec3f.set((float[])this.COMOffsetBuffer, (float[])this.COMOffset);
        Vec3f.set((float[])this.COMOffsetDiffBuffer, (float[])this.COMOffsetDiff);
        if (this.getCOMOffsetMass() > 0.0f) {
            Vec3f.scale((float)(1.0f / this.getCOMOffsetMass()), (float[])this.COMOffsetDiffBuffer);
            Vec3f.scale((float)(1.0f / this.getCOMOffsetMass()), (float[])this.COMOffsetBuffer);
        }
    }

    public void updateCollision() {
        for (PhysicalSegment ps : this.segments) {
            ps.onGround = false;
        }
        this.rootSegment.onGround = false;
        this.handleCollisions();
    }

    public void setEnabled(boolean enabled) {
        this.bIsEnabled = enabled;
        if (this.rootSegment != null) {
            this.rootSegment.setEnabled(enabled);
        }
        for (PhysicalSegment ps : this.segments) {
            ps.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.bIsEnabled;
    }

    public float getTotalMass() {
        float totalMass = this.rootSegment.box.getMass();
        for (PhysicalSegment ps : this.segments) {
            totalMass += ps.box.getMass();
        }
        return totalMass;
    }

    public void setCOMOffset(float[] offset, float mass) {
        Vec3f.set((float[])this.COMOffsetDiff, (float[])offset);
        Vec3f.sub((float[])this.COMOffsetDiff, (float[])this.COMOffset);
        Vec3f.set((float[])this.COMOffset, (float[])offset);
        this.offsetMass = mass;
    }

    public float getCOMOffsetMass() {
        return this.offsetMass;
    }

    public float[] getCOMOffset() {
        return this.COMOffset;
    }

    public void updateCOM(float timeStep) {
        for (int i = 0; i < 3; ++i) {
            this.v1[i] = 0.0f;
            this.v3[i] = 0.0f;
        }
        float totalMass = 0.0f;
        float noContactMass = 0.0f;
        if (this.rootSegment != null) {
            this.rootSegment.box.getTranslation(this.v2);
            Vec3f.scale((float)this.rootSegment.box.getMass(), (float[])this.v2);
            Vec3f.add((float[])this.v1, (float[])this.v2);
            Vec3f.add((float[])this.v3, (float[])this.v2);
            noContactMass = this.rootSegment.box.getMass();
            totalMass = this.rootSegment.box.getMass();
        }
        totalMass += this.offsetMass;
        Vec3f.add((float[])this.v1, (float[])this.COMOffset);
        Vec3f.add((float[])this.v3, (float[])this.COMOffset);
        for (PhysicalSegment ps : this.segments) {
            ps.box.getTranslation(this.v2);
            Vec3f.scale((float)ps.box.getMass(), (float[])this.v2);
            Vec3f.add((float[])this.v1, (float[])this.v2);
            totalMass += ps.box.getMass();
            if (ps.onGround) continue;
            Vec3f.add((float[])this.v3, (float[])this.v2);
            noContactMass += ps.box.getMass();
        }
        Vec3f.scale((float)(1.0f / totalMass), (float[])this.v1);
        Vec3f.scale((float)(1.0f / noContactMass), (float[])this.v3);
        if ((double)timeStep == 0.0) {
            for (int i = 0; i < 3; ++i) {
                this.COMDiff[i] = 0.0f;
                this.COMOffsetDiff[i] = 0.0f;
                this.COMNoContactsDiff[i] = 0.0f;
            }
        } else {
            Vec3f.scale((float)(1.0f / timeStep), (float[])this.COMOffsetDiff);
            Vec3f.set((float[])this.v2, (float[])this.v1);
            Vec3f.sub((float[])this.v2, (float[])this.COM);
            Vec3f.scale((float)(1.0f / timeStep), (float[])this.v2);
            Vec3f.set((float[])this.COMDiff, (float[])this.v2);
            Vec3f.set((float[])this.v2, (float[])this.v3);
            Vec3f.sub((float[])this.v2, (float[])this.COMNoContacts);
            Vec3f.scale((float)(1.0f / timeStep), (float[])this.v2);
            Vec3f.set((float[])this.COMNoContactsDiff, (float[])this.v2);
        }
        Vec3f.set((float[])this.COM, (float[])this.v1);
        Vec3f.set((float[])this.COMNoContacts, (float[])this.v3);
        if (Vec3f.length((float[])this.COMDiff) > 1.0f) {
            // empty if block
        }
    }

    public String toString() {
        return "Segments: " + this.segments.toString() + "\n" + "Joints: " + this.joints.toString();
    }

    public float[] getCOM() {
        return this.COM;
    }

    public float[] getCOMDiff() {
        return this.COMDiff;
    }

    public float[] getCOMNoContacts() {
        return this.COMNoContacts;
    }

    public float[] getCOMNoContactsDiff() {
        return this.COMNoContactsDiff;
    }

    public void setRootRotationBuffer(float[] rootRotationBuffer) {
        this.rootRotationBuffer = rootRotationBuffer;
    }

    public void setRootTranslationBuffer(float[] rootTranslationBuffer) {
        this.rootTranslationBuffer = rootTranslationBuffer;
    }

    public void setCOMBuffer(float[] COMBuffer) {
        this.COMBuffer = COMBuffer;
    }

    public void setCOMDiffBuffer(float[] COMDiffBuffer) {
        this.COMDiffBuffer = COMDiffBuffer;
    }

    public void setCOMOffsetDiffBuffer(float[] COMOffsetDiffBuffer) {
        this.COMOffsetDiffBuffer = COMOffsetDiffBuffer;
    }

    public void setCOMOffsetBuffer(float[] COMOffsetBuffer) {
        this.COMOffsetBuffer = COMOffsetBuffer;
    }

    private void setRootSimInfo() {
        if (this.rootSegment != null) {
            Vec3f.set((float[])this.v1, (float[])this.rootSegment.startJointOffset);
            this.rootSegment.box.getRotation(this.rootRotationBuffer);
            Quat4f.transformVec3f((float[])this.rootRotationBuffer, (float[])this.v1);
            this.rootSegment.box.getTranslation(this.v2);
            Vec3f.add((float[])this.rootTranslationBuffer, (float[])this.v1, (float[])this.v2);
        }
    }

    public void clear() {
        if (this.rootSegment != null) {
            this.rootSegment.clear();
        }
        for (PhysicalSegment s : this.segments) {
            s.clear();
        }
        this.segments.clear();
        this.joints.clear();
        this.rootSegment = null;
        this.nameSegmentMap.clear();
        this.namePhysicalJointMap.clear();
    }

    public void setRelativeTranslation(float[] trans) {
        float[] oldTrans = new float[3];
        float[] absTrans = new float[3];
        this.rootSegment.getTranslation(oldTrans);
        Vec3f.add((float[])absTrans, (float[])trans, (float[])oldTrans);
        this.rootSegment.setTranslation(absTrans);
        for (PhysicalSegment s : this.segments) {
            s.getTranslation(oldTrans);
            Vec3f.add((float[])absTrans, (float[])trans, (float[])oldTrans);
            s.setTranslation(absTrans);
        }
    }

    public void setRotation(float[] center, float[] q) {
        float[] oldTrans = new float[3];
        float[] trans = new float[3];
        this.rootSegment.getTranslation(oldTrans);
        Vec3f.sub((float[])trans, (float[])oldTrans, (float[])center);
        this.rootSegment.setRotation(q);
        Quat4f.transformVec3f((float[])q, (float[])trans);
        this.rootSegment.setTranslation(trans);
        for (PhysicalSegment s : this.segments) {
            s.getTranslation(oldTrans);
            Vec3f.sub((float[])trans, (float[])oldTrans, (float[])center);
            Quat4f.transformVec3f((float[])q, (float[])trans);
            s.setRotation(q);
            s.setTranslation(trans);
        }
    }

    public void setRelativeTranslation(float x, float y, float z) {
        float[] oldTrans = new float[3];
        float[] absTrans = new float[3];
        this.rootSegment.getTranslation(oldTrans);
        Vec3f.set((float[])absTrans, (float)x, (float)y, (float)z);
        Vec3f.add((float[])absTrans, (float[])oldTrans);
        this.rootSegment.setTranslation(absTrans);
        for (PhysicalSegment s : this.segments) {
            s.getTranslation(oldTrans);
            Vec3f.set((float[])absTrans, (float)x, (float)y, (float)z);
            Vec3f.add((float[])absTrans, (float[])oldTrans);
            s.setTranslation(absTrans);
        }
    }

    protected void handleCollisions() {
    }

    public String getId() {
        return this.id;
    }

    private void setJoint(VJoint vj) {
        PhysicalSegment ps = this.getSegment(vj.getSid());
        float[] v = new float[3];
        if (ps != null) {
            this.m = vj.getGlobalMatrix();
            Quat4f.setFromMat4f((float[])this.qTemp, (float[])this.m);
            Vec3f.scale((float)-1.0f, (float[])v, (float[])ps.startJointOffset);
            Mat4f.transformPoint((float[])this.m, (float[])this.vecTemp, (float[])v);
            ps.setTranslation(this.vecTemp);
            ps.setRotation(this.qTemp);
        }
    }

    public void setPoseFromVJoint(VJoint vj) {
        for (VJoint vjParts : vj.getParts()) {
            this.setJoint(vjParts);
        }
    }

    public void setNullPoseFromVJoint(VJoint vj) {
        vj.calculateMatrices();
        for (VJoint vjParts : vj.getParts()) {
            this.setNullPoseForJoint(vjParts);
        }
    }

    private void setNullPoseForJoint(VJoint vj) {
        PhysicalSegment ps = this.getSegment(vj.getSid());
        float[] v = new float[3];
        float[] vTemp = new float[3];
        float[] vTempOld = new float[3];
        float[] qTemp2 = new float[4];
        if (ps != null) {
            ps.getTranslation(vTempOld);
            this.m = vj.getGlobalMatrix();
            Quat4f.setFromMat4f((float[])this.qTemp, (float[])this.m);
            Vec3f.scale((float)-1.0f, (float[])v, (float[])ps.startJointOffset);
            Mat4f.transformPoint((float[])this.m, (float[])this.vecTemp, (float[])v);
            ps.setTranslation(this.vecTemp);
            for (CollisionShape sh : ps.box.getCollisionShapes()) {
                sh.getTranslation(vTemp);
                Quat4f.transformVec3f((float[])this.qTemp, (float[])vTemp);
                sh.setTranslation(vTemp);
                sh.getRotation(qTemp2);
                Quat4f.mul((float[])qTemp2, (float[])this.qTemp, (float[])qTemp2);
                Quat4f.normalize((float[])qTemp2);
                sh.setRotation(qTemp2);
            }
            ps.box.rotateInertiaTensor(this.qTemp);
            Quat4f.transformVec3f((float[])this.qTemp, (float[])ps.startJointOffset);
            float[] anchor = new float[3];
            vj.getPathTranslation(null, anchor);
            if (ps.startJoint != null) {
                ps.startJoint.setAnchor(anchor[0], anchor[1], anchor[2]);
            }
        }
    }

    public float[] getCOMOffsetDiff() {
        return this.COMOffsetDiff;
    }

    public PhysicalSegment getRootSegment() {
        return this.rootSegment;
    }

    public void setRootSegment(PhysicalSegment rs) {
        this.rootSegment = rs;
    }

    public List<PhysicalJoint> getJoints() {
        return Collections.unmodifiableList(this.joints);
    }
}

