/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.ode;

import hmi.graphics.scenegraph.GMesh;
import hmi.math.Mat3f;
import hmi.math.Vec3f;
import hmi.physics.Mass;
import hmi.physics.ode.Tools;
import org.odejava.Body;
import org.odejava.Geom;
import org.odejava.ode.dMass;

public class OdeMass
extends Mass {
    private org.odejava.Mass mass;

    public OdeMass() {
        this.mass = new org.odejava.Mass();
    }

    public OdeMass(dMass m) {
        this.mass = new org.odejava.Mass(m);
    }

    public void adjustMass(float m, Body b) {
        this.mass.adjust(m, b);
    }

    @Override
    public void adjustMass(float newMass) {
        this.mass.adjust(newMass);
    }

    @Override
    public void getCOM(float[] center) {
        this.mass.getC(center);
    }

    @Override
    public void getInertiaTensor(float[] I) {
        this.mass.getI(I);
    }

    public org.odejava.Mass getOMass() {
        return this.mass;
    }

    @Override
    public float getMass() {
        return this.mass.getMass();
    }

    @Override
    public void setFromBox(float[] size, float density) {
        this.mass.setFromBox(size, density);
    }

    @Override
    public void setFromGMesh(GMesh m, float density) {
        this.mass.setMass((Geom)Tools.getGeomTriMesh(m), density);
    }

    @Override
    public void translate(float x, float y, float z) {
        this.mass.translate(x, y, z);
    }

    @Override
    public String toString() {
        float[] c = new float[3];
        this.mass.getC(c);
        float[] I = new float[9];
        this.mass.getI(I);
        return "mass: " + this.mass.getMass() + ", COM: " + Vec3f.toString((float[])c) + ", I " + Mat3f.toString((float[])I);
    }

    @Override
    public void setFromSphere(float radius, float density) {
        this.mass.setFromSphere(radius, density);
    }

    @Override
    public void setFromCapsule(float radius, float height, int direction, float density) {
        this.mass.setFromCapsule(2, radius, height, density);
    }

    @Override
    public void setCOM(float[] c) {
        this.mass.setC(c);
    }

    public void setCOM(float[] c, Body body) {
        this.mass.setC(c, body);
    }

    @Override
    public void setInertiaTensor(float[] I) {
        this.mass.setI(I);
    }

    public void setInertiaTensor(float[] I, Body body) {
        this.mass.setI(I, body);
    }

    @Override
    public void rotate(float[] q) {
        float[] m = new float[9];
        Mat3f.setFromQuatScale((float[])m, (float[])q, (float)1.0f);
        this.mass.rotate(m);
    }

    @Override
    public Mass copy() {
        OdeMass m = new OdeMass();
        m.adjustMass(this.getMass());
        float[] c = new float[3];
        this.getCOM(c);
        m.setCOM(c);
        float[] I = new float[9];
        this.getInertiaTensor(I);
        m.setInertiaTensor(I);
        return m;
    }
}

