/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.ode;

import hmi.physics.CollisionBox;
import hmi.physics.ode.OdeCollisionShape;
import org.odejava.GeomBox;
import org.odejava.GeomTransform;
import org.odejava.PlaceableGeom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdeCollisionBox
extends CollisionBox
implements OdeCollisionShape {
    public GeomBox box;
    public PlaceableGeom root;
    public String name;
    private GeomTransform transform = null;
    private Logger logger = LoggerFactory.getLogger((String)OdeCollisionBox.class.getName());

    public OdeCollisionBox(String n) {
        this.name = n;
        this.createBox();
    }

    public OdeCollisionBox(float[] hExtends, String n) {
        super(hExtends);
        this.name = n;
        this.createBox();
    }

    public OdeCollisionBox(float[] q, float[] tr, float[] hExtends, String n) {
        super(q, tr, hExtends);
        this.name = n;
        this.createBox();
    }

    private void createBox() {
        this.box = new GeomBox(this.name + "_box", 2.0f * this.halfExtends[0], 2.0f * this.halfExtends[1], 2.0f * this.halfExtends[2]);
        this.transform = new GeomTransform(this.name + "_Geomtransform");
        this.box.setPosition(this.translation[0], this.translation[1], this.translation[2]);
        this.box.setQuatWXYZ(this.rotation[0], this.rotation[1], this.rotation[2], this.rotation[3]);
        this.transform.setEncapsulatedGeom((PlaceableGeom)this.box);
        this.root = this.transform;
    }

    @Override
    public PlaceableGeom getCollisionGeom() {
        return this.root;
    }

    @Override
    public PlaceableGeom getRoot() {
        return this.root;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void setRotation(float[] q) {
        super.setRotation(q);
        this.box.setQuatWXYZ(this.rotation[0], this.rotation[1], this.rotation[2], this.rotation[3]);
    }

    @Override
    public void setTranslation(float[] v) {
        super.setTranslation(v);
        this.box.setPosition(this.translation[0], this.translation[1], this.translation[2]);
    }

    @Override
    public void setBodyName(String bodyName) {
        int index = this.name.indexOf("_");
        this.name = this.name.substring(index);
        this.name = bodyName + this.name;
        this.box.setName(this.name + "_box");
        this.root.setName(this.name + "_root");
        this.logger.debug("new collision shape name: {}", (Object)this.name);
    }
}

