/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import hmi.math.Vec3f;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.controller.ControllerParameterException;
import hmi.physics.controller.ControllerParameterNotFoundException;
import hmi.physics.controller.PhysicalController;
import hmi.util.StringUtil;

public class RigidBodyDamper
implements PhysicalController {
    private static final float DS_ROTDEFAULT = 50.0f;
    private static final float DS_LINDEFAULT = 0.0f;
    private float dsrot;
    private float dslin;
    private String bodyId = null;
    private PhysicalHumanoid pHuman;
    private PhysicalSegment body;
    private String[] jointIDs = new String[0];
    private String[] desJointIDs = new String[0];
    private float[] vel = new float[3];
    private float[] avel = new float[3];

    public RigidBodyDamper() {
        this(null);
    }

    public RigidBodyDamper(PhysicalSegment ps) {
        this(ps, 50.0f, 0.0f);
    }

    public RigidBodyDamper(PhysicalSegment ps, float dsr, float dsl) {
        this.body = ps;
        if (this.body != null) {
            this.bodyId = this.body.getSid();
        }
        this.dsrot = dsr;
        this.dslin = dsl;
    }

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid ph) {
        this.body = ph.getSegment(this.bodyId);
        this.pHuman = ph;
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        RigidBodyDamper rbd = new RigidBodyDamper(this.body, this.dsrot, this.dslin);
        rbd.setPhysicalHumanoid(ph);
        return rbd;
    }

    @Override
    public String[] getRequiredJointIDs() {
        return this.jointIDs;
    }

    @Override
    public void reset() {
    }

    @Override
    public String getParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("body")) {
            return this.bodyId;
        }
        return "" + this.getFloatParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("dsrot")) {
            return this.dsrot;
        }
        if (name.equals("dslin")) {
            return this.dslin;
        }
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public void setParameterValue(String name, String value) throws ControllerParameterException {
        if (name.equals("body")) {
            this.bodyId = value;
            this.body = this.pHuman.getSegment(this.bodyId);
        } else if (StringUtil.isNumeric((String)value)) {
            this.setParameterValue(name, Float.parseFloat(value));
        } else {
            throw new ControllerParameterException("Invalid parameter setting: " + name + "=" + value);
        }
    }

    @Override
    public void setParameterValue(String name, float value) throws ControllerParameterNotFoundException {
        if (name.equals("dsrot")) {
            this.dsrot = value;
        } else if (name.equals("dslin")) {
            this.dslin = value;
        } else {
            throw new ControllerParameterNotFoundException(name);
        }
    }

    @Override
    public void update(double timeDiff) {
        this.body.getVelocity(this.vel);
        this.body.getAngularVelocity(this.avel);
        Vec3f.scale((float)(-this.dslin), (float[])this.vel);
        Vec3f.scale((float)(-this.dsrot), (float[])this.avel);
        this.body.box.addTorque(this.avel);
        this.body.box.addForce(this.vel);
    }

    @Override
    public String[] getDesiredJointIDs() {
        return this.desJointIDs;
    }
}

