/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.controller.ControllerParameterException;
import hmi.physics.controller.ControllerParameterNotFoundException;
import hmi.physics.controller.PhysicalController;
import hmi.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallJointController
implements PhysicalController {
    private Logger logger = LoggerFactory.getLogger((String)BallJointController.class.getName());
    private PhysicalJoint joint;
    private String jointId;
    private float anglex;
    private float angley;
    private float anglez;
    private float avelx;
    private float avely;
    private float avelz;
    private float aprevx;
    private float aprevy;
    private float aprevz;
    private float ksx = 0.0f;
    private float dsx = 2.0f;
    private float ksy = 1.0f;
    private float dsy = 2.0f;
    private float ksz = 1.0f;
    private float dsz = 2.0f;
    private static final float DEFAULT_KSX = 1.0f;
    private static final float DEFAULT_DSX = 2.0f;
    private static final float DEFAULT_KSY = 1.0f;
    private static final float DEFAULT_DSY = 2.0f;
    private static final float DEFAULT_KSZ = 1.0f;
    private static final float DEFAULT_DSZ = 2.0f;
    private String[] jointIDs = new String[1];
    private String[] desJointIDs = new String[0];
    private int firstRun = 0;
    private PhysicalHumanoid pHuman;

    public BallJointController(PhysicalJoint j, float ax, float ay, float az, float avx, float avy, float avz, float kx, float ky, float kz, float dx, float dy, float dz) {
        this.joint = j;
        if (this.joint != null) {
            this.jointId = j.getName();
        }
        this.anglex = -ax;
        this.angley = -ay;
        this.anglez = -az;
        this.avelx = avx;
        this.avely = avy;
        this.avelz = avz;
        this.ksx = kx;
        this.dsx = dx;
        this.ksy = ky;
        this.dsy = dy;
        this.ksz = kz;
        this.dsz = dz;
        this.reset();
    }

    public BallJointController(PhysicalJoint j, float ax, float ay, float az) {
        this(j, ax, ay, az, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f);
    }

    public BallJointController() {
        this(null, 0.0f, 0.0f, 0.0f);
    }

    public void setSprings(float kx, float ky, float kz) {
        this.ksx = kx;
        this.ksy = ky;
        this.ksz = kz;
    }

    @Override
    public void reset() {
        this.aprevx = 0.0f;
        this.aprevy = 0.0f;
        this.aprevz = 0.0f;
        this.firstRun = 0;
        this.logger.debug("Ball controller reset");
    }

    @Override
    public void update(double timeDiff) {
        float ax = this.joint.getAngle(0);
        float ay = this.joint.getAngle(1);
        float az = this.joint.getAngle(2);
        float dax = 0.0f;
        float day = 0.0f;
        float daz = 0.0f;
        if (this.firstRun == 0) {
            this.firstRun = 1;
            this.logger.debug("First run of ball controller (x,y,z)={},{},{}", new Object[]{Float.valueOf(ax), Float.valueOf(ay), Float.valueOf(az)});
            return;
        }
        if (this.firstRun == 2) {
            this.aprevx = ax;
            this.aprevy = ay;
            this.aprevz = az;
        }
        dax = (ax - this.aprevx) / (float)timeDiff;
        day = (ay - this.aprevy) / (float)timeDiff;
        daz = (az - this.aprevz) / (float)timeDiff;
        this.joint.addTorque((this.anglex - ax) * this.ksx + (this.avelx - dax) * this.dsx, (this.angley - ay) * this.ksy + (this.avely - day) * this.dsy, (this.anglez - az) * this.ksz + (this.avelz - daz) * this.dsz);
        this.aprevx = ax;
        this.aprevy = ay;
        this.aprevz = az;
    }

    @Override
    public String[] getRequiredJointIDs() {
        this.jointIDs[0] = this.jointId;
        return this.jointIDs;
    }

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid ph) {
        this.joint = ph.getJoint(this.jointId);
        this.pHuman = ph;
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        BallJointController bjc = new BallJointController(this.joint, this.anglex, this.angley, this.anglez, this.avelx, this.avely, this.avelz, this.ksx, this.ksy, this.ksz, this.dsx, this.dsy, this.dsz);
        bjc.setPhysicalHumanoid(ph);
        try {
            bjc.setParameterValue("joint", this.jointId);
        }
        catch (ControllerParameterException e) {
            throw new AssertionError((Object)e);
        }
        return bjc;
    }

    @Override
    public String getParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("joint")) {
            return this.jointId;
        }
        return "" + this.getFloatParameterValue(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("anglex")) {
            return this.anglex;
        }
        if (name.equals("angley")) {
            return this.angley;
        }
        if (name.equals("anglez")) {
            return this.anglez;
        }
        if (name.equals("ksx")) {
            return this.ksx;
        }
        if (name.equals("ksy")) {
            return this.ksy;
        }
        if (name.equals("ksz")) {
            return this.ksz;
        }
        if (name.equals("dsx")) {
            return this.dsx;
        }
        if (name.equals("dsy")) {
            return this.dsy;
        }
        if (name.equals("dsz")) {
            return this.dsz;
        }
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public void setParameterValue(String name, String value) throws ControllerParameterException {
        if (name.equals("joint")) {
            this.jointId = value;
            if (this.pHuman != null) {
                this.joint = this.pHuman.getJoint(this.jointId);
            }
        } else if (StringUtil.isNumeric((String)value)) {
            this.setParameterValue(name, Float.parseFloat(value));
        } else {
            throw new ControllerParameterException("Invalid parameter setting " + name + "=" + value);
        }
    }

    @Override
    public void setParameterValue(String name, float value) throws ControllerParameterException {
        if (name.equals("anglex")) {
            this.anglex = -value;
        } else if (name.equals("angley")) {
            this.angley = -value;
        } else if (name.equals("anglez")) {
            this.anglez = -value;
        } else if (name.equals("ksx")) {
            this.ksx = value;
        } else if (name.equals("ksy")) {
            this.ksy = value;
        } else if (name.equals("ksz")) {
            this.ksz = value;
        } else if (name.equals("dsx")) {
            this.dsx = value;
        } else if (name.equals("dsy")) {
            this.dsy = value;
        } else if (name.equals("dsz")) {
            this.dsz = value;
        } else {
            throw new ControllerParameterNotFoundException(name);
        }
    }

    @Override
    public String[] getDesiredJointIDs() {
        return this.desJointIDs;
    }
}

