/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.assembler;

import hmi.animation.VJoint;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GShape;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.AABoxFitter;
import hmi.physics.JointType;
import hmi.physics.Mass;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.assembler.BodyDensities;
import hmi.physics.assembler.CollisionModel;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalSegmentAssembler
extends XMLStructureAdapter {
    public VJoint startJoint;
    private VJoint human;
    public PhysicalSegment segment;
    public ArrayList<VJoint> endJoints = new ArrayList();
    private boolean isRoot = false;
    private PhysicalHumanoid pHuman;
    private Logger logger = LoggerFactory.getLogger((String)PhysicalSegmentAssembler.class.getName());

    public PhysicalSegmentAssembler(VJoint h, PhysicalHumanoid ph, PhysicalSegment seg) {
        this.human = h;
        this.segment = seg;
        this.pHuman = ph;
    }

    public String toString() {
        return this.segment.getSid();
    }

    private void findEndJoints(VJoint start, String[] joints, String[] ej) {
        for (VJoint j : start.getChildren()) {
            boolean isEndJoint = false;
            for (int i = 0; i < ej.length; ++i) {
                if (!ej[i].equals(j.getSid())) continue;
                this.endJoints.add(j);
                isEndJoint = true;
                break;
            }
            if (isEndJoint) continue;
            if (j.getChildren().size() == 0) {
                this.endJoints.add(j);
                continue;
            }
            boolean found = false;
            for (int i = 0; i < joints.length; ++i) {
                if (!joints[i].equals(j.getSid())) continue;
                this.endJoints.add(j);
                found = true;
                break;
            }
            if (found) continue;
            this.findEndJoints(j, joints, ej);
        }
    }

    private void findJoints(VJoint start, String[] jointNames, String[] endJoints, ArrayList<VJoint> joints) {
        for (VJoint j : start.getChildren()) {
            int i;
            boolean found = false;
            for (i = 0; i < jointNames.length; ++i) {
                if (!jointNames[i].equals(j.getSid())) continue;
                found = true;
                break;
            }
            if (found) continue;
            found = false;
            for (i = 0; i < endJoints.length; ++i) {
                if (!endJoints[i].equals(j.getSid())) continue;
                found = true;
                break;
            }
            if (found) continue;
            joints.add(j);
            this.findJoints(j, jointNames, endJoints, joints);
        }
    }

    private void findNodes(GNode rootNode, ArrayList<GNode> nodes, ArrayList<VJoint> segmentJoints) {
        for (VJoint vj : segmentJoints) {
            if (!vj.getSid().equals(rootNode.getSid())) continue;
            nodes.add(rootNode);
        }
        for (GNode gn : rootNode.getChildNodes()) {
            this.findNodes(gn, nodes, segmentJoints);
        }
    }

    public void createFromGNode(String phID, GNode rootNode, String jointName, String[] joints, String[] endJ) {
        this.startJoint = this.human.getPart(jointName);
        if (this.startJoint == null) {
            throw new RuntimeException("Start joint not found in human: " + jointName);
        }
        this.segment.setId(this.startJoint.getSid() + "_segment");
        this.findEndJoints(this.startJoint, joints, endJ);
        ArrayList<VJoint> segmentJoints = new ArrayList<VJoint>();
        segmentJoints.add(this.startJoint);
        this.findJoints(this.startJoint, joints, endJ, segmentJoints);
        this.segment.setSid(this.startJoint.getSid());
        this.segment.setId(phID + "_" + this.startJoint.getSid());
        ArrayList<GNode> nodes = new ArrayList<GNode>();
        this.findNodes(rootNode, nodes, segmentJoints);
        float totalMass = 0.0f;
        Mass totalM = null;
        float[] cTotal = new float[3];
        float[] c2 = new float[3];
        float[] c = new float[3];
        float[] I = new float[9];
        AABoxFitter fitter = new AABoxFitter();
        float[] jTrans = new float[3];
        int i = 0;
        for (GNode node : nodes) {
            VJoint vj = segmentJoints.get(i);
            float density = ((Float)BodyDensities.bodyDensityMap.get((Object)vj.getSid())).floatValue();
            ++i;
            vj.getPathTranslation(this.startJoint, jTrans);
            List shapes = node.getGShapes();
            for (GShape s : shapes) {
                Mass m = this.segment.createMass();
                if (s.getGMesh().getVCountData() != null) {
                    s.getGMesh().triangulate();
                }
                m.setFromGMesh(s.getGMesh(), density);
                m.getCOM(c);
                m.translate(-c[0], -c[1], -c[2]);
                Vec3f.add((float[])c, (float[])jTrans);
                if (totalM == null) {
                    totalM = m;
                    Vec3f.set((float[])cTotal, (float[])c);
                } else {
                    totalM.addMass(m, cTotal, c, c2);
                    Vec3f.set((float[])cTotal, (float[])c2);
                }
                totalMass += m.getMass();
            }
        }
        i = 0;
        for (GNode node : nodes) {
            List shapes = node.getGShapes();
            VJoint vj = segmentJoints.get(i);
            ++i;
            vj.getPathTranslation(this.startJoint, jTrans);
            for (GShape s : shapes) {
                float[] vertices = s.getGMesh().getVertexData("mcPosition");
                fitter.fit(vertices);
                float[] q = new float[4];
                float[] tr = new float[3];
                Vec3f.set((float[])tr, (float[])fitter.center);
                Vec3f.sub((float[])tr, (float[])cTotal);
                Vec3f.add((float[])tr, (float[])jTrans);
                Quat4f.setIdentity((float[])q);
                this.segment.box.addBox(q, tr, fitter.half_extends);
            }
        }
        this.segment.box.setTranslation(cTotal);
        this.segment.box.adjustMass(totalMass);
        totalM.getInertiaTensor(I);
        this.segment.box.setInertiaTensor(I);
        float[] trans = new float[3];
        this.startJoint.getPathTranslation(null, trans);
        Vec3f.add((float[])trans, (float[])cTotal);
        this.segment.box.setTranslation(trans);
        this.segment.box.getInertiaTensor(I);
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        if (attrName.equals("startJoint")) {
            this.startJoint = this.human.getPart(attrValue);
            if (this.startJoint == null) {
                throw new RuntimeException("NULL STARTJOINT: " + attrValue + " on human " + this.human.getName());
            }
            this.segment.setId(this.pHuman.getId() + "_" + this.startJoint.getSid() + "_segment");
            this.segment.setSid(this.startJoint.getSid());
            return true;
        }
        if (attrName.equals("endJoint")) {
            String[] joint = attrValue.split(" ");
            for (int i = 0; i < joint.length; ++i) {
                VJoint endJoint = this.human.getPart(joint[i]);
                if (endJoint == null) {
                    this.logger.warn("NULL ENDJOINT: {} on human {}", (Object)joint[i], (Object)this.human.getName());
                }
                this.endJoints.add(endJoint);
            }
            return true;
        }
        if (attrName.equals("mass")) {
            this.segment.box.adjustMass(Float.parseFloat(attrValue));
            return true;
        }
        if (attrName.equals("type")) {
            if (attrValue.equals("fixed")) {
                this.segment.jointType = JointType.FIXED;
            } else if (attrValue.equals("hinge")) {
                this.segment.jointType = JointType.HINGE;
            } else if (attrValue.equals("universal")) {
                this.segment.jointType = JointType.UNIVERSAL;
            } else if (attrValue.equals("ball")) {
                this.segment.jointType = JointType.BALL;
            } else {
                return false;
            }
            return true;
        }
        if (attrName.equals("axis1")) {
            String[] vals = attrValue.split(" ");
            this.segment.axis1[0] = Float.parseFloat(vals[0]);
            this.segment.axis1[1] = Float.parseFloat(vals[1]);
            this.segment.axis1[2] = Float.parseFloat(vals[2]);
            return true;
        }
        if (attrName.equals("axis2")) {
            String[] vals = attrValue.split(" ");
            this.segment.axis2[0] = Float.parseFloat(vals[0]);
            this.segment.axis2[1] = Float.parseFloat(vals[1]);
            this.segment.axis2[2] = Float.parseFloat(vals[2]);
            return true;
        }
        if (attrName.equals("hiStop1")) {
            this.segment.hiStop[0] = Float.parseFloat(attrValue);
            return true;
        }
        if (attrName.equals("hiStop2")) {
            this.segment.hiStop[1] = Float.parseFloat(attrValue);
            return true;
        }
        if (attrName.equals("hiStop3")) {
            this.segment.hiStop[2] = Float.parseFloat(attrValue);
            return true;
        }
        if (attrName.equals("loStop1")) {
            this.segment.loStop[0] = Float.parseFloat(attrValue);
            return true;
        }
        if (attrName.equals("loStop2")) {
            this.segment.loStop[1] = Float.parseFloat(attrValue);
            return true;
        }
        if (attrName.equals("loStop3")) {
            this.segment.loStop[2] = Float.parseFloat(attrValue);
            return true;
        }
        if (attrName.equals("position")) {
            String[] vals = attrValue.split(" ");
            float[] pos = new float[]{Float.parseFloat(vals[0]), Float.parseFloat(vals[1]), Float.parseFloat(vals[2])};
            this.segment.box.setTranslation(pos);
        } else if (attrName.equals("I")) {
            String[] vals = attrValue.split(" ");
            float[] I = new float[9];
            for (int i = 0; i < 9; ++i) {
                I[i] = Float.parseFloat(vals[i]);
            }
            this.segment.box.setInertiaTensor(I);
        }
        return false;
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            if (!tokenizer.atSTag("CollisionModel")) continue;
            CollisionModel cm = new CollisionModel(this.segment.box);
            cm.readXML(tokenizer);
        }
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        PhysicalSegmentAssembler.appendNewLine((StringBuilder)buf);
        CollisionModel cm = new CollisionModel(this.segment.box);
        cm.appendXML(buf, fmt);
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        int i;
        PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"startJoint", (String)this.startJoint.getSid());
        StringBuffer str = new StringBuffer();
        for (VJoint j : this.endJoints) {
            str.append(" " + j.getName());
        }
        PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"endJoint", (String)str.substring(1));
        PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"mass", (float)this.segment.box.getMass());
        float[] pos = new float[3];
        this.segment.box.getTranslation(pos);
        PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"position", (String)(pos[0] + " " + pos[1] + " " + pos[2]));
        float[] I = new float[9];
        this.segment.box.getInertiaTensor(I);
        str = new StringBuffer("" + I[0]);
        for (i = 1; i < 9; ++i) {
            str.append(" " + I[i]);
        }
        PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"I", (String)str.toString());
        if (!this.isRoot()) {
            PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"type", (String)this.segment.jointType.getTypeAsString());
            PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"axis1", (String)(this.segment.axis1[0] + " " + this.segment.axis1[1] + " " + this.segment.axis1[2]));
            PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"axis2", (String)(this.segment.axis2[0] + " " + this.segment.axis2[1] + " " + this.segment.axis2[2]));
            for (i = 0; i < 3; ++i) {
                if ((double)this.segment.loStop[i] > -Math.PI) {
                    PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)("loStop" + (i + 1)), (float)this.segment.loStop[i]);
                }
                if (!((double)this.segment.hiStop[i] < Math.PI)) continue;
                PhysicalSegmentAssembler.appendAttribute((StringBuilder)buf, (String)("hiStop" + (i + 1)), (float)this.segment.hiStop[i]);
            }
        }
        return buf;
    }

    public String getXMLTag() {
        if (this.isRoot) {
            return "PhysicalRootSegment";
        }
        return "PhysicalSegment";
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }
}

