/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.ode;

import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.JointType;
import hmi.physics.PhysicalJoint;
import hmi.physics.RigidBody;
import hmi.physics.ode.OdeRigidBody;
import org.odejava.Body;
import org.odejava.Joint;
import org.odejava.JointAMotor;
import org.odejava.JointBall;
import org.odejava.JointFixed;
import org.odejava.JointGroup;
import org.odejava.JointHinge;
import org.odejava.JointUniversal;
import org.odejava.World;
import org.odejava.ode.OdeConstants;

public class OdeJoint
extends PhysicalJoint {
    private Joint physicalJoint;
    private JointAMotor physicalMotor;
    private JointGroup jointGroup;
    private World world;
    private Body box1;
    private Body box2;
    private float[] w1 = new float[3];
    private float[] w2 = new float[3];
    private float[] q = new float[4];

    public OdeJoint(JointType t, String name, World w, JointGroup jg) {
        super(t, name);
        this.world = w;
        this.jointGroup = jg;
        this.createJoint();
    }

    private void createJoint() {
        switch (this.type) {
            default: {
                this.physicalJoint = new JointFixed(this.name, this.world, this.jointGroup);
                break;
            }
            case HINGE: {
                this.physicalJoint = new JointHinge(this.name, this.world, this.jointGroup);
                break;
            }
            case UNIVERSAL: {
                this.physicalJoint = new JointUniversal(this.name, this.world, this.jointGroup);
                break;
            }
            case BALL: {
                this.physicalJoint = new JointBall(this.name, this.world, this.jointGroup);
            }
        }
        this.physicalMotor = new JointAMotor(this.name + "_motor", this.world, this.jointGroup);
        this.physicalMotor.enableFeedbackTracking();
    }

    @Override
    public void getTorque1(float[] torque) {
        torque[0] = this.physicalMotor.getFeedback().getTorque1().getX();
        torque[1] = this.physicalMotor.getFeedback().getTorque1().getY();
        torque[2] = this.physicalMotor.getFeedback().getTorque1().getZ();
    }

    @Override
    public void getTorque2(float[] torque) {
        torque[0] = this.physicalMotor.getFeedback().getTorque2().getX();
        torque[1] = this.physicalMotor.getFeedback().getTorque2().getY();
        torque[2] = this.physicalMotor.getFeedback().getTorque2().getZ();
    }

    @Override
    public void getForce2(float[] force) {
        force[0] = this.physicalMotor.getFeedback().getForce2().getX();
        force[1] = this.physicalMotor.getFeedback().getForce2().getY();
        force[2] = this.physicalMotor.getFeedback().getForce2().getZ();
    }

    @Override
    public void getForce1(float[] force) {
        force[0] = this.physicalMotor.getFeedback().getForce1().getX();
        force[1] = this.physicalMotor.getFeedback().getForce1().getY();
        force[2] = this.physicalMotor.getFeedback().getForce1().getZ();
    }

    @Override
    public void addTorque(float x, float y, float z) {
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
            throw new RuntimeException("Adding torque componenent with NaN force (" + x + "," + y + "," + z + ")");
        }
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isInfinite(z)) {
            throw new RuntimeException("Adding torque componenent with infinite force (" + x + "," + y + "," + z + ")");
        }
        this.physicalMotor.addTorque(x, y, z);
    }

    @Override
    public float getAngle(int axis) {
        return this.physicalMotor.getAngle(axis);
    }

    @Override
    public void setDesiredVelocity(int axis, float value) {
        switch (axis) {
            case 0: {
                this.physicalMotor.setParam(OdeConstants.dParamVel, value);
                return;
            }
            case 1: {
                this.physicalMotor.setParam(OdeConstants.dParamVel2, value);
                return;
            }
            case 2: {
                this.physicalMotor.setParam(OdeConstants.dParamVel3, value);
                return;
            }
        }
    }

    @Override
    public void setMaximumForce(int axis, float value) {
        switch (axis) {
            case 0: {
                this.physicalMotor.setParam(OdeConstants.dParamFMax, value);
                return;
            }
            case 1: {
                this.physicalMotor.setParam(OdeConstants.dParamFMax2, value);
                return;
            }
            case 2: {
                this.physicalMotor.setParam(OdeConstants.dParamFMax3, value);
                return;
            }
        }
    }

    @Override
    public void setJointMin(int axis, float min) {
        super.setJointMin(axis, min);
        switch (axis) {
            case 0: {
                this.physicalMotor.setParam(OdeConstants.dParamLoStop, min);
                return;
            }
            case 1: {
                this.physicalMotor.setParam(OdeConstants.dParamLoStop2, min);
                return;
            }
            case 2: {
                this.physicalMotor.setParam(OdeConstants.dParamLoStop3, min);
                return;
            }
        }
    }

    @Override
    public void setJointMax(int axis, float max) {
        super.setJointMax(axis, max);
        switch (axis) {
            case 0: {
                this.physicalMotor.setParam(OdeConstants.dParamHiStop, max);
                return;
            }
            case 1: {
                this.physicalMotor.setParam(OdeConstants.dParamHiStop2, max);
                return;
            }
            case 2: {
                this.physicalMotor.setParam(OdeConstants.dParamHiStop3, max);
                return;
            }
        }
    }

    @Override
    public void setAxis(int axis, float x, float y, float z) {
        switch (axis) {
            case 0: {
                this.physicalJoint.setAxis1(x, y, z);
                return;
            }
            case 1: {
                this.physicalJoint.setAxis2(x, y, z);
                return;
            }
        }
    }

    @Override
    public float[] getAnchor(float[] src) {
        if (src == null) {
            src = new float[3];
        }
        switch (this.type) {
            default: {
                src = null;
                break;
            }
            case HINGE: {
                ((JointHinge)this.physicalJoint).getAnchor(src);
                break;
            }
            case UNIVERSAL: {
                ((JointUniversal)this.physicalJoint).getAnchor(src);
                break;
            }
            case BALL: {
                ((JointBall)this.physicalJoint).getAnchor(src);
            }
        }
        return src;
    }

    @Override
    public void setAnchor(float x, float y, float z) {
        switch (this.type) {
            default: {
                ((JointFixed)this.physicalJoint).setFixed();
                break;
            }
            case HINGE: {
                ((JointHinge)this.physicalJoint).setAnchor(x, y, z);
                break;
            }
            case UNIVERSAL: {
                ((JointUniversal)this.physicalJoint).setAnchor(x, y, z);
                break;
            }
            case BALL: {
                ((JointBall)this.physicalJoint).setAnchor(x, y, z);
            }
        }
        this.physicalMotor.setMode(OdeConstants.dAMotorEuler);
        this.physicalMotor.setNumAxes(3);
        this.physicalMotor.setAxis(0, 1, 1.0f, 0.0f, 0.0f);
        this.physicalMotor.setAxis(1, 1, 0.0f, 1.0f, 0.0f);
        this.physicalMotor.setAxis(2, 1, 0.0f, 0.0f, 1.0f);
        this.physicalMotor.setParam(OdeConstants.dParamFudgeFactor, 0.8f);
        this.physicalMotor.setParam(OdeConstants.dParamFudgeFactor2, 0.8f);
        this.physicalMotor.setParam(OdeConstants.dParamFudgeFactor3, 0.8f);
        this.physicalMotor.setParam(OdeConstants.dParamStopCFM, 0.2f);
        this.physicalMotor.setParam(OdeConstants.dParamStopCFM2, 0.2f);
        this.physicalMotor.setParam(OdeConstants.dParamStopCFM3, 0.2f);
    }

    public void attach(RigidBody b1, RigidBody b2) {
        if (b1 != null) {
            this.box1 = ((OdeRigidBody)b1).getBody();
        } else {
            this.box2 = null;
        }
        this.box2 = b2 != null ? ((OdeRigidBody)b2).getBody() : null;
        this.physicalJoint.attach(this.box1, this.box2);
        this.physicalMotor.attach(this.box1, this.box2);
    }

    @Override
    public void getAngularVelocity(float[] w) {
        this.box1.getAngularVel(this.w1);
        if (this.box2 != null) {
            this.box2.getAngularVel(this.w2);
            this.box2.getQuaternion(this.q);
        } else {
            Vec3f.setZero((float[])this.w2);
            Quat4f.setIdentity((float[])this.q);
        }
        Vec3f.sub((float[])w, (float[])this.w2, (float[])this.w1);
        Quat4f.transformVec3f((float[])this.q, (float[])w);
    }

    @Override
    public void getAngularVelocity(float[] w, int i) {
        this.box1.getAngularVel(this.w1);
        this.box2.getAngularVel(this.w2);
        Vec3f.sub((float[])w, (int)i, (float[])this.w2, (int)0, (float[])this.w1, (int)0);
        this.box2.getQuaternion(this.q);
        Quat4f.transformVec3f((float[])this.q, (int)0, (float[])w, (int)i);
    }
}

