/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import hmi.animation.Hanim;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.controller.ControllerParameterNotFoundException;
import hmi.physics.controller.PhysicalController;

public class RagdollController
implements PhysicalController {
    private PhysicalHumanoid ph;
    private String[] jointIDs = Hanim.all_body_joints;
    private String[] reqJointIDs = new String[0];

    @Override
    public void reset() {
    }

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid p) {
        if (this.ph != p) {
            this.ph = p;
        }
    }

    public void setJointIDs(String[] newJointIDs) {
        this.jointIDs = newJointIDs;
    }

    @Override
    public String[] getRequiredJointIDs() {
        return this.reqJointIDs;
    }

    @Override
    public String[] getDesiredJointIDs() {
        return this.jointIDs;
    }

    public RagdollController(PhysicalHumanoid p, String[] newJointIDs) {
        this(p);
        this.setJointIDs(newJointIDs);
    }

    public RagdollController() {
    }

    public RagdollController(PhysicalHumanoid p) {
        this.setPhysicalHumanoid(p);
        this.reset();
    }

    @Override
    public void update(double timeDiff) {
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        RagdollController result = new RagdollController(ph);
        result.setJointIDs(this.jointIDs);
        return result;
    }

    @Override
    public String getParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("joints")) {
            StringBuffer result = new StringBuffer("");
            for (String s : this.jointIDs) {
                result.append("," + s);
            }
            return result.substring(1);
        }
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public void setParameterValue(String name, String value) throws ControllerParameterNotFoundException {
        String[] ragdollJointIDs;
        if (name.equals("joints")) {
            if (value.trim().equals("")) {
                return;
            }
            ragdollJointIDs = value.split(",");
            for (int i = 0; i < ragdollJointIDs.length; ++i) {
                ragdollJointIDs[i] = ragdollJointIDs[i].trim();
            }
        } else {
            throw new ControllerParameterNotFoundException(name);
        }
        this.setJointIDs(ragdollJointIDs);
    }

    @Override
    public void setParameterValue(String name, float value) throws ControllerParameterNotFoundException {
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public float getFloatParameterValue(String name) throws ControllerParameterNotFoundException {
        throw new ControllerParameterNotFoundException(name);
    }
}

