/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.ode;

import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.math.Vec4f;
import hmi.physics.CollisionShape;
import hmi.physics.Mass;
import hmi.physics.RigidBody;
import hmi.physics.ode.OdeCollisionBox;
import hmi.physics.ode.OdeCollisionCapsule;
import hmi.physics.ode.OdeCollisionShape;
import hmi.physics.ode.OdeCollisionSphere;
import hmi.physics.ode.OdeMass;
import org.odejava.Body;
import org.odejava.Geom;
import org.odejava.PlaceableGeom;
import org.odejava.Space;
import org.odejava.World;

public class OdeRigidBody
extends RigidBody {
    private Body body;
    private World world;
    private Space space;
    private OdeMass mass;
    private int shapeNr = 0;
    private float[] tempv = new float[4];
    private float[] tempq = new float[4];

    public OdeRigidBody(String n, World w, Space s) {
        this.world = w;
        this.space = s;
        this.id = n;
        this.sid = n;
        this.body = new Body(this.id, this.world);
        this.mass = new OdeMass(this.body.getdMass());
    }

    @Override
    public float getMass() {
        return this.mass.getMass();
    }

    public void setMass(OdeMass m) {
        this.mass = m;
        this.body.setMass(m.getOMass());
    }

    @Override
    public void setId(String n) {
        this.id = new String(n);
        this.body.setName(n);
        for (CollisionShape cs : this.collisionShapes) {
            OdeCollisionShape ocs = (OdeCollisionShape)((Object)cs);
            ocs.setBodyName(n);
        }
    }

    @Override
    public void setTranslation(float x, float y, float z) {
        this.body.setPosition(x, y, z);
    }

    @Override
    public void setRotation(float w, float x, float y, float z) {
        this.body.setQuatWXYZ(w, x, y, z);
    }

    @Override
    public void setAngularVelocity(float x, float y, float z) {
        this.body.setAngularVel(x, y, z);
    }

    @Override
    public void setForce(float x, float y, float z) {
        this.checkForce(x, y, z);
        this.body.setForce(x, y, z);
    }

    protected void checkForce(float x, float y, float z) {
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
            throw new RuntimeException("Force componenent with NaN force (" + x + "," + y + "," + z + ")");
        }
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isInfinite(z)) {
            throw new RuntimeException("Force componenent with infinite force (" + x + "," + y + "," + z + ")");
        }
    }

    @Override
    public void addForce(float x, float y, float z) {
        this.checkForce(x, y, z);
        this.body.addForce(x, y, z);
    }

    @Override
    public void addForceAtRelPos(float fx, float fy, float fz, float px, float py, float pz) {
        this.checkForce(fx, fy, fz);
        this.body.addForceAtRelPos(fx, fy, fz, px, py, pz);
    }

    @Override
    public void addForceAtPos(float fx, float fy, float fz, float px, float py, float pz) {
        this.checkForce(fx, fy, fz);
        this.body.addForceAtRelPos(fx, fy, fz, px, py, pz);
    }

    @Override
    public void setVelocity(float x, float y, float z) {
        this.body.setLinearVel(x, y, z);
    }

    @Override
    public void setTorque(float x, float y, float z) {
        this.checkForce(x, y, z);
        this.body.setTorque(x, y, z);
    }

    @Override
    public void addTorque(float x, float y, float z) {
        this.checkForce(x, y, z);
        this.body.addTorque(x, y, z);
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public void getTranslation(float[] pos) {
        this.body.getPosition(pos);
    }

    public void getTranslation(float[] pos, int idx) {
        this.body.getPosition(this.tempv);
        Vec3f.set((float[])pos, (int)idx, (float[])this.tempv, (int)0);
    }

    private void addCollisionGeom(PlaceableGeom g) {
        this.space.add((Geom)g);
        this.body.addCollisionGeom(g);
    }

    private void removeCollisionGeom(PlaceableGeom g) {
        this.space.remove((Geom)g);
        this.body.removeGeom(g);
    }

    @Override
    public void getRotation(float[] result) {
        this.body.getQuatWXYZ(result);
    }

    @Override
    public void getRotation(float[] result, int idx) {
        this.body.getQuatWXYZ(this.tempv);
        Vec4f.set((float[])result, (int)idx, (float[])this.tempv, (int)0);
    }

    @Override
    public void getAngularVelocity(float[] result) {
        this.body.getAngularVel(result);
    }

    @Override
    public void getAngularVelocity(float[] vc, int vcIndex) {
        this.body.getAngularVel(this.tempv);
        Vec3f.set((float[])vc, (int)vcIndex, (float[])this.tempv, (int)0);
    }

    @Override
    public void getVelocity(float[] result) {
        this.body.getLinearVel(result);
    }

    public void getVelocity(float[] result, int idx) {
        this.body.getLinearVel(this.tempv);
        Vec3f.set((float[])result, (int)idx, (float[])this.tempv, (int)0);
    }

    @Override
    public void adjustMass(float m) {
        this.mass.adjustMass(m, this.body);
    }

    @Override
    public OdeCollisionBox addBox(float[] halfExtends) {
        OdeCollisionBox b = new OdeCollisionBox(halfExtends, this.id + "_collision" + this.shapeNr);
        this.addCollisionGeom(b.root);
        this.collisionShapes.add(b);
        ++this.shapeNr;
        return b;
    }

    @Override
    public OdeCollisionBox addBox(float[] q, float[] tr, float[] halfExtends) {
        OdeCollisionBox b = new OdeCollisionBox(q, tr, halfExtends, this.id + "_collision" + this.shapeNr);
        this.addCollisionGeom(b.root);
        this.collisionShapes.add(b);
        ++this.shapeNr;
        return b;
    }

    @Override
    public OdeCollisionCapsule addCapsule(float[] q, float[] tr, float radius, float height) {
        OdeCollisionCapsule c = new OdeCollisionCapsule(q, tr, radius, height, this.id + "_collision" + this.shapeNr);
        this.addCollisionGeom(c.root);
        this.collisionShapes.add(c);
        ++this.shapeNr;
        return c;
    }

    @Override
    public OdeCollisionCapsule addCapsule(float radius, float height) {
        OdeCollisionCapsule c = new OdeCollisionCapsule(radius, height, this.id + "_collision" + this.shapeNr);
        this.addCollisionGeom(c.root);
        this.collisionShapes.add(c);
        ++this.shapeNr;
        return c;
    }

    @Override
    public OdeCollisionSphere addSphere(float[] tr, float radius) {
        OdeCollisionSphere s = new OdeCollisionSphere(tr, radius, this.id + "_collision" + this.shapeNr);
        this.addCollisionGeom(s.root);
        this.collisionShapes.add(s);
        ++this.shapeNr;
        return s;
    }

    @Override
    public OdeCollisionSphere addSphere(float radius) {
        OdeCollisionSphere s = new OdeCollisionSphere(radius, this.id + "collision" + this.shapeNr);
        this.addCollisionGeom(s.root);
        this.collisionShapes.add(s);
        ++this.shapeNr;
        return s;
    }

    @Override
    public void getCOM(float[] com) {
        this.mass.getCOM(com);
    }

    @Override
    public void getInertiaTensor(float[] I) {
        this.mass.getInertiaTensor(I);
    }

    @Override
    public void setCOM(float[] com) {
        this.mass.setCOM(com, this.body);
    }

    @Override
    public void setInertiaTensor(float[] I) {
        this.mass.setInertiaTensor(I, this.body);
    }

    @Override
    public void removeCollisionShape(CollisionShape s) {
        OdeCollisionShape os = (OdeCollisionShape)((Object)s);
        this.removeCollisionGeom(os.getRoot());
        this.collisionShapes.remove(s);
    }

    @Override
    public void clear() {
        super.clear();
        System.out.println("Removing body" + this.body.getName());
        for (Geom g : this.body.getGeoms()) {
            this.space.remove(g);
        }
        if (this.world.containsBody(this.body.getName())) {
            this.world.deleteBody(this.body);
        }
    }

    @Override
    public void getPointRelPosition(float[] dst, float[] point) {
        this.body.getRelPointPos(point[0], point[1], point[2], dst);
    }

    @Override
    public void getPointVelocity(float[] dst, float[] point) {
        this.body.getPointVel(point[0], point[1], point[2], dst);
    }

    @Override
    public void getRelativePointVelocity(float[] dst, float[] point) {
        this.body.getRelPointVel(point[0], point[1], point[2], dst);
    }

    @Override
    public void addRelTorque(float x, float y, float z) {
        this.checkForce(x, y, z);
        this.body.addRelTorque(x, y, z);
    }

    @Override
    public void getTorque(float[] torque) {
        this.body.getTorque(torque);
    }

    @Override
    public void getForce(float[] force) {
        this.body.getForce(force);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.body.setEnabled(enabled);
        for (Geom g : this.body.getGeoms()) {
            g.setEnabled(enabled);
        }
    }

    @Override
    public void addRelForce(float x, float y, float z) {
        this.getRotation(this.tempq);
        Vec3f.set((float[])this.tempv, (float)x, (float)y, (float)z);
        Quat4f.transformVec3f((float[])this.tempq, (float[])this.tempv);
        this.addForce(this.tempv);
    }

    @Override
    public void addRelForceAtRelPos(float fx, float fy, float fz, float px, float py, float pz) {
        this.body.addRelForceAtRelPos(fx, fy, fz, px, py, pz);
    }

    @Override
    public void rotateInertiaTensor(float[] q) {
        this.mass.rotate(q);
    }

    @Override
    public void translateInertiaTensor(float[] v) {
        this.mass.translate(v);
    }

    @Override
    public Mass createMass() {
        return new OdeMass();
    }
}

