/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.ode;

import hmi.physics.CollisionShape;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.PhysicalSegment;
import hmi.physics.ode.OdeCollisionShape;
import hmi.physics.ode.OdeJoint;
import hmi.physics.ode.OdePhysicalSegment;
import java.util.HashMap;
import org.odejava.GeomPlane;
import org.odejava.JointGroup;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.collision.Contact;
import org.odejava.collision.JavaCollision;

public class OdeHumanoid
extends PhysicalHumanoid {
    private World world;
    private Space space;
    private JointGroup jointGroup;
    private GeomPlane groundGeom = null;
    private JavaCollision collision = null;
    private Contact contact = null;
    private HashMap<Long, PhysicalSegment> geomSegmentMap = new HashMap();

    public OdeHumanoid(String id, World w, Space s) {
        super(id);
        this.world = w;
        this.space = s;
        this.jointGroup = new JointGroup();
    }

    @Override
    public void clear() {
        this.jointGroup.empty();
        this.geomSegmentMap.clear();
        super.clear();
    }

    @Override
    public PhysicalJoint setupJoint(String name, PhysicalSegment seg1, PhysicalSegment seg2, float[] anchor) {
        OdeJoint joint = new OdeJoint(seg2.jointType, name, this.world, this.jointGroup);
        joint.attach(seg1.box, seg2.box);
        joint.setAnchor(anchor[0], anchor[1], anchor[2]);
        joint.setAxis(0, seg2.axis1[0], seg2.axis1[1], seg2.axis1[2]);
        joint.setAxis(1, seg2.axis2[0], seg2.axis2[1], seg2.axis2[2]);
        joint.setJointMax(0, -seg2.loStop[0]);
        joint.setJointMax(1, -seg2.loStop[1]);
        joint.setJointMax(2, -seg2.loStop[2]);
        joint.setJointMin(0, -seg2.hiStop[0]);
        joint.setJointMin(1, -seg2.hiStop[1]);
        joint.setJointMin(2, -seg2.hiStop[2]);
        this.joints.add(joint);
        this.namePhysicalJointMap.put(name, joint);
        return joint;
    }

    @Override
    public void setupHashMaps(PhysicalSegment ps) {
        super.setupHashMaps(ps);
        if (ps.box != null) {
            for (CollisionShape cs : ps.box.getCollisionShapes()) {
                OdeCollisionShape ocs = (OdeCollisionShape)((Object)cs);
                this.geomSegmentMap.put(ocs.getCollisionGeom().getNativeAddr(), ps);
            }
        }
    }

    public void setCollision(JavaCollision col) {
        this.collision = col;
        this.contact = new Contact(this.collision.getContactIntBuffer(), this.collision.getContactFloatBuffer());
    }

    @Override
    protected void handleCollisions() {
        if (this.collision != null) {
            int collisions = this.collision.getContactCount();
            long groundId = this.groundGeom.getNativeAddr();
            for (int i = 0; i < collisions; ++i) {
                this.contact.setIndex(i);
                PhysicalSegment ps = null;
                if (this.contact.getGeomID1() == groundId) {
                    ps = this.getSegment(this.contact.getGeomID2());
                } else if (this.contact.getGeomID2() == groundId) {
                    ps = this.getSegment(this.contact.getGeomID1());
                }
                if (ps == null) continue;
                ps.onGround = true;
            }
        }
    }

    public void setGroundGeom(GeomPlane groundGeom) {
        this.groundGeom = groundGeom;
    }

    public PhysicalSegment getSegment(long geomId) {
        return this.geomSegmentMap.get(geomId);
    }

    @Override
    public PhysicalSegment createSegment(String segmentId, String segmentSID) {
        return new OdePhysicalSegment(segmentId, segmentSID, this.world, this.space);
    }
}

