/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.ode;

import hmi.physics.CollisionSphere;
import hmi.physics.ode.OdeCollisionShape;
import org.odejava.GeomSphere;
import org.odejava.GeomTransform;
import org.odejava.PlaceableGeom;

public class OdeCollisionSphere
extends CollisionSphere
implements OdeCollisionShape {
    public GeomSphere sphere;
    public PlaceableGeom root;
    public String name;

    public OdeCollisionSphere(String n) {
        this.name = new String(n);
        this.createSphere();
    }

    public OdeCollisionSphere(float r, String n) {
        super(r);
        this.name = new String(n);
        this.createSphere();
    }

    public OdeCollisionSphere(float[] tr, float r, String n) {
        super(tr, r);
        this.name = new String(n);
        this.createSphere();
    }

    private void createSphere() {
        this.sphere = new GeomSphere(this.name + "_sphere", this.radius);
        GeomTransform g = new GeomTransform(this.name + "_Geomtransform");
        this.sphere.setPosition(this.translation[0], this.translation[1], this.translation[2]);
        g.setEncapsulatedGeom((PlaceableGeom)this.sphere);
        this.root = g;
    }

    @Override
    public PlaceableGeom getCollisionGeom() {
        return this.root;
    }

    @Override
    public PlaceableGeom getRoot() {
        return this.root;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void setTranslation(float[] v) {
        super.setTranslation(v);
        this.sphere.setPosition(this.translation[0], this.translation[1], this.translation[2]);
    }

    @Override
    public void setBodyName(String bodyName) {
        int index = this.name.indexOf("_");
        this.name = this.name.substring(index);
        this.name = bodyName + this.name;
        this.sphere.setName(this.name + "_sphere");
        this.root.setName(this.name + "_root");
        System.out.println("new collision shape name:" + this.name);
    }
}

