/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.ode;

import hmi.math.Quat4f;
import hmi.physics.CollisionCapsule;
import hmi.physics.ode.OdeCollisionShape;
import org.odejava.GeomCapsule;
import org.odejava.GeomTransform;
import org.odejava.PlaceableGeom;

public class OdeCollisionCapsule
extends CollisionCapsule
implements OdeCollisionShape {
    public GeomCapsule capsule;
    public PlaceableGeom root;
    public String name;
    private GeomTransform g2 = null;
    private GeomTransform g1 = null;

    public OdeCollisionCapsule(String n) {
        this.name = new String(n);
        this.createCapsule();
    }

    public OdeCollisionCapsule(float r, float h, String n) {
        super(r, h);
        this.name = new String(n);
        this.createCapsule();
    }

    public OdeCollisionCapsule(float[] q, float[] tr, float r, float h, String n) {
        super(q, tr, r, h);
        this.name = new String(n);
        this.createCapsule();
    }

    private void createCapsule() {
        this.capsule = new GeomCapsule(this.name + "_capsule", this.radius, this.height);
        float[] q = new float[4];
        float[] aa = new float[]{1.0f, 0.0f, 0.0f, 1.5707964f};
        Quat4f.setFromAxisAngle4f((float[])q, (float[])aa);
        this.capsule.setQuatWXYZ(q[0], q[1], q[2], q[3]);
        this.g1 = new GeomTransform(this.name + "_Geomtransform1");
        this.g1.setEncapsulatedGeom((PlaceableGeom)this.capsule);
        this.g2 = new GeomTransform(this.name + "_Geomtransform2");
        this.g1.setPosition(this.translation[0], this.translation[1], this.translation[2]);
        this.g1.setQuatWXYZ(this.rotation[0], this.rotation[1], this.rotation[2], this.rotation[3]);
        this.g2.setEncapsulatedGeom((PlaceableGeom)this.g1);
        this.root = this.g2;
    }

    @Override
    public void setRotation(float[] q) {
        super.setRotation(q);
        this.g1.setQuatWXYZ(this.rotation[0], this.rotation[1], this.rotation[2], this.rotation[3]);
    }

    @Override
    public void setTranslation(float[] v) {
        super.setTranslation(v);
        this.g1.setPosition(this.translation[0], this.translation[1], this.translation[2]);
    }

    @Override
    public PlaceableGeom getCollisionGeom() {
        return this.root;
    }

    @Override
    public PlaceableGeom getRoot() {
        return this.root;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void setBodyName(String bodyName) {
        int index = this.name.indexOf("_");
        this.name = this.name.substring(index);
        this.name = bodyName + this.name;
        this.capsule.setName(this.name + "_capsule");
        this.g1.setName(this.name + "_geomtransform1");
        if (this.g2 != null) {
            this.g2.setName(this.name + "_geomtransform2");
        }
        System.out.println("new collision shape name:" + this.name);
    }
}

