/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import hmi.math.Vec3f;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.controller.PhysicalController;

public class MeathookBalanceController
implements PhysicalController {
    private float[] springOrig = new float[3];
    private float[] dir = new float[3];
    private float[] dirDiff = new float[3];
    private float[] pos = new float[3];
    private float d0 = 0.1f;
    private float dOffset = 0.1f;
    private float mass;
    private float dRest;
    private float kv;
    private float kd;
    private float Fold;
    private PhysicalHumanoid pHuman;
    private PhysicalSegment seg;
    private final String[] jointIDs = new String[]{"l_ankle", "r_ankle", "r_hip", "l_hip", "r_knee", "l_knee"};
    private String[] desJointIDs = new String[0];

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid p) {
        this.pHuman = p;
        Vec3f.set((float[])this.springOrig, (float)0.0f, (float)5.0f, (float)0.0f);
        this.mass = this.pHuman.getTotalMass();
        this.seg = this.pHuman.getSegment("HumanoidRoot");
        Vec3f.set((float[])this.dir, (float[])this.springOrig);
        this.seg.box.getTranslation(this.pos);
        Vec3f.sub((float[])this.dir, (float[])this.pos);
        this.dRest = Vec3f.length((float[])this.dir) - this.d0 + this.dOffset;
        this.kv = 9.8f / this.d0 * this.mass;
        this.kd = this.kv * 0.01f;
        this.Fold = 0.0f;
    }

    public MeathookBalanceController(PhysicalHumanoid p) {
        this.setPhysicalHumanoid(p);
    }

    @Override
    public void reset() {
    }

    @Override
    public void update(double timeDiff) {
        Vec3f.set((float[])this.dir, (float[])this.springOrig);
        this.seg.box.getTranslation(this.pos);
        Vec3f.sub((float[])this.dir, (float[])this.pos);
        float d = Vec3f.length((float[])this.dir) - this.dRest;
        Vec3f.normalize((float[])this.dir);
        Vec3f.set((float[])this.dirDiff, (float[])this.dir);
        Vec3f.scale((float)(d * this.kv), (float[])this.dir);
        if (this.Fold != 0.0f) {
            Vec3f.scale((float)(-this.kd), (float[])this.dirDiff);
            Vec3f.add((float[])this.dir, (float[])this.dirDiff);
        }
        this.seg.box.addForce(this.dir);
        this.Fold = Vec3f.length((float[])this.dir);
    }

    @Override
    public String[] getRequiredJointIDs() {
        return this.jointIDs;
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        return null;
    }

    @Override
    public String getParameterValue(String name) {
        return null;
    }

    @Override
    public void setParameterValue(String name, String value) {
    }

    @Override
    public void setParameterValue(String name, float value) {
    }

    @Override
    public String[] getDesiredJointIDs() {
        return this.desJointIDs;
    }
}

