/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.controller.PhysicalController;

public class HingeJointController
implements PhysicalController {
    private PhysicalJoint joint;
    private String jointId;
    private float angle;
    private float aprev;
    private static final float KS_DEFAULT = 0.0f;
    private static final float DS_DEFAULT = 1.5f;
    private float ks;
    private float ds;
    private float avel = 0.0f;
    private int axis = 0;
    boolean firstRun = true;
    private PhysicalHumanoid pHuman;
    private String[] jointIDs = new String[1];
    private String[] desJointIDs = new String[0];

    public HingeJointController(PhysicalJoint j, float a, float av, float k, float d, int ax) {
        this.joint = j;
        if (this.joint != null) {
            this.jointId = j.getName();
        }
        this.angle = -a;
        this.avel = av;
        this.ks = k;
        this.ds = d;
        this.axis = ax;
        this.aprev = 0.0f;
    }

    public HingeJointController() {
        this(null, 0.0f);
    }

    public HingeJointController(PhysicalJoint j, float a) {
        this(j, a, 0.0f, 0.0f, 1.5f, 0);
    }

    public void setDamper(float d) {
        this.ds = d;
    }

    public void setSpring(float k) {
        this.ks = k;
    }

    @Override
    public void reset() {
        this.aprev = 0.0f;
        this.firstRun = true;
    }

    @Override
    public void update(double timeDiff) {
        float a = this.joint.getAngle(this.axis);
        if (this.firstRun) {
            float da = 0.0f;
            this.firstRun = false;
            this.aprev = a;
            return;
        }
        float da = (a - this.aprev) / (float)timeDiff;
        switch (this.axis) {
            case 0: {
                this.joint.addTorque((this.angle - a) * this.ks + (this.avel - da) * this.ds, 0.0f, 0.0f);
                break;
            }
            case 1: {
                this.joint.addTorque(0.0f, (this.angle - a) * this.ks + (this.avel - da) * this.ds, 0.0f);
                break;
            }
            case 2: {
                this.joint.addTorque(0.0f, 0.0f, (this.angle - a) * this.ks + (this.avel - da) * this.ds);
            }
        }
        this.aprev = a;
    }

    @Override
    public String[] getRequiredJointIDs() {
        this.jointIDs[0] = this.jointId;
        return this.jointIDs;
    }

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid ph) {
        this.joint = ph.getJoint(this.jointId);
        this.pHuman = ph;
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        HingeJointController hjc = new HingeJointController(this.joint, -this.angle, this.avel, this.ks, this.ds, this.axis);
        hjc.aprev = this.aprev;
        hjc.setPhysicalHumanoid(ph);
        hjc.setParameterValue("joint", this.jointId);
        return hjc;
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("ks")) {
            return "" + this.ks;
        }
        if (name.equals("ds")) {
            return "" + this.ds;
        }
        if (name.equals("angle")) {
            return "" + this.angle;
        }
        if (name.equals("joint")) {
            return this.jointId;
        }
        if (name.equals("axis")) {
            return "" + this.axis;
        }
        return null;
    }

    @Override
    public void setParameterValue(String name, String value) {
        if (name.equals("ks")) {
            this.setSpring(Float.parseFloat(value));
        } else if (name.equals("ds")) {
            this.setDamper(Float.parseFloat(value));
        } else if (name.equals("angle")) {
            this.angle = -Float.parseFloat(value);
        } else if (name.equals("axis")) {
            this.axis = Integer.parseInt(value);
        } else if (name.equals("joint")) {
            this.jointId = value;
            if (this.pHuman != null) {
                this.joint = this.pHuman.getJoint(this.jointId);
            }
        }
    }

    @Override
    public void setParameterValue(String name, float value) {
        if (name.equals("ks")) {
            this.setSpring(value);
        } else if (name.equals("ds")) {
            this.setDamper(value);
        } else if (name.equals("angle")) {
            this.angle = -value;
        } else if (name.equals("axis")) {
            this.axis = (int)value;
        }
    }

    @Override
    public String[] getDesiredJointIDs() {
        return this.desJointIDs;
    }
}

