/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.controller.PhysicalController;

public class FrictionController
implements PhysicalController {
    private float friction = 0.0f;
    private PhysicalJoint joint = null;
    private float[] oldAngle = new float[3];
    private float[] dAngle = new float[3];
    private String[] jointIDs = new String[1];
    private String[] desJointIDs = new String[0];
    private String jointId;
    private PhysicalHumanoid pHuman;

    public FrictionController() {
    }

    public FrictionController(PhysicalJoint j, float fric) {
        this.joint = j;
        this.friction = fric;
        if (j != null) {
            this.jointId = j.getName();
        }
        this.reset();
    }

    public void setFriction(float f) {
        this.friction = f;
    }

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid ph) {
        this.joint = ph.getJoint(this.joint.getName());
        this.pHuman = ph;
    }

    @Override
    public void reset() {
        for (int i = 0; i < 3; ++i) {
            this.oldAngle[i] = 0.0f;
            this.dAngle[i] = 0.0f;
        }
    }

    @Override
    public void update(double timeDiff) {
        this.dAngle[0] = (this.joint.getAngle(0) - this.oldAngle[0]) * -this.friction;
        this.dAngle[1] = (this.joint.getAngle(1) - this.oldAngle[1]) * -this.friction;
        this.dAngle[2] = (this.joint.getAngle(2) - this.oldAngle[2]) * -this.friction;
        this.joint.addTorque(this.dAngle[0], this.dAngle[1], this.dAngle[2]);
        this.oldAngle[0] = this.joint.getAngle(0);
        this.oldAngle[1] = this.joint.getAngle(1);
        this.oldAngle[2] = this.joint.getAngle(2);
    }

    @Override
    public String[] getRequiredJointIDs() {
        this.jointIDs[0] = this.joint.getName();
        return this.jointIDs;
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        FrictionController fjc = new FrictionController(this.joint, this.friction);
        fjc.setPhysicalHumanoid(ph);
        fjc.setParameterValue("joint", this.jointId);
        return fjc;
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("friction")) {
            return "" + this.friction;
        }
        if (name.equals("joint")) {
            return this.jointId;
        }
        return null;
    }

    @Override
    public void setParameterValue(String name, String value) {
        if (name.equals("friction")) {
            this.setFriction(Float.parseFloat(value));
        } else if (name.equals("joint")) {
            this.jointId = value;
            this.joint = this.pHuman.getJoint(this.jointId);
        }
    }

    @Override
    public void setParameterValue(String name, float value) {
        if (name.equals("friction")) {
            this.setFriction(value);
        }
    }

    @Override
    public String[] getDesiredJointIDs() {
        return this.desJointIDs;
    }
}

