/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.controller.PhysicalController;

public class BallJointController
implements PhysicalController {
    private PhysicalJoint joint;
    private String jointId;
    private float anglex;
    private float angley;
    private float anglez;
    private float avelx;
    private float avely;
    private float avelz;
    private float aprevx;
    private float aprevy;
    private float aprevz;
    private float ksx = 0.0f;
    private float dsx = 2.0f;
    private float ksy = 1.0f;
    private float dsy = 2.0f;
    private float ksz = 1.0f;
    private float dsz = 2.0f;
    private static final float DEFAULT_KSX = 1.0f;
    private static final float DEFAULT_DSX = 2.0f;
    private static final float DEFAULT_KSY = 1.0f;
    private static final float DEFAULT_DSY = 2.0f;
    private static final float DEFAULT_KSZ = 1.0f;
    private static final float DEFAULT_DSZ = 2.0f;
    private String[] jointIDs = new String[1];
    private String[] desJointIDs = new String[0];
    private boolean firstRun = true;
    private PhysicalHumanoid pHuman;

    public BallJointController(PhysicalJoint j, float ax, float ay, float az, float avx, float avy, float avz, float kx, float ky, float kz, float dx, float dy, float dz) {
        this.joint = j;
        if (this.joint != null) {
            this.jointId = j.getName();
        }
        this.anglex = -ax;
        this.angley = -ay;
        this.anglez = -az;
        this.avelx = avx;
        this.avely = avy;
        this.avelz = avz;
        this.ksx = kx;
        this.dsx = ky;
        this.ksy = kz;
        this.dsy = dx;
        this.ksz = dy;
        this.dsz = dz;
        this.reset();
    }

    public BallJointController(PhysicalJoint j, float ax, float ay, float az) {
        this(j, ax, ay, az, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f);
    }

    public BallJointController() {
        this(null, 0.0f, 0.0f, 0.0f);
    }

    public void setSprings(float kx, float ky, float kz) {
        this.ksx = kx;
        this.ksy = ky;
        this.ksz = kz;
    }

    @Override
    public void reset() {
        this.aprevx = 0.0f;
        this.aprevy = 0.0f;
        this.aprevz = 0.0f;
        this.firstRun = true;
    }

    @Override
    public void update(double timeDiff) {
        float ax = this.joint.getAngle(0);
        float ay = this.joint.getAngle(1);
        float az = this.joint.getAngle(2);
        float dax = 0.0f;
        float day = 0.0f;
        float daz = 0.0f;
        if (this.firstRun) {
            this.firstRun = false;
            System.out.println("First run of ball controller");
            this.aprevx = ax;
            this.aprevy = ay;
            this.aprevz = az;
            return;
        }
        dax = (ax - this.aprevx) / (float)timeDiff;
        day = (ay - this.aprevy) / (float)timeDiff;
        daz = (az - this.aprevz) / (float)timeDiff;
        this.joint.addTorque((this.anglex - ax) * this.ksx + (this.avelx - dax) * this.dsx, (this.angley - ay) * this.ksy + (this.avely - day) * this.dsy, (this.anglez - az) * this.ksz + (this.avelz - daz) * this.dsz);
        this.aprevx = ax;
        this.aprevy = ay;
        this.aprevz = az;
    }

    @Override
    public String[] getRequiredJointIDs() {
        this.jointIDs[0] = this.jointId;
        return this.jointIDs;
    }

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid ph) {
        this.joint = ph.getJoint(this.jointId);
        this.pHuman = ph;
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        BallJointController bjc = new BallJointController(this.joint, this.anglex, this.angley, this.anglez, this.avelx, this.avely, this.avelz, this.ksx, this.ksy, this.ksz, this.dsx, this.dsy, this.dsz);
        bjc.setPhysicalHumanoid(ph);
        bjc.setParameterValue("joint", this.jointId);
        return bjc;
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("joint")) {
            return this.jointId;
        }
        return null;
    }

    @Override
    public void setParameterValue(String name, String value) {
        if (name.equals("joint")) {
            this.jointId = value;
            if (this.pHuman != null) {
                this.joint = this.pHuman.getJoint(this.jointId);
            }
        } else if (name.equals("anglex")) {
            this.anglex = -Float.parseFloat(value);
        } else if (name.equals("angley")) {
            this.angley = -Float.parseFloat(value);
        } else if (name.equals("anglez")) {
            this.anglez = -Float.parseFloat(value);
        } else if (name.equals("ksx")) {
            this.ksx = Float.parseFloat(value);
        } else if (name.equals("ksy")) {
            this.ksy = Float.parseFloat(value);
        } else if (name.equals("ksz")) {
            this.ksz = Float.parseFloat(value);
        } else if (name.equals("dsx")) {
            this.dsx = Float.parseFloat(value);
        } else if (name.equals("dsy")) {
            this.dsy = Float.parseFloat(value);
        } else if (name.equals("dsz")) {
            this.dsz = Float.parseFloat(value);
        }
    }

    @Override
    public void setParameterValue(String name, float value) {
        if (name.equals("anglex")) {
            this.anglex = -value;
        } else if (name.equals("angley")) {
            this.angley = -value;
        } else if (name.equals("anglez")) {
            this.anglez = -value;
        } else if (name.equals("ksx")) {
            this.ksx = value;
        } else if (name.equals("ksy")) {
            this.ksy = value;
        } else if (name.equals("ksz")) {
            this.ksz = value;
        } else if (name.equals("dsx")) {
            this.dsx = value;
        } else if (name.equals("dsy")) {
            this.dsx = value;
        } else if (name.equals("dsz")) {
            this.dsz = value;
        }
    }

    @Override
    public String[] getDesiredJointIDs() {
        return this.desJointIDs;
    }
}

