/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.assembler;

import hmi.animation.VJoint;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GShape;
import hmi.math.Mat3f;
import hmi.math.Vec3f;
import hmi.physics.Mass;
import hmi.physics.assembler.BodyDensities;
import hmi.physics.inversedynamics.IDSegment;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IDSegmentAssembler
extends XMLStructureAdapter {
    public VJoint startJoint;
    private VJoint human;
    public IDSegment segment;
    public ArrayList<VJoint> endJoints = new ArrayList();
    private boolean isRoot = false;
    public float[] pos = new float[3];

    public IDSegmentAssembler(VJoint h, IDSegment seg) {
        this.human = h;
        this.segment = seg;
    }

    private GNode findStartNode(GNode rootNode) {
        GNode n = null;
        if (this.startJoint.getSid().equals(rootNode.getSid())) {
            return rootNode;
        }
        for (GNode gn : rootNode.getGNodes()) {
            n = this.findStartNode(gn);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    public void createFromGNode(GNode rootNode, String name) {
        this.startJoint = this.human.getPart(name);
        this.segment.name = name;
        for (VJoint vj : this.startJoint.getChildren()) {
            this.endJoints.add(vj);
        }
        GNode node = this.findStartNode(rootNode);
        float totalMass = 0.0f;
        Mass totalM = null;
        float[] cTotal = new float[3];
        float[] c2 = new float[3];
        float[] c = new float[3];
        float[] I = new float[9];
        float[] jTrans = new float[3];
        float density = ((Float)BodyDensities.bodyDensityMap.get(name)).floatValue();
        List shapes = node.getGShapes();
        for (GShape s : shapes) {
            Mass m = this.segment.createMass();
            if (s.gmesh.getVCountData() != null) {
                s.gmesh.triangulate();
            }
            m.setFromGMesh(s.gmesh, density);
            m.getCOM(c);
            m.translate(-c[0], -c[1], -c[2]);
            Vec3f.add((float[])c, (float[])jTrans);
            if (totalM == null) {
                totalM = m;
                Vec3f.set((float[])cTotal, (float[])c);
            } else {
                totalM.addMass(m, cTotal, c, c2);
                Vec3f.set((float[])cTotal, (float[])c2);
            }
            totalMass += m.getMass();
        }
        this.segment.mass = totalMass;
        totalM.getInertiaTensor(I);
        Mat3f.set((float[])this.segment.I, (float[])I);
        this.startJoint.getPathTranslation(null, this.pos);
        Vec3f.add((float[])this.pos, (float[])cTotal);
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        if (attrName.equals("startJoint")) {
            this.startJoint = this.human.getPart(attrValue);
            if (this.startJoint == null) {
                throw new RuntimeException("Startjoint not found in human: " + attrValue);
            }
            String n = this.startJoint.getSid();
            if (n == null) {
                n = this.startJoint.getName();
            }
            this.segment.name = new String(n);
            return true;
        }
        if (attrName.equals("endJoint")) {
            String[] joint = attrValue.split(",");
            for (int i = 0; i < joint.length; ++i) {
                VJoint endJoint = this.human.getPart(joint[i]);
                if (endJoint == null) {
                    System.out.println("Null endjoint: " + joint[i]);
                    continue;
                }
                this.endJoints.add(endJoint);
            }
            return true;
        }
        if (attrName.equals("mass")) {
            this.segment.mass = Float.parseFloat(attrValue);
            return true;
        }
        if (attrName.equals("position")) {
            String[] vals = attrValue.split(",");
            this.pos[0] = Float.parseFloat(vals[0]);
            this.pos[1] = Float.parseFloat(vals[1]);
            this.pos[2] = Float.parseFloat(vals[2]);
        } else if (attrName.equals("I")) {
            String[] vals = attrValue.split(",");
            for (int i = 0; i < 9; ++i) {
                this.segment.I[i] = Float.parseFloat(vals[i]);
            }
        }
        return false;
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
    }

    public StringBuilder appendContent(StringBuilder buf, int tab) {
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        IDSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"startJoint", (String)this.startJoint.getSid());
        StringBuffer str = new StringBuffer("");
        for (VJoint j : this.endJoints) {
            str.append("," + j.getName());
        }
        if (!str.toString().equals("")) {
            IDSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"endJoint", (String)str.substring(1));
        }
        IDSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"mass", (float)this.segment.mass);
        IDSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"position", (String)(this.pos[0] + "," + this.pos[1] + "," + this.pos[2]));
        float[] I = new float[9];
        str = new StringBuffer("" + I[0]);
        for (int i = 1; i < 9; ++i) {
            str.append("," + this.segment.I[i]);
        }
        IDSegmentAssembler.appendAttribute((StringBuilder)buf, (String)"I", (String)str.toString());
        return buf;
    }

    public String getXMLTag() {
        if (this.isRoot) {
            return "IDRootSegment";
        }
        return "IDSegment";
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }
}

