/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.assembler;

import hmi.animation.VJoint;
import hmi.math.Vec3f;
import hmi.physics.assembler.IDSegmentAssembler;
import hmi.physics.inversedynamics.IDBranch;
import hmi.physics.inversedynamics.IDSegment;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class IDBranchAssembler
extends XMLStructureAdapter {
    private VJoint human;
    public IDBranch branch;
    public IDSegmentAssembler rootAssembler;
    public ArrayList<IDSegmentAssembler> segmentAssemblers = new ArrayList();

    public IDBranchAssembler(VJoint h, IDBranch b) {
        this.human = h;
        this.branch = b;
    }

    public void addPhysicalSegmentAssembler(IDSegmentAssembler psa) {
        this.segmentAssemblers.add(psa);
    }

    public void setRootSegmentAssembler(IDSegmentAssembler psa) {
        this.rootAssembler = psa;
        this.branch.setRoot(this.rootAssembler.segment);
    }

    private void setCoM(IDSegmentAssembler psa) {
        float[] jPos = new float[3];
        psa.startJoint.getPathTranslation(null, jPos);
        Vec3f.sub((float[])psa.segment.com, (float[])psa.pos, (float[])jPos);
    }

    private void setupSegments(IDSegmentAssembler psa, float[] jPos) {
        for (VJoint vo : psa.endJoints) {
            for (IDSegmentAssembler sa : this.segmentAssemblers) {
                if (vo != sa.startJoint) continue;
                this.setCoM(sa);
                float[] jNewPos = new float[3];
                sa.startJoint.getPathTranslation(null, jNewPos);
                Vec3f.sub((float[])sa.segment.translation, (float[])jNewPos, (float[])jPos);
                psa.segment.addChild(sa.segment);
                this.setupSegments(sa, jNewPos);
            }
        }
    }

    public void setup() {
        Vec3f.set((float[])this.rootAssembler.segment.translation, (float)0.0f, (float)0.0f, (float)0.0f);
        this.setCoM(this.rootAssembler);
        float[] jPos = new float[3];
        this.rootAssembler.startJoint.getPathTranslation(null, jPos);
        this.branch.setRoot(this.rootAssembler.segment);
        this.setupSegments(this.rootAssembler, jPos);
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        return false;
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            IDSegmentAssembler psa;
            IDSegment ps;
            if (tokenizer.atSTag("IDSegment")) {
                ps = new IDSegment();
                psa = new IDSegmentAssembler(this.human, ps);
                psa.readXML(tokenizer);
                this.addPhysicalSegmentAssembler(psa);
                continue;
            }
            if (!tokenizer.atSTag("IDRootSegment")) continue;
            ps = new IDSegment();
            psa = new IDSegmentAssembler(this.human, ps);
            psa.setRoot(true);
            psa.readXML(tokenizer);
            this.setRootSegmentAssembler(psa);
        }
    }

    public StringBuilder appendContent(StringBuilder buf, int tab) {
        IDBranchAssembler.appendNewLine((StringBuilder)buf);
        if (this.rootAssembler != null) {
            this.rootAssembler.appendXML(buf, tab);
        }
        for (IDSegmentAssembler ps : this.segmentAssemblers) {
            IDBranchAssembler.appendNewLine((StringBuilder)buf);
            ps.appendXML(buf, tab);
        }
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        return buf;
    }

    public String getXMLTag() {
        return "IDBranch";
    }
}

