/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.assembler;

import hmi.graphics.collada.Box;
import hmi.graphics.collada.Capsule;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Rotate;
import hmi.graphics.collada.Shape;
import hmi.graphics.collada.Sphere;
import hmi.graphics.collada.Translate;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.CollisionBox;
import hmi.physics.CollisionCapsule;
import hmi.physics.CollisionShape;
import hmi.physics.CollisionSphere;
import hmi.physics.RigidBody;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class CollisionModel
extends ColladaElement {
    RigidBody body;

    public CollisionModel(RigidBody b) {
        this.body = b;
    }

    protected void addShape(Shape s) {
        float[] q = new float[4];
        float[] tr = new float[3];
        Quat4f.setIdentity((float[])q);
        Vec3f.set((float[])tr, (float)0.0f, (float)0.0f, (float)0.0f);
        if (s.rotate != null) {
            Quat4f.setFromAxisAngle4f((float[])q, (float[])s.rotate.getAxisAngleRadians());
        }
        if (s.translate != null) {
            Vec3f.set((float[])tr, (float[])s.translate.getTranslation());
        }
        if (s.box != null) {
            this.body.addBox(q, tr, s.box.halfExtends.xyz);
        } else if (s.sphere != null) {
            this.body.addSphere(tr, s.sphere.radius.radius);
        } else if (s.capsule != null) {
            this.body.addCapsule(q, tr, s.capsule.radius.radius, s.capsule.height.height);
        }
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Shape.XMLTag)) {
                this.addShape(new Shape(this.collada, tokenizer));
                continue;
            }
            this.collada.warning("CollisionModel: skip : " + tokenizer.getTagName());
            tokenizer.skipTag();
        }
    }

    public StringBuilder appendContent(StringBuilder buf, int tab) {
        for (CollisionShape s : this.body.getCollisionShapes()) {
            Shape colladaShape = new Shape();
            float[] q = new float[4];
            s.getRotation(q);
            if (!Quat4f.isIdentity((float[])q)) {
                Rotate r = new Rotate();
                float[] aa = new float[4];
                Quat4f.setAxisAngle4fFromQuat4f((float[])aa, (float[])q);
                r.setAxisAngleRadians(aa);
                colladaShape.rotate = r;
            }
            float[] ta = new float[3];
            s.getTranslation(ta);
            if (!Vec3f.equals((float[])ta, (float)0.0f, (float)0.0f, (float)0.0f)) {
                Translate t = new Translate();
                t.setTranslation(ta);
                colladaShape.translate = t;
            }
            if (s instanceof CollisionBox) {
                CollisionBox cb = (CollisionBox)s;
                colladaShape.box = new Box();
                Vec3f.set((float[])colladaShape.box.halfExtends.xyz, (float[])cb.halfExtends);
            } else if (s instanceof CollisionSphere) {
                CollisionSphere cs = (CollisionSphere)s;
                colladaShape.sphere = new Sphere();
                colladaShape.sphere.radius.radius = cs.radius;
            } else if (s instanceof CollisionCapsule) {
                CollisionCapsule cc = (CollisionCapsule)s;
                colladaShape.capsule = new Capsule();
                colladaShape.capsule.height.height = cc.height;
                colladaShape.capsule.radius.radius = cc.radius;
            }
            CollisionModel.appendNewLine((StringBuilder)buf);
            colladaShape.appendXML(buf, tab);
        }
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        return buf;
    }

    public String getXMLTag() {
        return "CollisionModel";
    }
}

