/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics;

import hmi.graphics.render.GenericMesh;
import hmi.graphics.scenegraph.GMesh;
import hmi.math.Mat3f;
import hmi.math.Vec3f;

public abstract class Mass {
    public abstract void getCOM(float[] var1);

    public abstract void getInertiaTensor(float[] var1);

    public abstract void setCOM(float[] var1);

    public abstract void setInertiaTensor(float[] var1);

    public abstract float getMass();

    public abstract void adjustMass(float var1);

    public abstract void translate(float var1, float var2, float var3);

    public void translate(float[] pos) {
        this.translate(pos[0], pos[1], pos[2]);
    }

    public abstract void rotate(float[] var1);

    public abstract void setFromBox(float[] var1, float var2);

    public abstract void setFromSphere(float var1, float var2);

    public abstract void setFromCapsule(float var1, float var2, int var3, float var4);

    public abstract void setFromGenericMesh(GenericMesh var1, float var2);

    public abstract void setFromGMesh(GMesh var1, float var2);

    public abstract String toString();

    public abstract Mass clone();

    public void scale(float[] s) {
        float[] I = new float[9];
        this.getInertiaTensor(I);
        float Ixx = I[0];
        float Iyy = I[4];
        float Izz = I[8];
        float a = 0.5f * Iyy + 0.5f * Izz - 0.5f * Ixx;
        float b = 0.5f * Ixx + 0.5f * Izz - 0.5f * Iyy;
        float c = -0.5f * Izz + 0.5f * Iyy + 0.5f * Ixx;
        I[0] = s[1] * s[1] * b + s[2] * s[2] * c;
        I[4] = s[0] * s[0] * a + s[2] * s[2] * c;
        I[8] = s[0] * s[0] * a + s[1] * s[1] * b;
        I[1] = I[3] = I[1] * s[0] * s[1];
        I[2] = I[6] = I[2] * s[0] * s[2];
        I[5] = I[7] = I[5] * s[1] * s[2];
        this.setInertiaTensor(I);
        this.adjustMass(s[0] * s[1] * s[2] * this.getMass());
    }

    public void scale(float s) {
        float[] I = new float[9];
        this.getInertiaTensor(I);
        Mat3f.scale((float[])I, (float)(s * s));
        this.setInertiaTensor(I);
        this.adjustMass(s * s * s * this.getMass());
    }

    public void addMass(Mass m, float[] p1, float[] p2, float[] newPos) {
        float totalMass = m.getMass() + this.getMass();
        float[] center2 = new float[3];
        Vec3f.set((float[])newPos, (float[])p1);
        Vec3f.scale((float)this.getMass(), (float[])newPos);
        Vec3f.set((float[])center2, (float[])p2);
        Vec3f.scale((float)m.getMass(), (float[])center2);
        Vec3f.add((float[])newPos, (float[])center2);
        Vec3f.scale((float)(1.0f / totalMass), (float[])newPos);
        float[] newI = new float[9];
        float[] I2 = new float[9];
        float[] trans = new float[3];
        Vec3f.sub((float[])trans, (float[])p1, (float[])newPos);
        this.translate(trans);
        Mass m1 = m.clone();
        Vec3f.sub((float[])trans, (float[])p2, (float[])newPos);
        m1.translate(trans);
        this.getInertiaTensor(newI);
        m1.getInertiaTensor(I2);
        Mat3f.add((float[])newI, (float[])I2);
        this.setCOM(Vec3f.getZero());
        this.adjustMass(totalMass);
        this.setInertiaTensor(newI);
    }
}

