/*
 * Decompiled with CFR 0.152.
 */
package hmi.phyiscs.featherstone;

import hmi.math.Quat4f;
import hmi.math.SpatialInertiaTensor;
import hmi.math.SpatialTransform;
import hmi.math.SpatialVec;
import hmi.math.Vec3f;

public class RNEASolver {
    private float[] vi;
    private float[] ai;
    private float[] X;
    private float[] r;
    private float[] iX0 = new float[13];
    private int size = 0;
    private float[] tempv = new float[6];
    private float[] tempv2 = new float[6];
    private float[] cwi = new float[6];
    private float[] I;
    private float[] F;
    private float[] tempq = new float[4];
    private int[] lambda = null;

    public RNEASolver(int joints, float[] translations, float[] spatialI, int[] parent) {
        this.vi = new float[(joints + 1) * 6];
        this.ai = new float[(joints + 1) * 6];
        this.F = new float[joints * 6];
        this.X = new float[joints * 12];
        this.I = spatialI;
        this.size = joints + 1;
        this.r = translations;
        this.lambda = parent;
    }

    public RNEASolver(int joints, float[] translations, float[] spatialI) {
        this.vi = new float[(joints + 1) * 6];
        this.ai = new float[(joints + 1) * 6];
        this.F = new float[joints * 6];
        this.X = new float[joints * 12];
        this.I = spatialI;
        this.size = joints + 1;
        this.r = translations;
    }

    public void solve(float[] f, float[] v0, float[] a0, float[] qi, float[] wi, float[] diffwi) {
        int i;
        SpatialVec.set((float[])this.vi, (float[])v0);
        SpatialVec.set((float[])this.ai, (float[])a0);
        for (i = 0; i < this.size - 1; ++i) {
            Quat4f.conjugate((float[])this.tempq, (int)0, (float[])qi, (int)(i * 4));
            SpatialTransform.setFromQuat4fVec3f((float[])this.X, (int)(i * 12), (float[])this.tempq, (int)0, (float[])this.r, (int)(i * 3));
        }
        this.cwi[3] = 0.0f;
        this.cwi[4] = 0.0f;
        this.cwi[5] = 0.0f;
        for (i = 1; i < this.size; ++i) {
            SpatialTransform.transformMotion((float[])this.vi, (int)(i * 6), (float[])this.X, (int)((i - 1) * 12), (float[])this.vi, (int)((this.lambda[i - 1] + 1) * 6));
            int n = i * 6;
            this.vi[n] = this.vi[n] + wi[(i - 1) * 3];
            int n2 = i * 6 + 1;
            this.vi[n2] = this.vi[n2] + wi[(i - 1) * 3 + 1];
            int n3 = i * 6 + 2;
            this.vi[n3] = this.vi[n3] + wi[(i - 1) * 3 + 2];
        }
        for (i = 1; i < this.size; ++i) {
            SpatialTransform.transformMotion((float[])this.ai, (int)(i * 6), (float[])this.X, (int)((i - 1) * 12), (float[])this.ai, (int)((this.lambda[i - 1] + 1) * 6));
            Vec3f.set((float[])this.cwi, (int)0, (float[])wi, (int)((i - 1) * 3));
            SpatialVec.cross((float[])this.tempv, (int)0, (float[])this.vi, (int)(i * 6), (float[])this.cwi, (int)0);
            SpatialVec.add((float[])this.ai, (int)(i * 6), (float[])this.tempv, (int)0);
            int n = i * 6;
            this.ai[n] = this.ai[n] + diffwi[(i - 1) * 3];
            int n4 = i * 6 + 1;
            this.ai[n4] = this.ai[n4] + diffwi[(i - 1) * 3 + 1];
            int n5 = i * 6 + 2;
            this.ai[n5] = this.ai[n5] + diffwi[(i - 1) * 3 + 2];
        }
        SpatialTransform.set((float[])this.iX0, (float[])this.X);
        for (i = 1; i < this.size; ++i) {
            SpatialInertiaTensor.transformSpatialVec((float[])f, (int)((i - 1) * 6), (float[])this.I, (int)((i - 1) * 13), (float[])this.ai, (int)(i * 6));
            SpatialInertiaTensor.transformSpatialVec((float[])this.tempv, (int)0, (float[])this.I, (int)((i - 1) * 13), (float[])this.vi, (int)(i * 6));
            SpatialVec.crossForce((float[])this.tempv2, (int)0, (float[])this.vi, (int)(i * 6), (float[])this.tempv, (int)0);
            SpatialVec.add((float[])f, (int)((i - 1) * 6), (float[])this.tempv2, (int)0);
        }
        for (i = this.size - 1; i > 1; --i) {
            SpatialTransform.transformForceTranspose((float[])this.tempv, (int)0, (float[])this.X, (int)((i - 1) * 12), (float[])f, (int)((i - 1) * 6));
            SpatialVec.add((float[])f, (int)(this.lambda[i - 1] * 6), (float[])this.tempv, (int)0);
        }
    }

    public void solveChain(float[] f, float[] v0, float[] a0, float[] qi, float[] wi, float[] diffwi) {
        int i;
        SpatialVec.set((float[])this.vi, (float[])v0);
        SpatialVec.set((float[])this.ai, (float[])a0);
        for (i = 0; i < this.size - 1; ++i) {
            Quat4f.conjugate((float[])this.tempq, (int)0, (float[])qi, (int)(i * 4));
            SpatialTransform.setFromQuat4fVec3f((float[])this.X, (int)(i * 12), (float[])this.tempq, (int)0, (float[])this.r, (int)(i * 3));
        }
        this.cwi[3] = 0.0f;
        this.cwi[4] = 0.0f;
        this.cwi[5] = 0.0f;
        for (i = 1; i < this.size; ++i) {
            SpatialTransform.transformMotion((float[])this.vi, (int)(i * 6), (float[])this.X, (int)((i - 1) * 12), (float[])this.vi, (int)((i - 1) * 6));
            int n = i * 6;
            this.vi[n] = this.vi[n] + wi[(i - 1) * 3];
            int n2 = i * 6 + 1;
            this.vi[n2] = this.vi[n2] + wi[(i - 1) * 3 + 1];
            int n3 = i * 6 + 2;
            this.vi[n3] = this.vi[n3] + wi[(i - 1) * 3 + 2];
        }
        for (i = 1; i < this.size; ++i) {
            SpatialTransform.transformMotion((float[])this.ai, (int)(i * 6), (float[])this.X, (int)((i - 1) * 12), (float[])this.ai, (int)((i - 1) * 6));
            Vec3f.set((float[])this.cwi, (int)0, (float[])wi, (int)((i - 1) * 3));
            SpatialVec.cross((float[])this.tempv, (int)0, (float[])this.vi, (int)(i * 6), (float[])this.cwi, (int)0);
            SpatialVec.add((float[])this.ai, (int)(i * 6), (float[])this.tempv, (int)0);
            int n = i * 6;
            this.ai[n] = this.ai[n] + diffwi[(i - 1) * 3];
            int n4 = i * 6 + 1;
            this.ai[n4] = this.ai[n4] + diffwi[(i - 1) * 3 + 1];
            int n5 = i * 6 + 2;
            this.ai[n5] = this.ai[n5] + diffwi[(i - 1) * 3 + 2];
        }
        SpatialTransform.set((float[])this.iX0, (float[])this.X);
        for (i = 1; i < this.size; ++i) {
            SpatialInertiaTensor.transformSpatialVec((float[])this.F, (int)((i - 1) * 6), (float[])this.I, (int)((i - 1) * 13), (float[])this.ai, (int)(i * 6));
            SpatialInertiaTensor.transformSpatialVec((float[])this.tempv, (int)0, (float[])this.I, (int)((i - 1) * 13), (float[])this.vi, (int)(i * 6));
            SpatialVec.crossForce((float[])this.tempv2, (int)0, (float[])this.vi, (int)(i * 6), (float[])this.tempv, (int)0);
            SpatialVec.add((float[])this.F, (int)((i - 1) * 6), (float[])this.tempv2, (int)0);
        }
        SpatialVec.set((float[])f, (int)((this.size - 2) * 6), (float[])this.F, (int)((this.size - 2) * 6));
        for (i = this.size - 3; i >= 0; --i) {
            SpatialTransform.transformForceTranspose((float[])f, (int)(i * 6), (float[])this.X, (int)((i + 1) * 12), (float[])f, (int)((i + 1) * 6));
            SpatialVec.add((float[])f, (int)(i * 6), (float[])this.F, (int)(i * 6));
        }
    }
}

