/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics;

import hmi.animation.VObject;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.JointType;
import hmi.physics.Mass;
import hmi.physics.PhysicalJoint;
import hmi.physics.RigidBody;

public abstract class PhysicalSegment
implements VObject {
    public RigidBody box;
    public PhysicalJoint startJoint;
    public float[] axis1 = new float[]{1.0f, 0.0f, 0.0f};
    public float[] axis2 = new float[]{0.0f, 1.0f, 0.0f};
    public boolean onGround = false;
    public JointType jointType = JointType.HINGE;
    public float[] hiStop = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
    public float[] loStop = new float[]{-3.4028235E38f, -3.4028235E38f, -3.4028235E38f};
    public float[] startJointOffset = new float[3];
    protected String sid = "";
    protected String id = "";
    protected String name = "";

    public void set(PhysicalSegment s) {
        this.id = s.id;
        this.sid = s.sid;
        this.name = s.name;
        this.jointType = s.jointType;
        Vec3f.set((float[])this.axis1, (float[])s.axis1);
        Vec3f.set((float[])this.axis2, (float[])s.axis2);
        Vec3f.set((float[])this.hiStop, (float[])s.hiStop);
        Vec3f.set((float[])this.loStop, (float[])s.loStop);
        float[] pos = Vec3f.getVec3f();
        s.box.getTranslation(pos);
        this.box.setTranslation(pos);
        float[] q = Quat4f.getQuat4f();
        s.box.getRotation(q);
        this.box.setRotation(q);
        this.box.adjustMass(s.box.getMass());
        float[] I = new float[9];
        s.box.getInertiaTensor(I);
        this.box.setInertiaTensor(I);
        Vec3f.set((float[])this.startJointOffset, (float[])s.startJointOffset);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void clear() {
        this.box.clear();
    }

    public String toString() {
        return this.id + "(" + this.box + " kg)";
    }

    public void setId(String n) {
        this.id = n;
    }

    public void getAngularVelocity(float[] v) {
        this.box.getAngularVelocity(v);
    }

    public void getAngularVelocity(float[] vc, int vcIndex) {
        this.box.getAngularVelocity(vc, vcIndex);
    }

    public String getId() {
        return this.id;
    }

    public void getRotation(float[] r) {
        this.box.getRotation(r);
    }

    public void getRotation(float[] r, int index) {
        this.box.getRotation(r, index);
    }

    public String getSid() {
        return this.sid;
    }

    public void getTranslation(float[] t) {
        this.box.getTranslation(t);
    }

    public void getTranslation(float[] vc, int vcIndex) {
        this.box.getTranslation(vc, vcIndex);
    }

    public void getVelocity(float[] v) {
        this.box.getVelocity(v);
    }

    public void getVelocity(float[] vc, int vcIndex) {
        this.box.getVelocity(vc, vcIndex);
    }

    public void setAngularVelocity(float[] v) {
        this.box.setAngularVelocity(v);
    }

    public void setAngularVelocity(float[] vc, int vcIndex) {
        this.box.setAngularVelocity(vc, vcIndex);
    }

    public void setAngularVelocity(float wx, float wy, float wz) {
        this.box.setAngularVelocity(wx, wy, wz);
    }

    public void setAxisAngle(float ax, float ay, float az, float angle) {
        this.box.setAxisAngle(ax, ay, az, angle);
    }

    public void setRotation(float[] ra) {
        this.box.setRotation(ra);
    }

    public void setRotation(float[] ra, int raIndex) {
        this.box.setRotation(ra, raIndex);
    }

    public void setRotation(float qs, float qx, float qy, float qz) {
        this.box.setRotation(qs, qx, qy, qz);
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public void setTranslation(float[] ta) {
        this.box.setTranslation(ta);
    }

    public void setTranslation(float[] ta, int taIndex) {
        this.box.setTranslation(ta, taIndex);
    }

    public void setTranslation(float tx, float ty, float tz) {
        this.box.setTranslation(tx, ty, tz);
    }

    public void setVelocity(float[] v) {
        this.box.setVelocity(v);
    }

    public void setVelocity(float[] vc, int vcIndex) {
        this.box.setVelocity(vc, vcIndex);
    }

    public void setVelocity(float vx, float vy, float vz) {
        this.box.setVelocity(vx, vy, vz);
    }

    public void setEnabled(boolean enabled) {
        this.box.setEnabled(enabled);
    }

    public float[] getRotationBuffer() {
        throw new UnsupportedOperationException();
    }

    public void getScale(float[] r) {
        throw new UnsupportedOperationException();
    }

    public void setScale(float[] sa) {
        throw new UnsupportedOperationException();
    }

    public void setScale(float[] sa, int saIndex) {
        throw new UnsupportedOperationException();
    }

    public void getScale(float[] r, int index) {
        throw new UnsupportedOperationException();
    }

    public float[] getScaleBuffer() {
        throw new UnsupportedOperationException();
    }

    public float[] getTranslationBuffer() {
        throw new UnsupportedOperationException();
    }

    public abstract Mass createMass();
}

