/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.mixed;

import hmi.animation.SkeletonPose;
import hmi.animation.VJoint;
import hmi.animation.VObject;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.PhysicsSync;
import hmi.physics.inversedynamics.IDBranch;
import hmi.physics.inversedynamics.IDSegment;
import hmi.physics.mixed.Branch;
import hmi.physics.mixed.Connector;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedSystem {
    private static final Logger logger = LoggerFactory.getLogger((String)MixedSystem.class.getName());
    private ArrayList<Branch> branches = new ArrayList();
    private float[] spatialV0 = new float[6];
    private float[] spatialA0 = new float[6];
    private float[] f;
    private float[] gravity = new float[6];
    private float mass;
    private float[] com = new float[3];
    private float[] tempM1 = new float[16];
    private float[] tempM2 = new float[16];
    private float[] qTemp = new float[4];
    private float[] vTemp = new float[4];
    private float[] vTemp2 = new float[4];
    private float[] connectorTransform = new float[16];
    private PhysicalHumanoid pHuman;
    private SkeletonPose startPose;
    private float[] aVel = new float[3];
    private float[] aVelPrev = new float[3];
    private float[] velPrev = new float[3];

    public MixedSystem(float[] g, PhysicalHumanoid p) {
        Vec3f.set((float[])this.gravity, (int)3, (float[])g, (int)0);
        this.pHuman = p;
    }

    public void setup() {
        PhysicalSegment[] phSegs = this.pHuman.getSegments();
        String[] configs = new String[phSegs.length];
        for (int i = 0; i < phSegs.length; ++i) {
            configs[i] = phSegs[i].getSid();
        }
        this.startPose = new SkeletonPose(configs, "TRVW");
        this.startPose.setTargets((VObject[])this.pHuman.getSegments());
        this.startPose.setFromTarget();
    }

    public void setResetPose(VJoint v) {
        this.pHuman.setPoseFromVJoint(v);
        this.startPose.setFromTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIDFromPHuman(PhysicalHumanoid p) {
        for (Branch b : this.branches) {
            boolean changed = false;
            for (IDSegment ids : b.idBranch.getSegments()) {
                PhysicalSegment ps = p.getSegment(ids.name);
                if (ps == null) continue;
                changed = true;
                Object object = PhysicsSync.getSync();
                synchronized (object) {
                    ps.getRotation(this.qTemp);
                    ps.getTranslation(this.vTemp);
                }
            }
            if (!changed) continue;
            b.connector.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPHumanFromID(ArrayList<Branch> bs, float[] q, float[] w) {
        int iq = 0;
        int iw = 0;
        for (Branch b : bs) {
            Object object = PhysicsSync.getSync();
            synchronized (object) {
                b.connector.getWorldTransform(this.connectorTransform);
            }
            b.connector.getAvelocity(this.aVelPrev);
            b.connector.getVelocity(this.velPrev);
            Mat4f.set((float[])this.tempM1, (float[])this.connectorTransform);
            for (IDSegment seg : b.idBranch.getSegments()) {
                Mat4f.setIdentity((float[])this.tempM2);
                Mat4f.setRotation((float[])this.tempM2, (int)0, (float[])q, (int)iq);
                Mat4f.setTranslation((float[])this.tempM2, (float[])seg.translation);
                Mat4f.mul((float[])this.tempM1, (float[])this.tempM2);
                Quat4f.setFromMat4f((float[])this.qTemp, (float[])this.tempM1);
                Mat4f.transformPoint((float[])this.tempM1, (float[])this.vTemp, (float[])seg.com);
                Quat4f.transformVec3f((float[])q, (int)iq, (float[])w, (int)iw, (float[])this.aVel, (int)0);
                Vec3f.add((float[])this.aVel, (float[])this.aVelPrev);
                PhysicalSegment ps = this.pHuman.getSegment(seg.name);
                if (ps != null) {
                    ps.setTranslation(this.vTemp);
                    logger.debug("Setting pos {} {} ", (Object)seg.name, (Object)Vec3f.toString((float[])this.vTemp));
                    logger.debug("Setting rot {} {} local rot {}", new Object[]{seg.name, Quat4f.toString((float[])this.qTemp), Quat4f.toString((float[])q, (int)iq)});
                    ps.setRotation(this.qTemp);
                    ps.setAngularVelocity(this.aVel);
                    Vec3f.scale((float)-1.0f, (float[])this.vTemp2, (float[])ps.startJointOffset);
                    Vec3f.cross((float[])this.vTemp, (int)0, (float[])w, (int)iw, (float[])this.vTemp2, (int)0);
                    Vec3f.add((float[])this.vTemp, (float[])this.velPrev);
                    ps.setVelocity(this.vTemp);
                }
                Vec3f.set((float[])this.aVelPrev, (float[])this.aVel);
                Vec3f.cross((float[])this.vTemp, (int)0, (float[])w, (int)iw, (float[])seg.translation, (int)0);
                Vec3f.add((float[])this.velPrev, (float[])this.vTemp);
                iw += 3;
                iq += 4;
            }
        }
    }

    private void setIDFromID(ArrayList<Branch> srcBranches) {
        for (Branch b : this.branches) {
            for (Branch bSrc : srcBranches) {
                if (!bSrc.idBranch.getRoot().name.equals(b.idBranch.getRoot().name)) continue;
                b.connector.setVel(bSrc.connector);
            }
        }
    }

    public void set(MixedSystem s, float[] q, float[] w) {
        this.pHuman.set(s.pHuman);
        if (s.pHuman.getRootSegment() == null && s.pHuman.getSegments().length == 0) {
            this.pHuman.updateCOM(0.0f);
        }
        this.setIDFromID(s.branches);
        this.setIDFromPHuman(s.pHuman);
        this.setPHumanFromID(s.branches, q, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(VJoint vj) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            logger.debug("Mixed system reset");
            this.startPose.setToTarget();
            for (PhysicalSegment ps : this.pHuman.getSegments()) {
                ps.box.setForce(0.0f, 0.0f, 0.0f);
                ps.box.setTorque(0.0f, 0.0f, 0.0f);
            }
            this.setMassOffset(vj);
            this.pHuman.updateCOM(0.0f);
            for (Branch b : this.branches) {
                b.connector.reset();
            }
        }
    }

    public void addBranch(IDBranch idb, Connector con) {
        Branch b = new Branch();
        b.connector = con;
        b.idBranch = idb;
        this.branches.add(b);
    }

    public void setFeedbackRatio(float k) {
        for (Branch b : this.branches) {
            b.connector.setFeedbackRatio(k);
        }
    }

    public int getRots(VJoint vj, IDSegment seg, int i, float[] q) {
        for (IDSegment s : seg.getChildren()) {
            vj.getPart(s.name).getRotation(q, i);
            i = this.getRots(vj, s, i + 4, q);
        }
        return i;
    }

    public void setMassOffset(VJoint vj) {
        int i = 0;
        float[] q = new float[vj.getParts().size() * 4];
        for (Branch b : this.branches) {
            for (IDSegment seg : b.idBranch.getRoot().getChildren()) {
                vj.getPart(seg.name).getRotation(q, i);
                i = this.getRots(vj, seg, i + 4, q);
            }
        }
        this.setMassOffset(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMassOffset(float[] q) {
        this.mass = 0.0f;
        int iq = 0;
        Vec3f.set((float[])this.com, (float)0.0f, (float)0.0f, (float)0.0f);
        for (Branch b : this.branches) {
            Object object = PhysicsSync.getSync();
            synchronized (object) {
                this.mass += b.getMassOffset(q, iq, this.com);
            }
            iq += 4 * b.idBranch.getSize();
        }
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            this.pHuman.setCOMOffset(this.com, this.mass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(float timeDiff, float[] q, float[] w, float[] wDiff) {
        int iq = 0;
        int iw = 0;
        for (Branch b : this.branches) {
            Object object = PhysicsSync.getSync();
            synchronized (object) {
                b.connector.getSpatialVelocityAndAcceleration(timeDiff, this.spatialV0, this.spatialA0, this.gravity);
            }
            float[] qi = new float[b.idBranch.getSize() * 4];
            float[] wi = new float[b.idBranch.getSize() * 3];
            float[] diffwi = new float[b.idBranch.getSize() * 3];
            System.arraycopy(q, iq, qi, 0, qi.length);
            System.arraycopy(w, iw, wi, 0, wi.length);
            System.arraycopy(wDiff, iw, diffwi, 0, diffwi.length);
            this.f = new float[6 * b.idBranch.getSize()];
            b.idBranch.solver.solve(this.f, this.spatialV0, this.spatialA0, qi, wi, diffwi);
            Object object2 = PhysicsSync.getSync();
            synchronized (object2) {
                b.connector.applyReactiveTorque(qi, this.f);
            }
            iq += qi.length;
            iw += wi.length;
        }
        this.setMassOffset(q);
    }

    public ArrayList<Branch> getBranches() {
        return this.branches;
    }

    public IDSegment createIDSegment() {
        return new IDSegment();
    }

    public PhysicalHumanoid getPHuman() {
        return this.pHuman;
    }
}

