/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.controller;

import com.google.common.collect.ImmutableSet;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalJoint;
import hmi.physics.PhysicalSegment;
import hmi.physics.controller.ControllerParameterException;
import hmi.physics.controller.ControllerParameterNotFoundException;
import hmi.physics.controller.PhysicalController;
import hmi.util.StringUtil;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceController
implements PhysicalController {
    private PhysicalHumanoid ph;
    private PhysicalSegment leftFoot;
    private PhysicalSegment rightFoot;
    private PhysicalJoint leftAnkle;
    private PhysicalJoint rightAnkle;
    private PhysicalJoint rightHip;
    private PhysicalJoint leftHip;
    private PhysicalJoint rightKnee;
    private PhysicalJoint leftKnee;
    private float[] qLeftFoot = new float[4];
    private float[] qRightFoot = new float[4];
    private float[] qBody = new float[4];
    private float[] relCoM = new float[3];
    private float[] relCoMDiff = new float[3];
    private float[] left = new float[3];
    private float[] right = new float[3];
    private float[] center = new float[3];
    private float[] offset = new float[3];
    private final float[] balanceOffset = new float[]{0.0f, 0.0f, -0.01f};
    private float[] leftFw = new float[3];
    private float[] rightFw = new float[3];
    private float kpx = 280.0f;
    private float kvx = 28.0f;
    private float kpz = 280.0f;
    private float kvz = 28.0f;
    private float kpKnee = 150.0f;
    private float kvKnee = 15.0f;
    private float rotXLFoot = 0.0f;
    private float rotXRFoot = 0.0f;
    private float rotZLFoot = 0.0f;
    private float rotZRFoot = 0.0f;
    private float lKneeC = 0.0f;
    private float rKneeC = 0.0f;
    private float lHipC = 0.0f;
    private float rHipC = 0.0f;
    private float lHipCZ = 0.0f;
    private float rHipCZ = 0.0f;
    private float ul;
    private float ll;
    private float pelH = 0.855f;
    private float[] v1 = new float[3];
    private boolean groundCheck = false;
    private float s = 1.0f;
    private final Set<String> jointIDs = ImmutableSet.of((Object)"l_ankle", (Object)"r_ankle", (Object)"r_hip", (Object)"l_hip", (Object)"r_knee", (Object)"l_knee", (Object[])new String[0]);
    private final Set<String> desjointIDs = ImmutableSet.of();
    private boolean firstRun = true;
    private boolean dummyRun = true;
    private Logger logger = LoggerFactory.getLogger((String)BalanceController.class.getName());

    public BalanceController() {
        this.reset();
    }

    public BalanceController(PhysicalHumanoid p) {
        this.setPhysicalHumanoid(p);
    }

    @Override
    public void reset() {
        this.rotXLFoot = 0.0f;
        this.rotXRFoot = 0.0f;
        this.rotZLFoot = 0.0f;
        this.rotZRFoot = 0.0f;
        this.lKneeC = 0.0f;
        this.rKneeC = 0.0f;
        this.lHipC = 0.0f;
        this.rHipC = 0.0f;
        this.lHipCZ = 0.0f;
        this.rHipCZ = 0.0f;
        this.firstRun = true;
        this.dummyRun = true;
    }

    public void setKMultiplier(float km) {
        this.s = km;
    }

    public BalanceController(PhysicalHumanoid p, boolean gcheck) {
        this(p);
        this.groundCheck = gcheck;
    }

    @Override
    public void setPhysicalHumanoid(PhysicalHumanoid p) {
        this.ph = p;
        this.leftFoot = p.getSegment("l_ankle");
        this.rightFoot = p.getSegment("r_ankle");
        this.rightHip = p.getJoint("r_hip");
        this.leftHip = p.getJoint("l_hip");
        this.rightKnee = p.getJoint("r_knee");
        this.leftKnee = p.getJoint("l_knee");
        this.rightAnkle = p.getJoint("r_ankle");
        this.leftAnkle = p.getJoint("l_ankle");
        if (this.leftHip != null && this.leftKnee != null && this.leftAnkle != null) {
            float[] hip = Vec3f.getVec3f();
            float[] knee = Vec3f.getVec3f();
            float[] ankle = Vec3f.getVec3f();
            this.leftHip.getAnchor(hip);
            this.leftKnee.getAnchor(knee);
            this.leftAnkle.getAnchor(ankle);
            Vec3f.sub((float[])hip, (float[])knee);
            this.ul = Vec3f.length((float[])hip);
            Vec3f.sub((float[])knee, (float[])ankle);
            this.ll = Vec3f.length((float[])knee);
        }
    }

    @Override
    public Set<String> getRequiredJointIDs() {
        return this.jointIDs;
    }

    @Override
    public void update(double timeDiff) {
        float oldRotLFoot;
        float oldRotRFoot;
        float hipD;
        if (this.dummyRun) {
            this.dummyRun = false;
            return;
        }
        if (!(!this.groundCheck || this.leftFoot.onGround && this.rightFoot.onGround)) {
            return;
        }
        this.leftFoot.box.getRotation(this.qLeftFoot);
        this.rightFoot.box.getRotation(this.qRightFoot);
        Quat4f.interpolate((float[])this.qBody, (float[])this.qLeftFoot, (float[])this.qRightFoot, (float)0.5f);
        Quat4f.inverse((float[])this.qBody);
        Vec3f.set((float[])this.relCoM, (float[])this.ph.getCOM());
        Vec3f.set((float[])this.relCoMDiff, (float[])this.ph.getCOMDiff());
        Quat4f.transformVec3f((float[])this.qBody, (float[])this.relCoM);
        Quat4f.transformVec3f((float[])this.qBody, (float[])this.relCoMDiff);
        this.leftFoot.box.getTranslation(this.left);
        this.rightFoot.box.getTranslation(this.right);
        Vec3f.set((float[])this.center, (float[])this.left);
        Vec3f.add((float[])this.center, (float[])this.right);
        Vec3f.scale((float)0.5f, (float[])this.center);
        Vec3f.set((float[])this.v1, (float[])this.balanceOffset);
        Vec3f.add((float[])this.center, (float[])this.v1);
        Quat4f.transformVec3f((float[])this.qBody, (float[])this.center);
        float offsetX = this.s * this.kpx * (this.center[0] - this.relCoM[0]) - this.kvx * this.relCoMDiff[0];
        float offsetZ = this.s * this.kpz * (this.center[2] - this.relCoM[2]) - this.kvz * this.relCoMDiff[2];
        Vec3f.set((float[])this.offset, (float)offsetZ, (float)0.0f, (float)offsetX);
        this.leftHip.addTorque(offsetZ, 0.0f, offsetX);
        this.rightHip.addTorque(offsetZ, 0.0f, offsetX);
        if (this.pelH >= this.ul + this.ll) {
            hipD = 0.0f;
        } else {
            this.logger.debug("ul={} ll={} pelH={}", new Object[]{Float.valueOf(this.ul), Float.valueOf(this.ll), Float.valueOf(this.pelH)});
            hipD = (float)Math.acos((this.ul * this.ul - this.ll * this.ll + this.pelH * this.pelH) / (2.0f * this.ul * this.pelH));
        }
        float dHipR = 0.0f;
        float dHipL = 0.0f;
        if (!this.firstRun) {
            float rHipOld = this.rHipC;
            float lHipOld = this.lHipC;
            this.lHipC = this.leftHip.getAngle(0);
            this.rHipC = this.rightHip.getAngle(0);
            dHipR = (this.rHipC - rHipOld) / (float)timeDiff;
            dHipL = (this.lHipC - lHipOld) / (float)timeDiff;
        } else {
            this.lHipC = this.leftHip.getAngle(0);
            this.rHipC = this.rightHip.getAngle(0);
        }
        this.leftHip.addTorque((hipD - this.lHipC) * this.s * 150.0f - dHipL * this.s * 15.0f, 0.0f, 0.0f);
        this.rightHip.addTorque((hipD - this.rHipC) * this.s * 150.0f - dHipR * this.s * 15.0f, 0.0f, 0.0f);
        float dHipRZ = 0.0f;
        float dHipLZ = 0.0f;
        if (!this.firstRun) {
            float rHipOldZ = this.rHipCZ;
            float lHipOldZ = this.lHipCZ;
            this.lHipCZ = this.leftHip.getAngle(2);
            this.rHipCZ = this.rightHip.getAngle(2);
            dHipRZ = (this.rHipCZ - rHipOldZ) / (float)timeDiff;
            dHipLZ = (this.lHipCZ - lHipOldZ) / (float)timeDiff;
        } else {
            this.lHipCZ = this.leftHip.getAngle(2);
            this.rHipCZ = this.rightHip.getAngle(2);
        }
        float hipDZ = 0.0f;
        this.leftHip.addTorque(0.0f, 0.0f, (hipDZ - this.lHipCZ) * this.s * 150.0f - dHipLZ * this.s * 15.0f);
        this.rightHip.addTorque(0.0f, 0.0f, (hipDZ - this.rHipCZ) * this.s * 150.0f - dHipRZ * this.s * 15.0f);
        float kneeD = this.pelH >= this.ul + this.ll ? 0.0f : -((float)Math.PI - (float)Math.acos((this.ul * this.ul + this.ll * this.ll - this.pelH * this.pelH) / (2.0f * this.ul * this.ll)));
        float dKneeR = 0.0f;
        float dKneeL = 0.0f;
        if (!this.firstRun) {
            float rKneeOld = this.rKneeC;
            float lKneeOld = this.lKneeC;
            this.lKneeC = this.leftKnee.getAngle(0);
            this.rKneeC = this.rightKnee.getAngle(0);
            dKneeR = (this.rKneeC - rKneeOld) / (float)timeDiff;
            dKneeL = (this.lKneeC - lKneeOld) / (float)timeDiff;
        } else {
            this.lKneeC = this.leftKnee.getAngle(0);
            this.rKneeC = this.rightKnee.getAngle(0);
        }
        float lKneeT = kneeD - this.lKneeC;
        float rKneeT = kneeD - this.rKneeC;
        this.leftKnee.addTorque(lKneeT * this.s * this.kpKnee - dKneeL * this.s * this.kvKnee, 0.0f, 0.0f);
        this.rightKnee.addTorque(rKneeT * this.s * this.kpKnee - dKneeR * this.s * this.kvKnee, 0.0f, 0.0f);
        Vec3f.set((float[])this.leftFw, (float)0.0f, (float)0.0f, (float)1.0f);
        Vec3f.set((float[])this.rightFw, (float)0.0f, (float)0.0f, (float)1.0f);
        Quat4f.transformVec3f((float[])this.qLeftFoot, (float[])this.leftFw);
        Quat4f.transformVec3f((float[])this.qRightFoot, (float[])this.rightFw);
        Quat4f.transformVec3f((float[])this.qBody, (float[])this.leftFw);
        Quat4f.transformVec3f((float[])this.qBody, (float[])this.rightFw);
        float dRotLFoot = 0.0f;
        float dRotRFoot = 0.0f;
        Vec3f.set((float[])this.v1, (float)0.0f, (float)0.0f, (float)1.0f);
        double lDot = Vec3f.dot((float[])this.leftFw, (float[])this.v1);
        double rDot = Vec3f.dot((float[])this.rightFw, (float[])this.v1);
        if (lDot < -1.0) {
            lDot = -1.0;
        }
        if (lDot > 1.0) {
            lDot = 1.0;
        }
        if (rDot < -1.0) {
            rDot = -1.0;
        }
        if (rDot > 1.0) {
            rDot = 1.0;
        }
        if (!this.firstRun) {
            oldRotRFoot = this.rotXRFoot;
            oldRotLFoot = this.rotXLFoot;
            this.rotXLFoot = (float)Math.acos(lDot);
            this.rotXRFoot = (float)Math.acos(rDot);
            dRotLFoot = (this.rotXLFoot - oldRotRFoot) / (float)timeDiff;
            dRotRFoot = (this.rotXRFoot - oldRotLFoot) / (float)timeDiff;
        } else {
            this.rotXLFoot = (float)Math.acos(lDot);
            this.rotXRFoot = (float)Math.acos(rDot);
        }
        this.leftAnkle.addTorque(this.rotXLFoot * this.s * 160.0f - dRotLFoot * this.s * 1.6f, 0.0f, 0.0f);
        this.rightAnkle.addTorque(this.rotXRFoot * this.s * 160.0f - dRotRFoot * this.s * 1.6f, 0.0f, 0.0f);
        Vec3f.set((float[])this.v1, (float)1.0f, (float)0.0f, (float)0.0f);
        Vec3f.set((float[])this.leftFw, (float)1.0f, (float)0.0f, (float)0.0f);
        Quat4f.transformVec3f((float[])this.qLeftFoot, (float[])this.leftFw);
        Quat4f.transformVec3f((float[])this.qRightFoot, (float[])this.rightFw);
        Vec3f.set((float[])this.rightFw, (float)1.0f, (float)0.0f, (float)0.0f);
        lDot = Vec3f.dot((float[])this.leftFw, (float[])this.v1);
        rDot = Vec3f.dot((float[])this.rightFw, (float[])this.v1);
        if (lDot < -1.0) {
            lDot = -1.0;
        }
        if (lDot > 1.0) {
            lDot = 1.0;
        }
        if (rDot < -1.0) {
            rDot = -1.0;
        }
        if (rDot > 1.0) {
            rDot = 1.0;
        }
        dRotLFoot = 0.0f;
        dRotRFoot = 0.0f;
        if (!this.firstRun) {
            oldRotRFoot = this.rotZRFoot;
            oldRotLFoot = this.rotZLFoot;
            this.rotZLFoot = (float)Math.acos(lDot);
            this.rotZRFoot = (float)Math.acos(rDot);
            dRotLFoot = (this.rotZLFoot - oldRotLFoot) / (float)timeDiff;
            dRotRFoot = (this.rotZRFoot - oldRotRFoot) / (float)timeDiff;
        } else {
            this.rotZLFoot = (float)Math.acos(lDot);
            this.rotZRFoot = (float)Math.acos(rDot);
        }
        this.leftAnkle.addTorque(offsetZ * this.s * 3.0f, 0.0f, -offsetX * this.s * 3.0f);
        this.rightAnkle.addTorque(offsetZ * this.s * 3.0f, 0.0f, -offsetX * this.s * 3.0f);
        this.firstRun = false;
    }

    public void setPelH(float pelH) {
        this.pelH = pelH;
    }

    @Override
    public PhysicalController copy(PhysicalHumanoid ph) {
        BalanceController copy = new BalanceController(ph);
        copy.pelH = this.pelH;
        copy.groundCheck = this.groundCheck;
        copy.s = this.s;
        return copy;
    }

    @Override
    public float getFloatParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("pelvisheight")) {
            return this.pelH;
        }
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public String getParameterValue(String name) throws ControllerParameterNotFoundException {
        if (name.equals("pelvisheight")) {
            return "" + this.pelH;
        }
        throw new ControllerParameterNotFoundException(name);
    }

    @Override
    public void setParameterValue(String name, String value) throws ControllerParameterException {
        if (!StringUtil.isNumeric((String)value)) {
            throw new ControllerParameterException("Invalid parameter setting" + name + "=" + value);
        }
        this.setParameterValue(name, Float.parseFloat(value));
    }

    @Override
    public void setParameterValue(String name, float value) throws ControllerParameterException {
        if (name.equals("pelvisheight")) {
            this.setPelH(value);
        }
    }

    @Override
    public Set<String> getDesiredJointIDs() {
        return this.desjointIDs;
    }

    @Override
    public Set<String> getJoints() {
        return this.getRequiredJointIDs();
    }
}

