/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics.assembler;

import hmi.animation.VJoint;
import hmi.graphics.scenegraph.GNode;
import hmi.math.Vec3f;
import hmi.physics.JointType;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.assembler.PhysicalSegmentAssembler;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class PhysicalHumanoidAssembler
extends XMLStructureAdapter {
    private VJoint human;
    private PhysicalHumanoid ph;
    public PhysicalSegmentAssembler rootAssembler;
    public ArrayList<PhysicalSegmentAssembler> segmentAssemblers = new ArrayList();

    public PhysicalHumanoidAssembler(VJoint h, PhysicalHumanoid p) {
        this.human = h;
        this.ph = p;
    }

    public void createFromGNode(GNode node, String[] segments, String[] endSegments, String rootSegment, JointType[] types, float[] axes, float[] limits1, float[] limits2, float[] limits3) {
        PhysicalSegment ps = this.ph.createSegment(this.ph.getId() + "_" + rootSegment, rootSegment);
        PhysicalSegmentAssembler psa = new PhysicalSegmentAssembler(this.human, this.ph, ps);
        psa.setRoot(true);
        psa.createFromGNode(this.ph.getId(), node, rootSegment, segments, endSegments);
        this.setRootSegmentAssembler(psa);
        for (int i = 0; i < segments.length; ++i) {
            ps = this.ph.createSegment(this.ph.getId() + "_" + segments[i], segments[i]);
            psa = new PhysicalSegmentAssembler(this.human, this.ph, ps);
            psa.createFromGNode(this.ph.getId(), node, segments[i], segments, endSegments);
            psa.segment.jointType = types[i];
            Vec3f.set((float[])psa.segment.axis1, (int)0, (float[])axes, (int)(i * 6));
            Vec3f.set((float[])psa.segment.axis2, (int)0, (float[])axes, (int)(i * 6 + 3));
            psa.segment.loStop[0] = limits1[i * 2];
            psa.segment.hiStop[0] = limits1[i * 2 + 1];
            psa.segment.loStop[1] = limits2[i * 2];
            psa.segment.hiStop[1] = limits2[i * 2 + 1];
            psa.segment.loStop[2] = limits3[i * 2];
            psa.segment.hiStop[2] = limits3[i * 2 + 1];
            this.addPhysicalSegmentAssembler(psa);
        }
    }

    public void setupStartJointOffset(PhysicalSegmentAssembler psa) {
        float[] trans = new float[3];
        psa.startJoint.getPathTranslation(null, trans);
        float[] pos = new float[3];
        psa.segment.box.getTranslation(pos);
        Vec3f.sub((float[])trans, (float[])pos);
        Vec3f.set((float[])psa.segment.startJointOffset, (float[])trans);
    }

    public void setupJoints(String rootJoint) {
        this.setupStartJointOffset(this.rootAssembler);
        this.ph.getRootSegment().box.setRotation(1.0f, 0.0f, 0.0f, 0.0f);
        VJoint rootJ = this.human.getPart(rootJoint);
        this.ph.setRootRotationBuffer(rootJ.getRotationBuffer());
        this.ph.setRootTranslationBuffer(rootJ.getTranslationBuffer());
        this.setJoints();
    }

    private void setJoints() {
        ArrayList<VJoint> assignedJoints = new ArrayList<VJoint>();
        for (PhysicalSegmentAssembler ps1 : this.segmentAssemblers) {
            for (VJoint rootEndJoint : this.rootAssembler.endJoints) {
                if (ps1.startJoint != rootEndJoint) continue;
                float[] center = new float[3];
                rootEndJoint.getPathTranslation(null, center);
                this.setupStartJointOffset(ps1);
                ps1.segment.startJoint = this.ph.setupJoint(ps1.startJoint.getSid(), this.ph.getRootSegment(), ps1.segment, center);
                ps1.segment.startJoint.setRotationBuffer(rootEndJoint.getRotationBuffer());
                assignedJoints.add(rootEndJoint);
            }
            for (PhysicalSegmentAssembler ps2 : this.segmentAssemblers) {
                for (VJoint endJoint : ps2.endJoints) {
                    if (ps1.startJoint != endJoint) continue;
                    float[] center = new float[3];
                    endJoint.getPathTranslation(null, center);
                    this.setupStartJointOffset(ps1);
                    ps1.segment.startJoint = this.ph.setupJoint(ps1.startJoint.getSid(), ps2.segment, ps1.segment, center);
                    ps1.segment.startJoint.setRotationBuffer(endJoint.getRotationBuffer());
                    assignedJoints.add(endJoint);
                }
            }
        }
    }

    public void clear() {
        this.segmentAssemblers.clear();
        this.ph.clear();
    }

    public void addPhysicalSegmentAssembler(PhysicalSegmentAssembler psa) {
        this.ph.addSegment(psa.segment);
        this.segmentAssemblers.add(psa);
    }

    public void removePhysicalSegmentAssembler(PhysicalSegmentAssembler psa) {
        this.ph.removeSegment(psa.segment);
        if (this.ph.getRootSegment() == psa.segment) {
            this.ph.setRootSegment(null);
        }
        this.ph.removeFromHashMap(psa.segment);
        this.segmentAssemblers.remove((Object)psa);
    }

    public void setRootSegmentAssembler(PhysicalSegmentAssembler psa) {
        this.rootAssembler = psa;
        this.ph.setRootSegment(psa.segment);
        this.ph.setupHashMaps(this.ph.getRootSegment());
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        return false;
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        return this.decodeAttribute(attrName, attrValue);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            PhysicalSegmentAssembler psa;
            PhysicalSegment ps;
            if (tokenizer.atSTag("PhysicalSegment")) {
                ps = this.ph.createSegment(this.ph.getId() + "_", "");
                psa = new PhysicalSegmentAssembler(this.human, this.ph, ps);
                psa.readXML(tokenizer);
                this.addPhysicalSegmentAssembler(psa);
                continue;
            }
            if (!tokenizer.atSTag("PhysicalRootSegment")) continue;
            ps = this.ph.createSegment(this.ph.getId() + "_", "");
            psa = new PhysicalSegmentAssembler(this.human, this.ph, ps);
            psa.setRoot(true);
            psa.readXML(tokenizer);
            this.setRootSegmentAssembler(psa);
        }
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        PhysicalHumanoidAssembler.appendNewLine((StringBuilder)buf);
        if (this.rootAssembler != null) {
            this.rootAssembler.appendXML(buf, fmt);
        }
        for (PhysicalSegmentAssembler ps : this.segmentAssemblers) {
            PhysicalHumanoidAssembler.appendNewLine((StringBuilder)buf);
            ps.appendXML(buf, fmt);
        }
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        return buf;
    }

    public String getXMLTag() {
        return "PhysicalHumanoid";
    }

    public PhysicalHumanoid getPhysicalHumanoid() {
        return this.ph;
    }
}

