/*
 * Decompiled with CFR 0.152.
 */
package hmi.physics;

import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.JointType;

public abstract class PhysicalJoint {
    protected JointType type;
    protected String name = "";
    protected float[] rotationBuffer;
    protected float[] axis1 = new float[]{1.0f, 0.0f, 0.0f};
    protected float[] axis2 = new float[]{0.0f, 1.0f, 0.0f};
    protected float[] hiStop = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
    protected float[] loStop = new float[]{-3.4028235E38f, -3.4028235E38f, -3.4028235E38f};
    private float[] q2 = new float[4];
    private float[] q3 = new float[4];
    float[] a1 = new float[]{-1.0f, 0.0f, 0.0f};
    float[] a2 = new float[]{0.0f, -1.0f, 0.0f};
    float[] a3 = new float[]{0.0f, 0.0f, -1.0f};
    float[] ax1 = new float[4];
    float[] ax2 = new float[4];
    float[] ax3 = new float[4];

    public PhysicalJoint(JointType t, String n) {
        this.type = t;
        this.name = n;
        for (int i = 0; i < 3; ++i) {
            this.ax1[i] = this.a1[i];
            this.ax2[i] = this.a2[i];
            this.ax3[i] = this.a3[i];
        }
        this.ax1[3] = 0.0f;
        this.ax2[3] = 0.0f;
        this.ax3[3] = 0.0f;
    }

    public JointType getType() {
        return this.type;
    }

    public abstract void getTorque1(float[] var1);

    public abstract void getTorque2(float[] var1);

    public abstract void getForce1(float[] var1);

    public abstract void getForce2(float[] var1);

    public abstract void addTorque(float var1, float var2, float var3);

    public abstract float getAngle(int var1);

    public abstract void setDesiredVelocity(int var1, float var2);

    public abstract void setMaximumForce(int var1, float var2);

    public void setJointMin(int ax, float min) {
        this.loStop[ax] = min;
    }

    public void setJointMax(int ax, float max) {
        this.hiStop[ax] = max;
    }

    public void setAxis(int ax, float x, float y, float z) {
        switch (ax) {
            case 0: {
                Vec3f.set((float[])this.axis1, (float)x, (float)y, (float)z);
                break;
            }
            case 1: {
                Vec3f.set((float[])this.axis2, (float)x, (float)y, (float)z);
            }
        }
    }

    public abstract void setAnchor(float var1, float var2, float var3);

    public abstract float[] getAnchor(float[] var1);

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRotationBuffer(float[] rotationBuffer) {
        this.rotationBuffer = rotationBuffer;
    }

    public float[] getRotationBuffer() {
        return this.rotationBuffer;
    }

    public void getRotation(float[] q) {
        this.ax1[3] = this.getAngle(0);
        this.ax2[3] = this.getAngle(1);
        this.ax3[3] = this.getAngle(2);
        Quat4f.setFromAxisAngle4f((float[])q, (float[])this.ax1);
        Quat4f.setFromAxisAngle4f((float[])this.q2, (float[])this.ax2);
        Quat4f.setFromAxisAngle4f((float[])this.q3, (float[])this.ax3);
        Quat4f.mul((float[])q, (float[])this.q2);
        Quat4f.mul((float[])q, (float[])this.q3);
    }

    public abstract void getAngularVelocity(float[] var1);

    public abstract void getAngularVelocity(float[] var1, int var2);

    public void getRotation(float[] q, int i) {
        this.ax1[3] = this.getAngle(0);
        this.ax2[3] = this.getAngle(1);
        this.ax3[3] = this.getAngle(2);
        Quat4f.setFromAxisAngle4f((float[])q, (int)i, (float[])this.ax1, (int)0);
        Quat4f.setFromAxisAngle4f((float[])this.q2, (float[])this.ax2);
        Quat4f.setFromAxisAngle4f((float[])this.q3, (float[])this.ax3);
        Quat4f.mul((float[])q, (int)i, (float[])this.q2, (int)0);
        Quat4f.mul((float[])q, (int)i, (float[])this.q3, (int)0);
    }
}

