/*
 * Decompiled with CFR 0.152.
 */
package hmi.neurophysics;

import hmi.math.Quat4f;
import hmi.math.Vec4f;

public final class EyeSaturation {
    private static final float RADIUS = 0.12f;

    private EyeSaturation() {
    }

    public static boolean isSaturized(float[] q) {
        float alpha = q[1] * q[1] + q[2] * q[2];
        float maxTorsion = 0.25f * (float)Math.sqrt(0.15f - alpha);
        return alpha < 0.0144f && Math.abs(q[3]) < maxTorsion;
    }

    public static void sat(float[] qCurDes, float[] qDes, float[] result) {
        float alpha = qCurDes[1] * qCurDes[1] + qCurDes[2] * qCurDes[2];
        Quat4f.set((float[])result, (float[])qCurDes);
        if (alpha > 0.0144f) {
            float beta = qCurDes[1] * qDes[1] + qCurDes[2] * qDes[2];
            float b = 2.0f * (alpha - beta);
            float gamma = qDes[1] * qDes[1] + qDes[2] * qDes[2];
            float a = alpha - 2.0f * beta + gamma;
            float c = alpha - 0.0144f;
            float D = b * b - 4.0f * a * c;
            if (D < 0.0f) {
                D = 0.0f;
            }
            float x = (-b + (float)Math.sqrt(D)) / (2.0f * a);
            result[1] = result[1] - qDes[1];
            result[2] = result[2] - qDes[2];
            result[3] = result[3] - qDes[3];
            Vec4f.scale((float)x, (float[])result);
            Quat4f.add((float[])result, (float[])qCurDes);
            alpha = 0.0144f;
        }
        float maxTorsion = 0.25f * (float)Math.sqrt(0.15f - alpha);
        if (Math.abs(result[3]) > maxTorsion) {
            result[3] = Math.signum(result[3]) * maxTorsion;
        }
        result[0] = (float)Math.sqrt(1.0f - (result[1] * result[1] + result[2] * result[2] + result[3] * result[3]));
    }
}

