/*
 * Decompiled with CFR 0.152.
 */
package hmi.math.digitalfilter;

import hmi.math.digitalfilter.Butterworth;

public final class Winters {
    private Winters() {
    }

    private static void reverse(float[] b) {
        int left = 0;
        for (int right = b.length - 1; left < right; ++left, --right) {
            float temp = b[left];
            b[left] = b[right];
            b[right] = temp;
        }
    }

    private static void reverse(float[] b, int width) {
        int left = 0;
        for (int right = b.length / width - 1; left < right; ++left, --right) {
            for (int i = 0; i < width; ++i) {
                float temp = b[left * width + i];
                b[left * width + i] = b[right * width + i];
                b[right * width + i] = temp;
            }
        }
    }

    public static void winters(float[] fin, float fc, float fs, int width, float[] fout) {
        float[] ftemp = new float[fin.length];
        Butterworth.butterworth(fin, fc, fs, 2, width, ftemp);
        Winters.reverse(ftemp, width);
        Butterworth.butterworth(ftemp, fc, fs, 2, width, fout);
        Winters.reverse(fout, width);
    }

    public static void winters(float[] fin, float fc, float fs, float[] fout) {
        float[] ftemp = new float[fin.length];
        Butterworth.butterworth(fin, fc, fs, 1, fout);
        Winters.reverse(ftemp);
        Butterworth.butterworth(ftemp, fc, fs, 2, fout);
        Winters.reverse(fout);
    }
}

