/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

public final class Vecf {
    private Vecf() {
    }

    public static float[] getVecf(int len) {
        return new float[len];
    }

    public static float[] getVecf(float[] vecf) {
        float[] result = new float[vecf.length];
        System.arraycopy(vecf, 0, result, 0, vecf.length);
        return result;
    }

    public static boolean equals(float[] a, float[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean epsilonEquals(float[] a, float[] b, float epsilon) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            float diff = a[i] - b[i];
            if (Float.isNaN(diff)) {
                return false;
            }
            float f = diff < 0.0f ? -diff : diff;
            if (!(f > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static String toString(float[] config) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (config == null) {
            buf.append("null");
        } else {
            int len = config.length;
            if (len > 0) {
                buf.append(config[0]);
            }
            for (int i = 1; i < len; ++i) {
                buf.append(", ");
                buf.append(config[i]);
            }
        }
        buf.append(')');
        return buf.toString();
    }

    public static void set(float[] dst, float[] src) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = src[i];
        }
    }

    public static void add(float[] dst, float[] a, float[] b) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = a[i] + b[i];
        }
    }

    public static void add(float[] dst, float[] a) {
        for (int i = 0; i < dst.length; ++i) {
            int n = i;
            dst[n] = dst[n] + a[i];
        }
    }

    public static void sub(float[] dst, float[] a, float[] b) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = a[i] - b[i];
        }
    }

    public static void sub(float[] dst, float[] a) {
        for (int i = 0; i < dst.length; ++i) {
            int n = i;
            dst[n] = dst[n] - a[i];
        }
    }

    public static void scale(float scale, float[] dst) {
        int i = 0;
        while (i < dst.length) {
            int n = i++;
            dst[n] = dst[n] * scale;
        }
    }

    public static void scale(float scale, float[] dst, float[] src) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = scale * src[i];
        }
    }

    public static void pmul(float[] dst, float[] a, float[] b) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = a[i] * b[i];
        }
    }

    public static void negate(float[] dst, float[] src) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = -src[i];
        }
    }

    public static void negate(float[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = -dst[i];
        }
    }

    public static float dot(float[] a, float[] b) {
        float d = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            d += a[i] * b[i];
        }
        return d;
    }

    public static float lengthSq(float[] a) {
        return Vecf.dot(a, a);
    }

    public static float length(float[] a) {
        return (float)Math.sqrt(Vecf.dot(a, a));
    }

    public static void interpolate(float[] dst, float[] a, float[] b, float alpha) {
        for (int i = 0; i < a.length; ++i) {
            dst[i] = (1.0f - alpha) * a[i] + alpha * b[i];
        }
    }

    public static void normalize(float[] dst, float[] a) {
        float linv = 1.0f / Vecf.length(a);
        Vecf.scale(linv, dst, a);
    }

    public static void normalize(float[] a) {
        float linv = 1.0f / Vecf.length(a);
        Vecf.scale(linv, a);
    }
}

