/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

public final class Vec3f {
    public static final int VEC3F_SIZE = 3;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private static final int BUFSIZE = 30;

    private Vec3f() {
    }

    public static float[] getVec3f() {
        return new float[3];
    }

    public static float[] getVec3f(float x, float y, float z) {
        return new float[]{x, y, z};
    }

    public static float[] getVec3f(float[] vec3f) {
        return new float[]{vec3f[0], vec3f[1], vec3f[2]};
    }

    public static float[] getZero() {
        return new float[3];
    }

    public static float[] getUnitX() {
        return new float[]{1.0f, 0.0f, 0.0f};
    }

    public static float[] getUnitY() {
        return new float[]{0.0f, 1.0f, 0.0f};
    }

    public static float[] getUnitZ() {
        return new float[]{0.0f, 0.0f, 1.0f};
    }

    public static boolean equals(float[] a, int aIndex, float[] b, int bIndex) {
        return a[aIndex] == b[bIndex] && a[aIndex + 1] == b[bIndex + 1] && a[aIndex + 2] == b[bIndex + 2];
    }

    public static boolean equals(float[] a, float bx, float by, float bz) {
        return a[0] == bx && a[1] == by && a[2] == bz;
    }

    public static boolean equals(float[] a, float[] b) {
        return a[0] == b[0] && a[1] == b[1] && a[2] == b[2];
    }

    public static boolean epsilonEquals(float[] a, int aIndex, float[] b, int bIndex, float epsilon) {
        float diff = a[aIndex] - b[bIndex];
        if (Float.isNaN(diff)) {
            return false;
        }
        float f = diff < 0.0f ? -diff : diff;
        if (f > epsilon) {
            return false;
        }
        diff = a[aIndex + 1] - b[bIndex + 1];
        if (Float.isNaN(diff)) {
            return false;
        }
        float f2 = diff < 0.0f ? -diff : diff;
        if (f2 > epsilon) {
            return false;
        }
        diff = a[aIndex + 2] - b[bIndex + 2];
        if (Float.isNaN(diff)) {
            return false;
        }
        float f3 = diff < 0.0f ? -diff : diff;
        return !(f3 > epsilon);
    }

    public static boolean epsilonEquals(float[] a, float[] b, float epsilon) {
        float diff = a[0] - b[0];
        if (Float.isNaN(diff)) {
            return false;
        }
        float f = diff < 0.0f ? -diff : diff;
        if (f > epsilon) {
            return false;
        }
        diff = a[1] - b[1];
        if (Float.isNaN(diff)) {
            return false;
        }
        float f2 = diff < 0.0f ? -diff : diff;
        if (f2 > epsilon) {
            return false;
        }
        diff = a[2] - b[2];
        if (Float.isNaN(diff)) {
            return false;
        }
        float f3 = diff < 0.0f ? -diff : diff;
        return !(f3 > epsilon);
    }

    public static boolean epsilonEquals(float[] b, float ax, float ay, float az, float epsilon) {
        float diff = ax - b[0];
        if (Float.isNaN(diff)) {
            return false;
        }
        float f = diff < 0.0f ? -diff : diff;
        if (f > epsilon) {
            return false;
        }
        diff = ay - b[1];
        if (Float.isNaN(diff)) {
            return false;
        }
        float f2 = diff < 0.0f ? -diff : diff;
        if (f2 > epsilon) {
            return false;
        }
        diff = az - b[2];
        if (Float.isNaN(diff)) {
            return false;
        }
        float f3 = diff < 0.0f ? -diff : diff;
        return !(f3 > epsilon);
    }

    public static String toString(float[] a, int index) {
        return "(" + a[index] + ", " + a[index + 1] + ", " + a[index + 2] + ")";
    }

    public static String toString(float[] a) {
        return "(" + a[0] + ", " + a[1] + ", " + a[2] + ")";
    }

    public static String toString(float[] a, int fieldwidth, int precision) {
        return Vec3f.toString(a, "%" + fieldwidth + "." + precision + "f");
    }

    public static String toString(float[] a, String fmt) {
        StringBuffer buf = new StringBuffer(30);
        buf.append('(');
        buf.append(String.format(fmt, Float.valueOf(a[0])));
        buf.append(',');
        buf.append(String.format(fmt, Float.valueOf(a[1])));
        buf.append(',');
        buf.append(String.format(fmt, Float.valueOf(a[2])));
        buf.append(')');
        return buf.toString();
    }

    public static void setZero(float[] dst) {
        dst[0] = 0.0f;
        dst[1] = 0.0f;
        dst[2] = 0.0f;
    }

    public static void setZero(float[] dst, int dstIndex) {
        dst[dstIndex] = 0.0f;
        dst[dstIndex + 1] = 0.0f;
        dst[dstIndex + 2] = 0.0f;
    }

    public static void set(float[] dst, int dstIndex, float[] src, int srcIndex) {
        dst[dstIndex] = src[srcIndex];
        dst[dstIndex + 1] = src[srcIndex + 1];
        dst[dstIndex + 2] = src[srcIndex + 2];
    }

    public static void set(float[] dst, float[] src) {
        dst[0] = src[0];
        dst[1] = src[1];
        dst[2] = src[2];
    }

    public static void set(float[] dst, int dstIndex, float x, float y, float z) {
        dst[dstIndex] = x;
        dst[dstIndex + 1] = y;
        dst[dstIndex + 2] = z;
    }

    public static void set(float[] dst, float x, float y, float z) {
        dst[0] = x;
        dst[1] = y;
        dst[2] = z;
    }

    public static void add(float[] dst, int dstIndex, float[] a, int aIndex, float[] b, int bIndex) {
        dst[dstIndex] = a[aIndex] + b[bIndex];
        dst[dstIndex + 1] = a[aIndex + 1] + b[bIndex + 1];
        dst[dstIndex + 2] = a[aIndex + 2] + b[bIndex + 2];
    }

    public static void add(float[] dst, int dstIndex, float[] a, int aIndex) {
        int n = dstIndex;
        dst[n] = dst[n] + a[aIndex];
        int n2 = dstIndex + 1;
        dst[n2] = dst[n2] + a[aIndex + 1];
        int n3 = dstIndex + 2;
        dst[n3] = dst[n3] + a[aIndex + 2];
    }

    public static void add(float[] dst, float[] a, float[] b) {
        dst[0] = a[0] + b[0];
        dst[1] = a[1] + b[1];
        dst[2] = a[2] + b[2];
    }

    public static void add(float[] dst, float[] a) {
        dst[0] = dst[0] + a[0];
        dst[1] = dst[1] + a[1];
        dst[2] = dst[2] + a[2];
    }

    public static void add(float[] dst, float ax, float ay, float az) {
        dst[0] = dst[0] + ax;
        dst[1] = dst[1] + ay;
        dst[2] = dst[2] + az;
    }

    public static void sub(float[] dst, int dstIndex, float[] a, int aIndex, float[] b, int bIndex) {
        dst[dstIndex] = a[aIndex] - b[bIndex];
        dst[dstIndex + 1] = a[aIndex + 1] - b[bIndex + 1];
        dst[dstIndex + 2] = a[aIndex + 2] - b[bIndex + 2];
    }

    public static void sub(float[] dst, int dstIndex, float[] a, int aIndex) {
        int n = dstIndex;
        dst[n] = dst[n] - a[aIndex];
        int n2 = dstIndex + 1;
        dst[n2] = dst[n2] - a[aIndex + 1];
        int n3 = dstIndex + 2;
        dst[n3] = dst[n3] - a[aIndex + 2];
    }

    public static void sub(float[] dst, float[] a, float[] b) {
        dst[0] = a[0] - b[0];
        dst[1] = a[1] - b[1];
        dst[2] = a[2] - b[2];
    }

    public static void sub(float[] dst, float[] a) {
        dst[0] = dst[0] - a[0];
        dst[1] = dst[1] - a[1];
        dst[2] = dst[2] - a[2];
    }

    public static void sub(float[] dst, float ax, float ay, float az) {
        dst[0] = dst[0] - ax;
        dst[1] = dst[1] - ay;
        dst[2] = dst[2] - az;
    }

    public static void scale(float scale, float[] dst, float[] src) {
        dst[0] = scale * src[0];
        dst[1] = scale * src[1];
        dst[2] = scale * src[2];
    }

    public static void scale(float scale, float[] dst, int dstIndex, float[] src, int srcIndex) {
        dst[dstIndex] = scale * src[srcIndex];
        dst[dstIndex + 1] = scale * src[srcIndex + 1];
        dst[dstIndex + 2] = scale * src[srcIndex + 2];
    }

    public static void scale(float scale, float[] dst, int dstIndex) {
        int n = dstIndex;
        dst[n] = dst[n] * scale;
        int n2 = dstIndex + 1;
        dst[n2] = dst[n2] * scale;
        int n3 = dstIndex + 2;
        dst[n3] = dst[n3] * scale;
    }

    public static void scale(float scale, float[] dst) {
        dst[0] = dst[0] * scale;
        dst[1] = dst[1] * scale;
        dst[2] = dst[2] * scale;
    }

    public static void invert(float[] dst) {
        dst[0] = 1.0f / dst[0];
        dst[1] = 1.0f / dst[1];
        dst[2] = 1.0f / dst[2];
    }

    public static void scaleAdd(float[] dst, int dstIndex, float scale, float[] a, int aIndex, float[] b, int bIndex) {
        dst[dstIndex] = a[aIndex] * scale + b[bIndex];
        dst[dstIndex + 1] = a[aIndex + 1] * scale + b[bIndex + 1];
        dst[dstIndex + 2] = a[aIndex + 2] * scale + b[bIndex + 2];
    }

    public static void scaleAdd(float[] dst, float scale, float[] a, float[] b) {
        dst[0] = a[0] * scale + b[0];
        dst[1] = a[1] * scale + b[1];
        dst[2] = a[2] * scale + b[2];
    }

    public static void scaleAdd(float scale, float[] dst, int dstIndex, float[] a, int aIndex) {
        dst[dstIndex] = dst[dstIndex] * scale + a[aIndex];
        dst[dstIndex + 1] = dst[dstIndex + 1] * scale + a[aIndex + 1];
        dst[dstIndex + 2] = dst[dstIndex + 2] * scale + a[aIndex + 2];
    }

    public static void scaleAdd(float[] dst, int dstIndex, float scale, float[] a, int aIndex) {
        int n = dstIndex;
        dst[n] = dst[n] + a[aIndex] * scale;
        int n2 = dstIndex + 1;
        dst[n2] = dst[n2] + a[aIndex + 1] * scale;
        int n3 = dstIndex + 2;
        dst[n3] = dst[n3] + a[aIndex + 2] * scale;
    }

    public static void scaleAdd(float[] dst, float scale, float[] a) {
        dst[0] = dst[0] + a[0] * scale;
        dst[1] = dst[1] + a[1] * scale;
        dst[2] = dst[2] + a[2] * scale;
    }

    public static void scaleAdd(float scale, float[] dst, float[] a) {
        dst[0] = dst[0] * scale + a[0];
        dst[1] = dst[1] * scale + a[1];
        dst[2] = dst[2] * scale + a[2];
    }

    public static void negate(float[] dst, int dstIndex, float[] src, int srcIndex) {
        dst[dstIndex] = -src[srcIndex];
        dst[dstIndex + 1] = -src[srcIndex + 1];
        dst[dstIndex + 2] = -src[srcIndex + 2];
    }

    public static void negate(float[] dst, float[] src) {
        dst[0] = -src[0];
        dst[1] = -src[1];
        dst[2] = -src[2];
    }

    public static void negate(float[] dst, int dstIndex) {
        dst[dstIndex] = -dst[dstIndex];
        dst[dstIndex + 1] = -dst[dstIndex + 1];
        dst[dstIndex + 2] = -dst[dstIndex + 2];
    }

    public static void negate(float[] dst) {
        dst[0] = -dst[0];
        dst[1] = -dst[1];
        dst[2] = -dst[2];
    }

    public static void cross(float[] dst, float[] a, float[] b) {
        dst[0] = a[1] * b[2] - a[2] * b[1];
        dst[1] = a[2] * b[0] - a[0] * b[2];
        dst[2] = a[0] * b[1] - a[1] * b[0];
    }

    public static void cross(float[] dst, int dstIndex, float[] a, int aIndex, float[] b, int bIndex) {
        dst[dstIndex] = a[aIndex + 1] * b[bIndex + 2] - a[aIndex + 2] * b[bIndex + 1];
        dst[dstIndex + 1] = a[aIndex + 2] * b[bIndex] - a[aIndex] * b[bIndex + 2];
        dst[dstIndex + 2] = a[aIndex] * b[bIndex + 1] - a[aIndex + 1] * b[bIndex];
    }

    public static float dot(float[] a, float[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static float dot(float[] a, int aIndex, float[] b, int bIndex) {
        return a[aIndex] * b[bIndex] + a[aIndex + 1] * b[bIndex + 1] + a[aIndex + 2] * b[bIndex + 2];
    }

    public static float lengthSq(float[] a, int aIndex) {
        return a[aIndex] * a[aIndex] + a[aIndex + 1] * a[aIndex + 1] + a[aIndex + 2] * a[aIndex + 2];
    }

    public static float lengthSq(float[] a) {
        return a[0] * a[0] + a[1] * a[1] + a[2] * a[2];
    }

    public static float length(float[] a, int aIndex) {
        return (float)Math.sqrt(a[aIndex] * a[aIndex] + a[aIndex + 1] * a[aIndex + 1] + a[aIndex + 2] * a[aIndex + 2]);
    }

    public static float length(float[] a) {
        return (float)Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
    }

    public static void interpolateArrays(float[] dst, float[] a, float[] b, float alpha) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = (1.0f - alpha) * a[i] + alpha * b[i];
        }
    }

    public static void interpolate(float[] dst, int dstIndex, float[] a, int aIndex, float[] b, int bIndex, float alpha) {
        dst[dstIndex] = (1.0f - alpha) * a[aIndex] + alpha * b[bIndex];
        dst[dstIndex + 1] = (1.0f - alpha) * a[aIndex + 1] + alpha * b[bIndex + 1];
        dst[dstIndex + 2] = (1.0f - alpha) * a[aIndex + 2] + alpha * b[bIndex + 2];
    }

    public static void interpolate(float[] dst, float[] a, float[] b, float alpha) {
        dst[0] = (1.0f - alpha) * a[0] + alpha * b[0];
        dst[1] = (1.0f - alpha) * a[1] + alpha * b[1];
        dst[2] = (1.0f - alpha) * a[2] + alpha * b[2];
    }

    public static void normalize(float[] dst, int dstIndex, float[] a, int aIndex) {
        float linv = 1.0f / Vec3f.length(a, aIndex);
        dst[dstIndex] = a[aIndex] * linv;
        dst[dstIndex + 1] = a[aIndex + 1] * linv;
        dst[dstIndex + 2] = a[aIndex + 2] * linv;
    }

    public static void normalize(float[] a, int aIndex) {
        float linv = 1.0f / Vec3f.length(a, aIndex);
        a[aIndex] = a[aIndex] * linv;
        a[aIndex + 1] = a[aIndex + 1] * linv;
        a[aIndex + 2] = a[aIndex + 2] * linv;
    }

    public static void normalize(float[] dst, float[] a) {
        float linv = 1.0f / Vec3f.length(a);
        dst[0] = a[0] * linv;
        dst[1] = a[1] * linv;
        dst[2] = a[2] * linv;
    }

    public static void normalize(float[] a) {
        float linv = 1.0f / Vec3f.length(a);
        a[0] = a[0] * linv;
        a[1] = a[1] * linv;
        a[2] = a[2] * linv;
    }

    public static void pmul(float[] u, float[] v) {
        u[0] = u[0] * v[0];
        u[1] = u[1] * v[1];
        u[2] = u[2] * v[2];
    }
}

