/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Vec3f;

public final class SpatialVec {
    public static final int SPATIALVEC_SIZE = 6;
    public static final float[] ZERO = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    private SpatialVec() {
    }

    public static void set(float[] dst, float v0, float v1, float v2, float v3, float v4, float v5) {
        dst[0] = v0;
        dst[1] = v1;
        dst[2] = v2;
        dst[3] = v3;
        dst[4] = v4;
        dst[5] = v5;
    }

    public static void setZero(float[] dst) {
        for (int i = 0; i < 6; ++i) {
            dst[i] = 0.0f;
        }
    }

    public static void set(float[] dst, float[] src) {
        for (int i = 0; i < 6; ++i) {
            dst[i] = src[i];
        }
    }

    public static void set(float[] dst, int dstIndex, float[] src, int srcIndex) {
        for (int i = 0; i < 6; ++i) {
            dst[dstIndex + i] = src[srcIndex + i];
        }
    }

    public static void set(float[] dst, float[] w, float[] v0) {
        dst[0] = w[0];
        dst[1] = w[1];
        dst[2] = w[2];
        dst[3] = v0[0];
        dst[4] = v0[1];
        dst[5] = v0[2];
    }

    public static void setAcc(float[] dst, float[] w, float[] v, float[] wDiff, float[] a) {
        Vec3f.cross(dst, w, v);
        Vec3f.set(dst, 3, a, 0);
        Vec3f.sub(dst, 3, dst, 0);
        Vec3f.set(dst, wDiff);
    }

    public static void add(float[] dst, float[] a, float[] b) {
        dst[0] = a[0] + b[0];
        dst[1] = a[1] + b[1];
        dst[2] = a[2] + b[2];
        dst[3] = a[3] + b[3];
        dst[4] = a[4] + b[4];
        dst[5] = a[5] + b[5];
    }

    public static void sub(float[] dst, float[] a, float[] b) {
        dst[0] = a[0] - b[0];
        dst[1] = a[1] - b[1];
        dst[2] = a[2] - b[2];
        dst[3] = a[3] - b[3];
        dst[4] = a[4] - b[4];
        dst[5] = a[5] - b[5];
    }

    public static void add(float[] dst, float[] a) {
        dst[0] = dst[0] + a[0];
        dst[1] = dst[1] + a[1];
        dst[2] = dst[2] + a[2];
        dst[3] = dst[3] + a[3];
        dst[4] = dst[4] + a[4];
        dst[5] = dst[5] + a[5];
    }

    public static void sub(float[] dst, float[] a) {
        dst[0] = dst[0] - a[0];
        dst[1] = dst[1] - a[1];
        dst[2] = dst[2] - a[2];
        dst[3] = dst[3] - a[3];
        dst[4] = dst[4] - a[4];
        dst[5] = dst[5] - a[5];
    }

    public static void add(float[] dst, int dstIndex, float[] a, int aIndex) {
        int n = dstIndex;
        dst[n] = dst[n] + a[aIndex];
        int n2 = dstIndex + 1;
        dst[n2] = dst[n2] + a[aIndex + 1];
        int n3 = dstIndex + 2;
        dst[n3] = dst[n3] + a[aIndex + 2];
        int n4 = dstIndex + 3;
        dst[n4] = dst[n4] + a[aIndex + 3];
        int n5 = dstIndex + 4;
        dst[n5] = dst[n5] + a[aIndex + 4];
        int n6 = dstIndex + 5;
        dst[n6] = dst[n6] + a[aIndex + 5];
    }

    public static void sub(float[] dst, int dstIndex, float[] a, int aIndex) {
        int n = dstIndex;
        dst[n] = dst[n] - a[aIndex];
        int n2 = dstIndex + 1;
        dst[n2] = dst[n2] - a[aIndex + 1];
        int n3 = dstIndex + 2;
        dst[n3] = dst[n3] - a[aIndex + 2];
        int n4 = dstIndex + 3;
        dst[n4] = dst[n4] - a[aIndex + 3];
        int n5 = dstIndex + 4;
        dst[n5] = dst[n5] - a[aIndex + 4];
        int n6 = dstIndex + 5;
        dst[n6] = dst[n6] - a[aIndex + 5];
    }

    public static float dot(float[] a, float[] b) {
        return Vec3f.dot(a, 0, b, 3) + Vec3f.dot(a, 3, b, 0);
    }

    public static float dot(float[] a, int aIndex, float[] b, int bIndex) {
        return Vec3f.dot(a, aIndex, b, bIndex + 3) + Vec3f.dot(a, aIndex + 3, b, bIndex);
    }

    public static void cross(float[] dst, float[] a, float[] b) {
        Vec3f.cross(dst, 0, a, 0, b, 3);
        Vec3f.cross(dst, 3, a, 3, b, 0);
        Vec3f.add(dst, 3, dst, 0);
        Vec3f.cross(dst, a, b);
    }

    public static void cross(float[] dst, int dstIndex, float[] a, int aIndex, float[] b, int bIndex) {
        Vec3f.cross(dst, dstIndex, a, aIndex, b, bIndex + 3);
        Vec3f.cross(dst, dstIndex + 3, a, aIndex + 3, b, bIndex);
        Vec3f.add(dst, dstIndex + 3, dst, dstIndex);
        Vec3f.cross(dst, dstIndex, a, aIndex, b, bIndex);
    }

    public static void crossForce(float[] dst, float[] v, float[] f) {
        Vec3f.cross(dst, v, f);
        Vec3f.cross(dst, 3, v, 3, f, 3);
        Vec3f.add(dst, 0, dst, 3);
        Vec3f.cross(dst, 3, v, 0, f, 3);
    }

    public static void crossForce(float[] dst, int dstIndex, float[] v, int vIndex, float[] f, int fIndex) {
        Vec3f.cross(dst, dstIndex, v, vIndex, f, fIndex);
        Vec3f.cross(dst, dstIndex + 3, v, vIndex + 3, f, fIndex + 3);
        Vec3f.add(dst, dstIndex, dst, dstIndex + 3);
        Vec3f.cross(dst, dstIndex + 3, v, vIndex, f, fIndex + 3);
    }

    public static boolean epsilonEquals(float[] a, float[] b, float epsilon) {
        return Vec3f.epsilonEquals(a, b, epsilon) && Vec3f.epsilonEquals(a, 3, b, 3, epsilon);
    }

    public static boolean epsilonEquals(float[] a, int aIndex, float[] b, int bIndex, float epsilon) {
        return Vec3f.epsilonEquals(a, aIndex, b, bIndex, epsilon) && Vec3f.epsilonEquals(a, aIndex + 3, b, bIndex + 3, epsilon);
    }

    public static String toString(float[] a) {
        return Vec3f.toString(a) + Vec3f.toString(a, 3);
    }

    public static String toString(float[] a, int aIndex) {
        return Vec3f.toString(a, aIndex) + Vec3f.toString(a, aIndex + 3);
    }
}

