/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat3f;
import hmi.math.Vec3f;

public final class SpatialInertiaTensor {
    public static final int I = 0;
    public static final int H = 9;
    public static final int M = 12;

    private SpatialInertiaTensor() {
    }

    public static float[] getSpatialInertiaTensor() {
        return new float[13];
    }

    public static void set(float[] tensor, float[] rotI, float[] pos, float mass) {
        Mat3f.skew(tensor, pos);
        Mat3f.mul(tensor, tensor);
        Mat3f.scale(tensor, -mass);
        Mat3f.add(tensor, rotI);
        tensor[12] = mass;
        Vec3f.set(tensor, 9, pos, 0);
        Vec3f.scale(mass, tensor, 9);
    }

    public static void set(float[] tensor, int iIndex, float[] rotI, float[] pos, float mass) {
        Mat3f.skew(tensor, iIndex, pos, 0);
        Mat3f.mul(tensor, iIndex, tensor, iIndex);
        Mat3f.scale(tensor, iIndex, -mass);
        Mat3f.add(tensor, iIndex, rotI, 0);
        tensor[iIndex + 12] = mass;
        Vec3f.set(tensor, iIndex + 9, pos, 0);
        Vec3f.scale(mass, tensor, iIndex + 9);
    }

    public static void set(float[] tensor, float[] rotI, float mass) {
        Mat3f.set(tensor, rotI);
        Vec3f.set(tensor, 9, 0.0f, 0.0f, 0.0f);
        tensor[12] = mass;
    }

    public static void set(float[] tensor, int iIndex, float[] rotI, float mass) {
        Mat3f.set(tensor, iIndex, rotI, 0);
        Vec3f.set(tensor, iIndex + 9, 0.0f, 0.0f, 0.0f);
        tensor[12 + iIndex] = mass;
    }

    public static void transformSpatialVec(float[] vdest, float[] tensor, float[] a) {
        Mat3f.transform(tensor, vdest, a);
        Vec3f.cross(vdest, 3, tensor, 9, a, 3);
        Vec3f.add(vdest, 0, vdest, 3);
        Vec3f.cross(vdest, 3, tensor, 9, a, 0);
        Vec3f.scale(-1.0f, vdest, 3);
        Vec3f.scaleAdd(vdest, 3, tensor[12], a, 3);
    }

    public static void transformSpatialVec(float[] vdest, int dstIndex, float[] tensor, int iIndex, float[] a, int aIndex) {
        Mat3f.transform(tensor, iIndex, vdest, dstIndex, a, aIndex);
        Vec3f.cross(vdest, dstIndex + 3, tensor, iIndex + 9, a, aIndex + 3);
        Vec3f.add(vdest, dstIndex, vdest, dstIndex + 3);
        Vec3f.cross(vdest, dstIndex + 3, tensor, iIndex + 9, a, aIndex);
        Vec3f.scale(-1.0f, vdest, dstIndex + 3);
        Vec3f.scaleAdd(vdest, dstIndex + 3, tensor[iIndex + 12], a, aIndex + 3);
    }

    public void add(float[] destTensor, float[] tensor1, float[] tensor2) {
        destTensor[12] = tensor1[12] + tensor2[12];
        Vec3f.add(destTensor, 9, tensor1, 9, tensor2, 9);
        Mat3f.add(destTensor, tensor1, tensor2);
    }

    public void add(float[] destTensor, int dstIndex, float[] tensor1, int index1, float[] tensor2, int index2) {
        destTensor[12 + dstIndex] = tensor1[12 + index1] + tensor2[12 + index2];
        Vec3f.add(destTensor, 9 + dstIndex, tensor1, 9 + index1, tensor2, 9 + index2);
        Mat3f.add(destTensor, dstIndex, tensor1, index1, tensor2, index2);
    }

    public static String toString(float[] tensor) {
        return "M: " + tensor[12] + "\nH: " + Vec3f.toString(tensor, 9) + "\nI: " + Mat3f.toStringTabbed(tensor, 0);
    }
}

