/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat3f;
import hmi.math.Vec3f;

public final class SpatialArticulatedBodyInertiaTensor {
    public static final int I = 0;
    public static final int H = 9;
    public static final int M = 18;

    private SpatialArticulatedBodyInertiaTensor() {
    }

    public static float[] getSpatialArticulatedBodyInertiaTensor() {
        return new float[27];
    }

    public void add(float[] destTensor, float[] tensor1, float[] tensor2) {
        Mat3f.add(destTensor, tensor1, tensor2);
        Mat3f.add(destTensor, 9, tensor1, 9, tensor2, 9);
        Mat3f.add(destTensor, 18, tensor1, 18, tensor2, 18);
    }

    public void add(float[] destTensor, int dstIndex, float[] tensor1, int index1, float[] tensor2, int index2) {
        Mat3f.add(destTensor, dstIndex, tensor1, index1, tensor2, index2);
        Mat3f.add(destTensor, 9 + dstIndex, tensor1, 9 + index2, tensor2, 9 + index2);
        Mat3f.add(destTensor, 18 + dstIndex, tensor1, 18 + index1, tensor2, 18 + index2);
    }

    public void addSpatialInertia(float[] destTensor, float[] tensor1, float[] tensor2) {
        Mat3f.setIdentity(destTensor, 18);
        Mat3f.scale(destTensor, 18, tensor2[12]);
        Mat3f.add(destTensor, 18, tensor1, 18);
        Mat3f.add(destTensor, tensor1, tensor2);
        Mat3f.skew(destTensor, 9, tensor2, 9);
        Mat3f.add(destTensor, 9, tensor1, 9);
    }

    public void addSpatialInertia(float[] destTensor, int dstIndex, float[] tensor1, int index2, float[] tensor2, int index1) {
        Mat3f.setIdentity(destTensor, dstIndex + 18);
        Mat3f.scale(destTensor, dstIndex + 18, tensor2[index2 + 12]);
        Mat3f.add(destTensor, dstIndex + 18, tensor1, index1 + 18);
        Mat3f.add(destTensor, dstIndex, tensor1, index1, tensor2, index2);
        Mat3f.skew(destTensor, dstIndex + 9, tensor2, index2 + 9);
        Mat3f.add(destTensor, dstIndex + 9, tensor1, index1 + 9);
    }

    public static void transformSpatialVec(float[] vdest, float[] tensor, float[] v) {
        Mat3f.transform(vdest, 3, tensor, 0, v, 0);
        Mat3f.transform(vdest, 0, tensor, 9, v, 3);
        Vec3f.add(vdest, 0, vdest, 0, vdest, 3);
        float[] tmp = new float[3];
        Mat3f.transform(tmp, 0, tensor, 18, v, 3);
        Mat3f.transformTranspose(vdest, 3, tensor, 9, v, 0);
        Vec3f.add(vdest, 3, tmp, 0);
    }

    public static void transformSpatialVec(float[] vdest, int dstIndex, float[] tensor, int iIndex, float[] v, int vIndex) {
        Mat3f.transform(vdest, 3 + dstIndex, tensor, iIndex, v, vIndex);
        Mat3f.transform(vdest, dstIndex, tensor, iIndex + 9, v, 3 + vIndex);
        Vec3f.add(vdest, dstIndex, vdest, dstIndex, vdest, 3 + dstIndex);
        float[] tmp = new float[3];
        Mat3f.transform(tmp, 0, tensor, iIndex + 18, v, vIndex + 3);
        Mat3f.transformTranspose(vdest, dstIndex + 3, tensor, iIndex + 9, v, vIndex);
        Vec3f.add(vdest, dstIndex + 3, tmp, 0);
    }

    public static void xstarIXinv(float[] destTensor, float[] tensor, float[] srcTensor) {
        Mat3f.skew(destTensor, 18, tensor, 9);
        Mat3f.mul(destTensor, 9, srcTensor, 18);
        Mat3f.sub(destTensor, 9, srcTensor, 9, destTensor, 9);
        Mat3f.mul(destTensor, 0, destTensor, 9, destTensor, 18);
        Mat3f.mulTransposeRight(destTensor, 18, destTensor, 18, srcTensor, 9);
        Mat3f.sub(destTensor, 0, destTensor, 18);
        Mat3f.add(destTensor, 0, srcTensor, 0);
        Mat3f.mulTransposeRight(destTensor, 0, destTensor, 0, tensor, 0);
        Mat3f.mul(destTensor, 0, tensor, 0, destTensor, 0);
        Mat3f.mul(destTensor, 9, tensor, 0, destTensor, 9);
        Mat3f.mulTransposeRight(destTensor, 9, destTensor, 9, tensor, 0);
        Mat3f.mul(destTensor, 18, tensor, 0, srcTensor, 18);
        Mat3f.mulTransposeRight(destTensor, 18, destTensor, 18, tensor, 0);
    }

    public static void setFromSpatialInertiaTensor(float[] destTensor, float[] spatialTensor) {
        Mat3f.set(destTensor, 0, spatialTensor, 0);
        Mat3f.skew(destTensor, 9, spatialTensor, 9);
        Mat3f.scale(destTensor, 18, Mat3f.getIdentity(), 0, spatialTensor[12]);
    }

    public static boolean epsilonEquals(float[] tensor1, float[] tensor2, float epsilon) {
        return Mat3f.epsilonEquals(tensor1, 18, tensor2, 18, epsilon) && Mat3f.epsilonEquals(tensor1, 9, tensor2, 9, epsilon) && Mat3f.epsilonEquals(tensor1, 0, tensor2, 0, epsilon);
    }

    public static String toString(float[] tensor) {
        return "M: " + Mat3f.toString(tensor, 18) + "\nH: " + Mat3f.toString(tensor, 9) + "\nI: " + Mat3f.toString(tensor, 0);
    }
}

