/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.HermiteSpline;
import java.util.Random;

public class PerlinNoise {
    private static final int DEFAULT_NR_OF_POINTS = 256;
    private float[] g;
    private static int randoms = 0;

    public PerlinNoise(int nr, float lowerLimit, float upperLimit) {
        this.g = new float[nr];
        this.initialize(lowerLimit, upperLimit);
    }

    public PerlinNoise(float lowerLimit, float upperLimit) {
        this.g = new float[256];
        this.initialize(lowerLimit, upperLimit);
    }

    public void initialize(float lowerLimit, float upperLimit) {
        Random r = new Random(System.currentTimeMillis() + (long)(++randoms));
        double radius = upperLimit - lowerLimit;
        for (int i = 0; i < this.g.length; ++i) {
            this.g[i] = (float)((double)lowerLimit + r.nextDouble() * radius);
        }
    }

    private float getG(int index) {
        return this.g[index % this.g.length];
    }

    private float getG(int index, int length) {
        int l = length;
        if (length >= this.g.length - 1) {
            l = this.g.length - 1;
        }
        return this.g[index % l];
    }

    public float noise(float t) {
        int tInt = (int)t;
        int t1 = tInt - 1;
        if (t1 < 0) {
            t1 += this.g.length;
        }
        return HermiteSpline.getValue(t - (float)tInt, this.getG(t1), this.getG(tInt), this.getG(tInt + 1), this.getG(tInt + 2));
    }

    public float noise(float t, int l) {
        int tInt = (int)t;
        int t_1 = tInt - 1;
        if (t_1 < 0) {
            t_1 += l;
        }
        return HermiteSpline.getValue(t - (float)tInt, this.getG(t_1), this.getG(tInt, l), this.getG(tInt + 1, l), this.getG(tInt + 2, l));
    }
}

