/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat4f;

public final class MatrixMath {
    private MatrixMath() {
    }

    public static void getNormalVector(float[] p, float[] q, float[] r, float[] c) {
        float u0 = q[0] - p[0];
        float u1 = q[1] - p[1];
        float u2 = q[2] - p[2];
        float v0 = r[0] - p[0];
        float v1 = r[1] - p[1];
        float v2 = r[2] - p[2];
        c[0] = u1 * v2 - u2 * v1;
        c[1] = u2 * v0 - u0 * v2;
        c[2] = u0 * v1 - u1 * v0;
        double clen = Math.sqrt(c[0] * c[0] + c[1] * c[1] + c[2] * c[2]);
        c[0] = (float)((double)c[0] / clen);
        c[1] = (float)((double)c[1] / clen);
        c[2] = (float)((double)c[2] / clen);
    }

    public static void getPlane(float[] p1, float[] p2, float[] p3, float[] plane) {
        MatrixMath.getNormalVector(p1, p2, p3, plane);
        plane[3] = -(plane[0] * p3[0] + plane[1] * p3[1] + plane[2] * p3[2]);
    }

    public static float distanceToPlane(float[] p, float[] plane) {
        return p[0] * plane[0] + p[1] * plane[1] + p[2] * plane[2] + plane[3];
    }

    public static void makeShadowMatrix(float[][] vPoints, float[] vLightPos, float[] destMat) {
        float[] plane = new float[4];
        MatrixMath.getPlane(vPoints[0], vPoints[1], vPoints[2], plane);
        float dot = plane[0] * vLightPos[0] + plane[1] * vLightPos[1] + plane[2] * vLightPos[2] + plane[3] * vLightPos[3];
        destMat[0] = dot - vLightPos[0] * plane[0];
        destMat[4] = 0.0f - vLightPos[0] * plane[1];
        destMat[8] = 0.0f - vLightPos[0] * plane[2];
        destMat[12] = 0.0f - vLightPos[0] * plane[3];
        destMat[1] = 0.0f - vLightPos[1] * plane[0];
        destMat[5] = dot - vLightPos[1] * plane[1];
        destMat[9] = 0.0f - vLightPos[1] * plane[2];
        destMat[13] = 0.0f - vLightPos[1] * plane[3];
        destMat[2] = 0.0f - vLightPos[2] * plane[0];
        destMat[6] = 0.0f - vLightPos[2] * plane[1];
        destMat[10] = dot - vLightPos[2] * plane[2];
        destMat[14] = 0.0f - vLightPos[2] * plane[3];
        destMat[3] = 0.0f - vLightPos[3] * plane[0];
        destMat[7] = 0.0f - vLightPos[3] * plane[1];
        destMat[11] = 0.0f - vLightPos[3] * plane[2];
        destMat[15] = dot - vLightPos[3] * plane[3];
        Mat4f.transpose(destMat);
    }
}

