/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat3f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.math.Vec4f;

public final class Mat4f {
    public static final int ROW_SIZE = 4;
    public static final int COL_SIZE = 4;
    public static final int MAT4F_SIZE = 16;
    public static final int M00 = 0;
    public static final int M01 = 1;
    public static final int M02 = 2;
    public static final int M03 = 3;
    public static final int M10 = 4;
    public static final int M11 = 5;
    public static final int M12 = 6;
    public static final int M13 = 7;
    public static final int M20 = 8;
    public static final int M21 = 9;
    public static final int M22 = 10;
    public static final int M23 = 11;
    public static final int M30 = 12;
    public static final int M31 = 13;
    public static final int M32 = 14;
    public static final int M33 = 15;
    public static final float DEGTORADF = (float)Math.PI / 180;
    public static final float[] ID = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final int BUFSIZE = 200;

    private Mat4f() {
    }

    public static float[] getMat4f() {
        return new float[16];
    }

    public static void scale(float[] m, float s) {
        m[0] = m[0] * s;
        m[1] = m[1] * s;
        m[2] = m[2] * s;
        m[4] = m[4] * s;
        m[5] = m[5] * s;
        m[6] = m[6] * s;
        m[8] = m[8] * s;
        m[9] = m[9] * s;
        m[10] = m[10] * s;
    }

    public static void nonUniformScale(float[] m, float[] scale) {
        m[0] = m[0] * scale[0];
        m[1] = m[1] * scale[1];
        m[2] = m[2] * scale[2];
        m[4] = m[4] * scale[0];
        m[5] = m[5] * scale[1];
        m[6] = m[6] * scale[2];
        m[8] = m[8] * scale[0];
        m[9] = m[9] * scale[1];
        m[10] = m[10] * scale[2];
    }

    public static float[] getScalingMatrix(float[] s) {
        return new float[]{s[0], 0.0f, 0.0f, 0.0f, 0.0f, s[1], 0.0f, 0.0f, 0.0f, 0.0f, s[2], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] getTranslationMatrix(float[] t) {
        return new float[]{1.0f, 0.0f, 0.0f, t[0], 0.0f, 1.0f, 0.0f, t[1], 0.0f, 0.0f, 1.0f, t[2], 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] getSkewMatrix(float angle, float[] rvec, float[] tvec) {
        return Mat4f.getSkewMatrix(null, angle, rvec, tvec);
    }

    public static float[] getSkewMatrix(float[] matrix, float angle, float[] rvec, float[] tvec) {
        if (matrix == null) {
            matrix = new float[16];
        }
        Mat3f.getSkewMatrix(matrix, angle, rvec, tvec);
        Mat4f.convertTo4x4(matrix);
        return matrix;
    }

    public static float[] getLookAtMatrix(float[] eyePos, float[] centerPos, float[] upVec) {
        float[] matrix = new float[16];
        float[] f = Vec3f.getVec3f();
        Vec3f.sub(f, centerPos, eyePos);
        Vec3f.normalize(f);
        float[] upn = Vec3f.getVec3f();
        Vec3f.set(upn, upVec);
        Vec3f.normalize(upn);
        float[] s = Vec3f.getVec3f();
        Vec3f.cross(s, f, upn);
        float[] u = Vec3f.getVec3f();
        Vec3f.cross(u, s, f);
        Mat4f.set(matrix, s[0], s[1], s[2], -eyePos[0], u[0], u[1], u[2], -eyePos[1], -f[0], -f[1], -f[2], -eyePos[2], 0.0f, 0.0f, 0.0f, 1.0f);
        return matrix;
    }

    public static float[] from3x3(float[] m3x3) {
        float[] m4x4 = new float[16];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                m4x4[4 * i + j] = m3x3[3 * i + j];
            }
        }
        m4x4[15] = 1.0f;
        return m4x4;
    }

    public static void convertTo4x4(float[] m) {
        m[10] = m[8];
        m[9] = m[7];
        m[8] = m[6];
        m[6] = m[5];
        m[5] = m[4];
        m[4] = m[3];
        m[3] = 0.0f;
        m[7] = 0.0f;
        m[11] = 0.0f;
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
    }

    public static void set(float[] dst, int dstIndex, float[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, dst, dstIndex, 16);
    }

    public static void set(float[] dst, float[] src) {
        System.arraycopy(src, 0, dst, 0, 16);
    }

    public static void set(float[] dst, float src00, float src01, float src02, float src03, float src10, float src11, float src12, float src13, float src20, float src21, float src22, float src23, float src30, float src31, float src32, float src33) {
        dst[0] = src00;
        dst[4] = src10;
        dst[8] = src20;
        dst[12] = src30;
        dst[1] = src01;
        dst[5] = src11;
        dst[9] = src21;
        dst[13] = src31;
        dst[2] = src02;
        dst[6] = src12;
        dst[10] = src22;
        dst[14] = src32;
        dst[3] = src03;
        dst[7] = src13;
        dst[11] = src23;
        dst[15] = src33;
    }

    public static void setFromTRCS(float[] m, float[] t, float[] q, float[] c, float uscale) {
        Mat4f.setFromTRCSVec3f(m, t, q, c, new float[]{uscale, uscale, uscale});
    }

    public static void setFromTRCSVec3f(float[] m, float[] t, float[] q, float[] c, float[] s) {
        m[0] = s[0] * (1.0f - 2.0f * q[2] * q[2] - 2.0f * q[3] * q[3]);
        m[1] = s[1] * (2.0f * q[1] * q[2] - 2.0f * q[0] * q[3]);
        m[2] = s[2] * (2.0f * q[0] * q[2] + 2.0f * q[1] * q[3]);
        m[4] = s[0] * (2.0f * q[1] * q[2] + 2.0f * q[0] * q[3]);
        m[5] = s[1] * (1.0f - 2.0f * q[1] * q[1] - 2.0f * q[3] * q[3]);
        m[6] = s[2] * (-2.0f * q[0] * q[1] + 2.0f * q[2] * q[3]);
        m[8] = s[0] * (-2.0f * q[0] * q[2] + 2.0f * q[1] * q[3]);
        m[9] = s[1] * (2.0f * q[0] * q[1] + 2.0f * q[2] * q[3]);
        m[10] = s[2] * (1.0f - 2.0f * q[1] * q[1] - 2.0f * q[2] * q[2]);
        m[3] = t[0] + c[0] - m[0] * c[0] - m[1] * c[1] - m[2] * c[2];
        m[7] = t[1] + c[1] - m[4] * c[0] - m[5] * c[1] - m[6] * c[2];
        m[11] = t[2] + c[2] - m[8] * c[0] - m[9] * c[1] - m[10] * c[2];
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
    }

    public static void setFromTRSMat3f(float[] m, float[] t, float[] q, float[] smatrix) {
        float rr0 = 1.0f - 2.0f * q[2] * q[2] - 2.0f * q[3] * q[3];
        float rr1 = 2.0f * q[1] * q[2] - 2.0f * q[0] * q[3];
        float rr2 = 2.0f * q[0] * q[2] + 2.0f * q[1] * q[3];
        m[0] = smatrix[0] * rr0 + smatrix[3] * rr1 + smatrix[6] * rr2;
        m[1] = smatrix[1] * rr0 + smatrix[4] * rr1 + smatrix[7] * rr2;
        m[2] = smatrix[2] * rr0 + smatrix[5] * rr1 + smatrix[8] * rr2;
        rr0 = 2.0f * q[1] * q[2] + 2.0f * q[0] * q[3];
        rr1 = 1.0f - 2.0f * q[1] * q[1] - 2.0f * q[3] * q[3];
        rr2 = -2.0f * q[0] * q[1] + 2.0f * q[2] * q[3];
        m[4] = smatrix[0] * rr0 + smatrix[3] * rr1 + smatrix[6] * rr2;
        m[5] = smatrix[1] * rr0 + smatrix[4] * rr1 + smatrix[7] * rr2;
        m[6] = smatrix[2] * rr0 + smatrix[5] * rr1 + smatrix[8] * rr2;
        rr0 = -2.0f * q[0] * q[2] + 2.0f * q[1] * q[3];
        rr1 = 2.0f * q[0] * q[1] + 2.0f * q[2] * q[3];
        rr2 = 1.0f - 2.0f * q[1] * q[1] - 2.0f * q[2] * q[2];
        m[8] = smatrix[0] * rr0 + smatrix[3] * rr1 + smatrix[6] * rr2;
        m[9] = smatrix[1] * rr0 + smatrix[4] * rr1 + smatrix[7] * rr2;
        m[10] = smatrix[2] * rr0 + smatrix[5] * rr1 + smatrix[8] * rr2;
        m[3] = t[0];
        m[7] = t[1];
        m[11] = t[2];
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
    }

    public static void setFromTRSVec3f(float[] m, float[] t, float[] q, float[] s) {
        m[0] = s[0] * (1.0f - 2.0f * q[2] * q[2] - 2.0f * q[3] * q[3]);
        m[1] = s[1] * (2.0f * q[1] * q[2] - 2.0f * q[0] * q[3]);
        m[2] = s[2] * (2.0f * q[0] * q[2] + 2.0f * q[1] * q[3]);
        m[4] = s[0] * (2.0f * q[1] * q[2] + 2.0f * q[0] * q[3]);
        m[5] = s[1] * (1.0f - 2.0f * q[1] * q[1] - 2.0f * q[3] * q[3]);
        m[6] = s[2] * (-2.0f * q[0] * q[1] + 2.0f * q[2] * q[3]);
        m[8] = s[0] * (-2.0f * q[0] * q[2] + 2.0f * q[1] * q[3]);
        m[9] = s[1] * (2.0f * q[0] * q[1] + 2.0f * q[2] * q[3]);
        m[10] = s[2] * (1.0f - 2.0f * q[1] * q[1] - 2.0f * q[2] * q[2]);
        m[3] = t[0];
        m[7] = t[1];
        m[11] = t[2];
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
    }

    public static void setFromTRS(float[] m, float[] t, float[] q, float uscale) {
        m[0] = uscale * (1.0f - 2.0f * q[2] * q[2] - 2.0f * q[3] * q[3]);
        m[1] = uscale * (2.0f * q[1] * q[2] - 2.0f * q[0] * q[3]);
        m[2] = uscale * (2.0f * q[0] * q[2] + 2.0f * q[1] * q[3]);
        m[4] = uscale * (2.0f * q[1] * q[2] + 2.0f * q[0] * q[3]);
        m[5] = uscale * (1.0f - 2.0f * q[1] * q[1] - 2.0f * q[3] * q[3]);
        m[6] = uscale * (-2.0f * q[0] * q[1] + 2.0f * q[2] * q[3]);
        m[8] = uscale * (-2.0f * q[0] * q[2] + 2.0f * q[1] * q[3]);
        m[9] = uscale * (2.0f * q[0] * q[1] + 2.0f * q[2] * q[3]);
        m[10] = uscale * (1.0f - 2.0f * q[1] * q[1] - 2.0f * q[2] * q[2]);
        m[3] = t[0];
        m[7] = t[1];
        m[11] = t[2];
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
    }

    public static void setFromTR(float[] m, float[] t, float[] q) {
        m[0] = 1.0f - 2.0f * q[2] * q[2] - 2.0f * q[3] * q[3];
        m[1] = 2.0f * q[1] * q[2] - 2.0f * q[0] * q[3];
        m[2] = 2.0f * q[0] * q[2] + 2.0f * q[1] * q[3];
        m[4] = 2.0f * q[1] * q[2] + 2.0f * q[0] * q[3];
        m[5] = 1.0f - 2.0f * q[1] * q[1] - 2.0f * q[3] * q[3];
        m[6] = -2.0f * q[0] * q[1] + 2.0f * q[2] * q[3];
        m[8] = -2.0f * q[0] * q[2] + 2.0f * q[1] * q[3];
        m[9] = 2.0f * q[0] * q[1] + 2.0f * q[2] * q[3];
        m[10] = 1.0f - 2.0f * q[1] * q[1] - 2.0f * q[2] * q[2];
        m[3] = t[0];
        m[7] = t[1];
        m[11] = t[2];
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
    }

    public static void setRotationScaleVec3f(float[] m, float[] q, float[] s) {
        m[0] = s[0] * (1.0f - 2.0f * q[2] * q[2] - 2.0f * q[3] * q[3]);
        m[1] = s[1] * (2.0f * q[1] * q[2] - 2.0f * q[0] * q[3]);
        m[2] = s[2] * (2.0f * q[0] * q[2] + 2.0f * q[1] * q[3]);
        m[4] = s[0] * (2.0f * q[1] * q[2] + 2.0f * q[0] * q[3]);
        m[5] = s[1] * (1.0f - 2.0f * q[1] * q[1] - 2.0f * q[3] * q[3]);
        m[6] = s[2] * (-2.0f * q[0] * q[1] + 2.0f * q[2] * q[3]);
        m[8] = s[0] * (-2.0f * q[0] * q[2] + 2.0f * q[1] * q[3]);
        m[9] = s[1] * (2.0f * q[0] * q[1] + 2.0f * q[2] * q[3]);
        m[10] = s[2] * (1.0f - 2.0f * q[1] * q[1] - 2.0f * q[2] * q[2]);
    }

    public static void setRotation(float[] m, int mIndex, float[] q, int qIndex) {
        m[0 + mIndex] = 1.0f - 2.0f * q[2 + qIndex] * q[2 + qIndex] - 2.0f * q[3 + qIndex] * q[3 + qIndex];
        m[1 + mIndex] = 2.0f * q[1 + qIndex] * q[2 + qIndex] - 2.0f * q[0 + qIndex] * q[3 + qIndex];
        m[2 + mIndex] = 2.0f * q[0 + qIndex] * q[2 + qIndex] + 2.0f * q[1 + qIndex] * q[3 + qIndex];
        m[4 + mIndex] = 2.0f * q[1 + qIndex] * q[2 + qIndex] + 2.0f * q[0 + qIndex] * q[3 + qIndex];
        m[5 + mIndex] = 1.0f - 2.0f * q[1 + qIndex] * q[1 + qIndex] - 2.0f * q[3 + qIndex] * q[3 + qIndex];
        m[6 + mIndex] = -2.0f * q[0 + qIndex] * q[1 + qIndex] + 2.0f * q[2 + qIndex] * q[3 + qIndex];
        m[8 + mIndex] = -2.0f * q[0 + qIndex] * q[2 + qIndex] + 2.0f * q[1 + qIndex] * q[3 + qIndex];
        m[9 + mIndex] = 2.0f * q[0 + qIndex] * q[1 + qIndex] + 2.0f * q[2 + qIndex] * q[3 + qIndex];
        m[10 + mIndex] = 1.0f - 2.0f * q[1 + qIndex] * q[1 + qIndex] - 2.0f * q[2 + qIndex] * q[2 + qIndex];
    }

    public static void setRotation(float[] m, float[] q) {
        m[0] = 1.0f - 2.0f * q[2] * q[2] - 2.0f * q[3] * q[3];
        m[1] = 2.0f * q[1] * q[2] - 2.0f * q[0] * q[3];
        m[2] = 2.0f * q[0] * q[2] + 2.0f * q[1] * q[3];
        m[4] = 2.0f * q[1] * q[2] + 2.0f * q[0] * q[3];
        m[5] = 1.0f - 2.0f * q[1] * q[1] - 2.0f * q[3] * q[3];
        m[6] = -2.0f * q[0] * q[1] + 2.0f * q[2] * q[3];
        m[8] = -2.0f * q[0] * q[2] + 2.0f * q[1] * q[3];
        m[9] = 2.0f * q[0] * q[1] + 2.0f * q[2] * q[3];
        m[10] = 1.0f - 2.0f * q[1] * q[1] - 2.0f * q[2] * q[2];
    }

    public static void clearRotationScale(float[] m) {
        m[0] = 1.0f;
        m[1] = 0.0f;
        m[2] = 0.0f;
        m[4] = 0.0f;
        m[5] = 1.0f;
        m[6] = 0.0f;
        m[8] = 0.0f;
        m[9] = 0.0f;
        m[10] = 1.0f;
    }

    public static void setXRot(float[] m, float angle) {
        float ca = (float)Math.cos(angle);
        float sa = (float)Math.sin(angle);
        m[0] = 1.0f;
        m[1] = 0.0f;
        m[2] = 0.0f;
        m[4] = 0.0f;
        m[5] = ca;
        m[6] = -sa;
        m[8] = 0.0f;
        m[9] = sa;
        m[10] = ca;
    }

    public static void setXRotDegrees(float[] m, float degrees) {
        Mat4f.setXRot(m, (float)Math.toRadians(degrees));
    }

    public static void setYRot(float[] m, float angle) {
        float ca = (float)Math.cos(angle);
        float sa = (float)Math.sin(angle);
        m[0] = ca;
        m[1] = 0.0f;
        m[2] = sa;
        m[4] = 0.0f;
        m[5] = 1.0f;
        m[6] = 0.0f;
        m[8] = -sa;
        m[9] = 0.0f;
        m[10] = ca;
    }

    public static void setYRotDegrees(float[] m, float angle) {
        Mat4f.setYRot(m, (float)Math.toRadians(angle));
    }

    public static void setZRot(float[] m, float angle) {
        float ca = (float)Math.cos(angle);
        float sa = (float)Math.sin(angle);
        m[0] = ca;
        m[1] = -sa;
        m[2] = 0.0f;
        m[4] = sa;
        m[5] = ca;
        m[6] = 0.0f;
        m[8] = 0.0f;
        m[9] = 0.0f;
        m[10] = 1.0f;
    }

    public static void setZRotDegrees(float[] m, float angle) {
        Mat4f.setZRot(m, (float)Math.toRadians(angle));
    }

    public static void setRotationFromAxisAngleDegrees(float[] m, float[] axis, float degrees) {
        float[] aa = Vec3f.getVec3f();
        Vec3f.set(aa, axis);
        Vec3f.normalize(aa);
        Mat4f.setRotationFromAxisAngle(m, aa, degrees * ((float)Math.PI / 180));
    }

    public static void setRotationFromAxisAngle4f(float[] m, float[] axisangle) {
        Mat4f.setRotationFromAxisAngle(m, axisangle, axisangle[3]);
    }

    public static void setRotationFromAxisAngle(float[] m, float[] axis, float angle) {
        float qs = (float)Math.cos((double)angle / 2.0);
        float sn = (float)Math.sin((double)angle / 2.0);
        float qx = axis[0] * sn;
        float qy = axis[1] * sn;
        float qz = axis[2] * sn;
        m[0] = (float)(1.0 - 2.0 * (double)qy * (double)qy - 2.0 * (double)qz * (double)qz);
        m[1] = (float)(2.0 * (double)qx * (double)qy - 2.0 * (double)qs * (double)qz);
        m[2] = (float)(2.0 * (double)qs * (double)qy + 2.0 * (double)qx * (double)qz);
        m[4] = (float)(2.0 * (double)qx * (double)qy + 2.0 * (double)qs * (double)qz);
        m[5] = (float)(1.0 - 2.0 * (double)qx * (double)qx - 2.0 * (double)qz * (double)qz);
        m[6] = (float)(-2.0 * (double)qs * (double)qx + 2.0 * (double)qy * (double)qz);
        m[8] = (float)(-2.0 * (double)qs * (double)qy + 2.0 * (double)qx * (double)qz);
        m[9] = (float)(2.0 * (double)qs * (double)qx + 2.0 * (double)qy * (double)qz);
        m[10] = (float)(1.0 - 2.0 * (double)qx * (double)qx - 2.0 * (double)qy * (double)qy);
    }

    public static void setTranslation(float[] m, float[] t) {
        m[3] = t[0];
        m[7] = t[1];
        m[11] = t[2];
    }

    public static void getTranslation(float[] t, float[] m) {
        t[0] = m[3];
        t[1] = m[7];
        t[2] = m[11];
    }

    public static void setZero(float[] m) {
        for (int i = 0; i < 16; ++i) {
            m[i] = 0.0f;
        }
    }

    public static void setIdentity(float[] m) {
        for (int i = 1; i < 15; ++i) {
            m[i] = 0.0f;
        }
        m[0] = 1.0f;
        m[5] = 1.0f;
        m[10] = 1.0f;
        m[15] = 1.0f;
    }

    public static float[] getIdentity() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static boolean isIdentity(float[] m) {
        return m[0] == 1.0f && m[1] == 0.0f && m[2] == 0.0f && m[3] == 0.0f && m[4] == 0.0f && m[5] == 1.0f && m[6] == 0.0f && m[7] == 0.0f && m[8] == 0.0f && m[9] == 0.0f && m[10] == 1.0f && m[11] == 0.0f && m[12] == 0.0f && m[13] == 0.0f && m[14] == 0.0f && m[15] == 1.0f;
    }

    public static boolean isZero(float[] m) {
        return m[0] == 0.0f && m[1] == 0.0f && m[2] == 0.0f && m[3] == 0.0f && m[4] == 0.0f && m[5] == 0.0f && m[6] == 0.0f && m[7] == 0.0f && m[8] == 0.0f && m[9] == 0.0f && m[10] == 0.0f && m[11] == 0.0f && m[12] == 0.0f && m[13] == 0.0f && m[14] == 0.0f && m[15] == 0.0f;
    }

    public static void setElement(float[] m, int i, int j, float value) {
        m[4 * i + j] = value;
    }

    public static float getElement(float[] m, int i, int j) {
        return m[4 * i + j];
    }

    public static void getRow(float[] m, int i, float[] row) {
        int offset = 4 * i;
        row[0] = m[offset];
        row[1] = m[offset + 1];
        row[2] = m[offset + 2];
        row[3] = m[offset + 3];
    }

    public static void getColumn(float[] m, int j, float[] col) {
        col[0] = m[j];
        col[1] = m[j + 4];
        col[2] = m[j + 8];
        col[3] = m[j + 12];
    }

    public static void mul(float[] dest, float[] m) {
        Mat4f.mul(dest, dest, m);
    }

    public static void mul(float[] dest, float[] a, float[] b) {
        float mt00 = a[0] * b[0] + a[1] * b[4] + a[2] * b[8] + a[3] * b[12];
        float mt01 = a[0] * b[1] + a[1] * b[5] + a[2] * b[9] + a[3] * b[13];
        float mt02 = a[0] * b[2] + a[1] * b[6] + a[2] * b[10] + a[3] * b[14];
        float mt03 = a[0] * b[3] + a[1] * b[7] + a[2] * b[11] + a[3] * b[15];
        float mt10 = a[4] * b[0] + a[5] * b[4] + a[6] * b[8] + a[7] * b[12];
        float mt11 = a[4] * b[1] + a[5] * b[5] + a[6] * b[9] + a[7] * b[13];
        float mt12 = a[4] * b[2] + a[5] * b[6] + a[6] * b[10] + a[7] * b[14];
        float mt13 = a[4] * b[3] + a[5] * b[7] + a[6] * b[11] + a[7] * b[15];
        float mt20 = a[8] * b[0] + a[9] * b[4] + a[10] * b[8] + a[11] * b[12];
        float mt21 = a[8] * b[1] + a[9] * b[5] + a[10] * b[9] + a[11] * b[13];
        float mt22 = a[8] * b[2] + a[9] * b[6] + a[10] * b[10] + a[11] * b[14];
        float mt23 = a[8] * b[3] + a[9] * b[7] + a[10] * b[11] + a[11] * b[15];
        float mt30 = a[12] * b[0] + a[13] * b[4] + a[14] * b[8] + a[15] * b[12];
        float mt31 = a[12] * b[1] + a[13] * b[5] + a[14] * b[9] + a[15] * b[13];
        float mt32 = a[12] * b[2] + a[13] * b[6] + a[14] * b[10] + a[15] * b[14];
        float mt33 = a[12] * b[3] + a[13] * b[7] + a[14] * b[11] + a[15] * b[15];
        dest[0] = mt00;
        dest[1] = mt01;
        dest[2] = mt02;
        dest[3] = mt03;
        dest[4] = mt10;
        dest[5] = mt11;
        dest[6] = mt12;
        dest[7] = mt13;
        dest[8] = mt20;
        dest[9] = mt21;
        dest[10] = mt22;
        dest[11] = mt23;
        dest[12] = mt30;
        dest[13] = mt31;
        dest[14] = mt32;
        dest[15] = mt33;
    }

    public static void mul3x4(float[] dest, float[] a, float[] b) {
        float mt00 = a[0] * b[0] + a[1] * b[4] + a[2] * b[8];
        float mt01 = a[0] * b[1] + a[1] * b[5] + a[2] * b[9];
        float mt02 = a[0] * b[2] + a[1] * b[6] + a[2] * b[10];
        float mt03 = a[0] * b[3] + a[1] * b[7] + a[2] * b[11] + a[3];
        float mt10 = a[4] * b[0] + a[5] * b[4] + a[6] * b[8];
        float mt11 = a[4] * b[1] + a[5] * b[5] + a[6] * b[9];
        float mt12 = a[4] * b[2] + a[5] * b[6] + a[6] * b[10];
        float mt13 = a[4] * b[3] + a[5] * b[7] + a[6] * b[11] + a[7];
        float mt20 = a[8] * b[0] + a[9] * b[4] + a[10] * b[8];
        float mt21 = a[8] * b[1] + a[9] * b[5] + a[10] * b[9];
        float mt22 = a[8] * b[2] + a[9] * b[6] + a[10] * b[10];
        float mt23 = a[8] * b[3] + a[9] * b[7] + a[10] * b[11] + a[11];
        dest[0] = mt00;
        dest[1] = mt01;
        dest[2] = mt02;
        dest[3] = mt03;
        dest[4] = mt10;
        dest[5] = mt11;
        dest[6] = mt12;
        dest[7] = mt13;
        dest[8] = mt20;
        dest[9] = mt21;
        dest[10] = mt22;
        dest[11] = mt23;
    }

    public static void mul3x4(float[] dest, float[] a) {
        Mat4f.mul3x4(dest, dest, a);
    }

    public static void transformVec4f(float[] m, int mIndex, float[] dest, int destIndex, float[] src, int srcIndex) {
        float vx = m[mIndex + 0] * src[srcIndex] + m[mIndex + 1] * src[srcIndex + 1] + m[mIndex + 2] * src[srcIndex + 2] + m[mIndex + 3] * src[srcIndex + 3];
        float vy = m[mIndex + 4] * src[srcIndex] + m[mIndex + 5] * src[srcIndex + 1] + m[mIndex + 6] * src[srcIndex + 2] + m[mIndex + 7] * src[srcIndex + 3];
        float vz = m[mIndex + 8] * src[srcIndex] + m[mIndex + 9] * src[srcIndex + 1] + m[mIndex + 10] * src[srcIndex + 2] + m[mIndex + 11] * src[srcIndex + 3];
        float vw = m[mIndex + 12] * src[srcIndex] + m[mIndex + 13] * src[srcIndex + 1] + m[mIndex + 14] * src[srcIndex + 2] + m[mIndex + 15] * src[srcIndex + 3];
        dest[destIndex] = vx;
        dest[destIndex + 1] = vy;
        dest[destIndex + 2] = vz;
        dest[destIndex + 3] = vw;
    }

    public static void transformVec4f(float[] m, float[] dest, float[] src) {
        float vx = m[0] * src[0] + m[1] * src[1] + m[2] * src[2] + m[3] * src[3];
        float vy = m[4] * src[0] + m[5] * src[1] + m[6] * src[2] + m[7] * src[3];
        float vz = m[8] * src[0] + m[9] * src[1] + m[10] * src[2] + m[11] * src[3];
        float vw = m[12] * src[0] + m[13] * src[1] + m[14] * src[2] + m[15] * src[3];
        dest[0] = vx;
        dest[1] = vy;
        dest[2] = vz;
        dest[3] = vw;
    }

    public static void transformVec4f(float[] m, float[] dest) {
        Mat4f.transformVec4f(m, dest, dest);
    }

    @Deprecated
    public static void transformVec3f(float[] m, float[] dest) {
        Mat4f.transformPoint(m, dest, dest);
    }

    @Deprecated
    public static void transformVec3f(float[] m, float[] dest, int dstIndex) {
        Mat4f.transformPoint(m, dest, dstIndex);
    }

    @Deprecated
    public static void transformVec3f(float[] m, float[] dest, float[] src) {
        Mat4f.transformPoint(m, dest, src);
    }

    public static void transformPoint(float[] m, float[] dest, float[] src) {
        float vx = m[0] * src[0] + m[1] * src[1] + m[2] * src[2] + m[3];
        float vy = m[4] * src[0] + m[5] * src[1] + m[6] * src[2] + m[7];
        float vz = m[8] * src[0] + m[9] * src[1] + m[10] * src[2] + m[11];
        dest[0] = vx;
        dest[1] = vy;
        dest[2] = vz;
    }

    public static void transformPoint(float[] m, float[] dest) {
        Mat4f.transformPoint(m, dest, dest);
    }

    public static void transformPoint(float[] m, float[] dest, int destIndex) {
        float vx = m[0] * dest[destIndex] + m[1] * dest[destIndex + 1] + m[2] * dest[destIndex + 2] + m[3];
        float vy = m[4] * dest[destIndex] + m[5] * dest[destIndex + 1] + m[6] * dest[destIndex + 2] + m[7];
        float vz = m[8] * dest[destIndex] + m[9] * dest[destIndex + 1] + m[10] * dest[destIndex + 2] + m[11];
        dest[destIndex] = vx;
        dest[destIndex + 1] = vy;
        dest[destIndex + 2] = vz;
    }

    public static void transformVector(float[] m, float[] dest, float[] src) {
        float vx = m[0] * src[0] + m[1] * src[1] + m[2] * src[2];
        float vy = m[4] * src[0] + m[5] * src[1] + m[6] * src[2];
        float vz = m[8] * src[0] + m[9] * src[1] + m[10] * src[2];
        dest[0] = vx;
        dest[1] = vy;
        dest[2] = vz;
    }

    public static void transformVector(float[] m, float[] dest) {
        Mat4f.transformVector(m, dest, dest);
    }

    public static void transformVector(float[] m, float[] dest, int destIndex) {
        float vx = m[0] * dest[destIndex] + m[1] * dest[destIndex + 1] + m[2] * dest[destIndex + 2];
        float vy = m[4] * dest[destIndex] + m[5] * dest[destIndex + 1] + m[6] * dest[destIndex + 2];
        float vz = m[8] * dest[destIndex] + m[9] * dest[destIndex + 1] + m[10] * dest[destIndex + 2];
        dest[destIndex] = vx;
        dest[destIndex + 1] = vy;
        dest[destIndex + 2] = vz;
    }

    public static void transformAffineMatrix(float[] m, float[] destMat) {
        float[] minv = new float[16];
        Mat4f.invertAffine(minv, m);
        Mat4f.mul3x4(destMat, m, destMat);
        Mat4f.mul3x4(destMat, minv);
    }

    public static void transformAffineMatrix(float[] m, float[] minv, float[] destMat, float[] srcMat) {
        Mat4f.mul3x4(destMat, m, srcMat);
        Mat4f.mul3x4(destMat, minv);
    }

    public static void transformAffineMatrix(float[] m, float[] destMat, float[] srcMat) {
        float[] minv = new float[16];
        Mat4f.invertAffine(minv, m);
        Mat4f.mul3x4(destMat, m, srcMat);
        Mat4f.mul3x4(destMat, minv);
    }

    public static void transpose(float[] dest, float[] m) {
        dest[0] = m[0];
        dest[5] = m[5];
        dest[10] = m[10];
        dest[15] = m[15];
        float tmp = m[1];
        dest[1] = m[4];
        dest[4] = tmp;
        tmp = m[2];
        dest[2] = m[8];
        dest[8] = tmp;
        tmp = m[3];
        dest[3] = m[12];
        dest[12] = tmp;
        tmp = m[6];
        dest[6] = m[9];
        dest[9] = tmp;
        tmp = m[7];
        dest[7] = m[13];
        dest[13] = tmp;
        tmp = m[11];
        dest[11] = m[14];
        dest[14] = tmp;
    }

    public static void transpose(float[] m) {
        float tmp = m[1];
        m[1] = m[4];
        m[4] = tmp;
        tmp = m[2];
        m[2] = m[8];
        m[8] = tmp;
        tmp = m[3];
        m[3] = m[12];
        m[12] = tmp;
        tmp = m[6];
        m[6] = m[9];
        m[9] = tmp;
        tmp = m[7];
        m[7] = m[13];
        m[13] = tmp;
        tmp = m[11];
        m[11] = m[14];
        m[14] = tmp;
    }

    public static void invertRigid(float[] dest, float[] m) {
        dest[0] = m[0];
        dest[5] = m[5];
        dest[10] = m[10];
        float tmp = m[1];
        dest[1] = m[4];
        dest[4] = tmp;
        tmp = m[2];
        dest[2] = m[8];
        dest[8] = tmp;
        tmp = m[6];
        dest[6] = m[9];
        dest[9] = tmp;
        float vx = m[3];
        float vy = m[7];
        float vz = m[11];
        dest[3] = -dest[0] * vx - dest[1] * vy - dest[2] * vz;
        dest[7] = -dest[4] * vx - dest[5] * vy - dest[6] * vz;
        dest[11] = -dest[8] * vx - dest[9] * vy - dest[10] * vz;
        dest[12] = 0.0f;
        dest[13] = 0.0f;
        dest[14] = 0.0f;
        dest[15] = 1.0f;
    }

    public static void invertRigid(float[] m) {
        Mat4f.invertRigid(m, m);
    }

    public static float invertAffine(float[] dest, float[] m) {
        if (m[12] != 0.0f || m[13] != 0.0f || m[14] != 0.0f || m[15] != 1.0f) {
            throw new IllegalArgumentException("Mat4f.invertAffine called for non-affine matrix: " + Mat4f.toString(m));
        }
        dest[0] = m[10] * m[5] - m[9] * m[6];
        dest[1] = -m[10] * m[1] + m[9] * m[2];
        dest[2] = m[6] * m[1] - m[5] * m[2];
        dest[4] = -m[10] * m[4] + m[8] * m[6];
        dest[5] = m[10] * m[0] - m[8] * m[2];
        dest[6] = -m[6] * m[0] + m[4] * m[2];
        dest[8] = m[9] * m[4] - m[8] * m[5];
        dest[9] = -m[9] * m[0] + m[8] * m[1];
        dest[10] = m[5] * m[0] - m[4] * m[1];
        float det = m[0] * dest[0] + m[1] * dest[4] + m[2] * dest[8];
        float detinv = 1.0f / det;
        dest[0] = dest[0] * detinv;
        dest[1] = dest[1] * detinv;
        dest[2] = dest[2] * detinv;
        dest[4] = dest[4] * detinv;
        dest[5] = dest[5] * detinv;
        dest[6] = dest[6] * detinv;
        dest[8] = dest[8] * detinv;
        dest[9] = dest[9] * detinv;
        dest[10] = dest[10] * detinv;
        dest[3] = -dest[0] * m[3] - dest[1] * m[7] - dest[2] * m[11];
        dest[7] = -dest[4] * m[3] - dest[5] * m[7] - dest[6] * m[11];
        dest[11] = -dest[8] * m[3] - dest[9] * m[7] - dest[10] * m[11];
        dest[12] = 0.0f;
        dest[13] = 0.0f;
        dest[14] = 0.0f;
        dest[15] = 1.0f;
        return det;
    }

    public static boolean equals(float[] a, float[] b) {
        for (int i = 0; i < 16; ++i) {
            float diff = a[i] - b[i];
            if (Float.isNaN(diff)) {
                return false;
            }
            if (diff == 0.0f) continue;
            return false;
        }
        return true;
    }

    public static boolean epsilonEquals(float[] a, float[] b, float epsilon) {
        for (int i = 0; i < 16; ++i) {
            float diff = a[i] - b[i];
            if (Float.isNaN(diff)) {
                return false;
            }
            if (!(Math.abs(diff) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static float dInf(float[] a, float[] b) {
        float max = 0.0f;
        for (int i = 0; i < 16; ++i) {
            float d;
            float f = d = a[i] < b[i] ? b[i] - a[i] : a[i] - b[i];
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static float norm1(float[] m) {
        float sum = 0.0f;
        for (int i = 0; i < 16; ++i) {
            sum += m[i] < 0.0f ? -m[i] : m[i];
        }
        return sum;
    }

    public static float norm2(float[] m) {
        float sum = 0.0f;
        for (int i = 0; i < 16; ++i) {
            sum += m[i] * m[i];
        }
        return (float)Math.sqrt(sum);
    }

    public static float normInf(float[] m) {
        float max = 0.0f;
        for (int i = 0; i < 16; ++i) {
            float mx;
            float f = mx = m[i] < 0.0f ? -m[i] : m[i];
            if (!(mx > max)) continue;
            max = mx;
        }
        return max;
    }

    public static double det(float[] m) {
        double sum = 0.0;
        if (m[12] != 0.0f) {
            sum += (double)(m[12] * (m[1] * (m[6] * m[11] - m[10] * m[7]) + m[2] * (m[9] * m[7] - m[5] * m[11]) + m[3] * (m[5] * m[10] - m[9] * m[6])));
        }
        if (m[13] != 0.0f) {
            sum += (double)(m[13] * (m[0] * (m[6] * m[11] - m[10] * m[7]) + m[2] * (m[8] * m[7] - m[4] * m[11]) + m[3] * (m[4] * m[10] - m[8] * m[6])));
        }
        if (m[14] != 0.0f) {
            sum += (double)(m[14] * (m[0] * (m[5] * m[11] - m[9] * m[7]) + m[1] * (m[8] * m[7] - m[4] * m[11]) + m[3] * (m[4] * m[9] - m[8] * m[5])));
        }
        if (m[15] != 0.0f) {
            sum += (double)(m[15] * (m[0] * (m[5] * m[10] - m[6] * m[9]) + m[1] * (m[6] * m[8] - m[4] * m[10]) + m[2] * (m[4] * m[9] - m[5] * m[8])));
        }
        return sum;
    }

    public static boolean isAffine(float[] matrix) {
        return matrix[12] == 0.0f && matrix[13] == 0.0f && matrix[14] == 0.0f && matrix[15] == 1.0f;
    }

    public static boolean isRigid(float[] m, float epsilon) {
        float ip = m[0] * m[0] + m[4] * m[4] + m[8] * m[8];
        if (Math.abs(ip - 1.0f) > epsilon) {
            return false;
        }
        ip = m[1] * m[1] + m[5] * m[5] + m[9] * m[9];
        if (Math.abs(ip - 1.0f) > epsilon) {
            return false;
        }
        ip = m[2] * m[2] + m[6] * m[6] + m[10] * m[10];
        if (Math.abs(ip - 1.0f) > epsilon) {
            return false;
        }
        ip = m[0] * m[1] + m[4] * m[5] + m[8] * m[9];
        if (Math.abs(ip) > epsilon) {
            return false;
        }
        ip = m[0] * m[2] + m[4] * m[6] + m[8] * m[10];
        if (Math.abs(ip) > epsilon) {
            return false;
        }
        ip = m[1] * m[2] + m[5] * m[6] + m[9] * m[10];
        if (Math.abs(ip) > epsilon) {
            return false;
        }
        return m[12] == 0.0f && m[13] == 0.0f && m[14] == 0.0f && m[15] == 1.0f;
    }

    public static String toString(float[] m) {
        return Mat4f.toString(m, 0);
    }

    public static String toLine(float[] m) {
        StringBuilder buf = new StringBuilder();
        return Mat4f.appendLine(buf, m).toString();
    }

    public static StringBuilder appendLine(StringBuilder buf, float[] m) {
        buf.append(m[0]);
        for (int i = 1; i < 15; ++i) {
            buf.append(' ');
            buf.append(m[i]);
        }
        return buf;
    }

    public static String toString(float[] m, int tab, int fieldwidth, int precision) {
        return Mat4f.toString(m, tab, "%" + fieldwidth + "." + precision + "f");
    }

    public static String toString(float[] m, int tab, String fmt) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            buf.append('\n');
            for (int t = 0; t < tab; ++t) {
                buf.append(' ');
            }
            for (int j = 0; j < 4; ++j) {
                float mval = m[4 * i + j];
                buf.append(String.format(fmt, Float.valueOf(mval)));
                buf.append("  ");
            }
        }
        return buf.toString();
    }

    public static String toString(float[] m, int tab) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            buf.append('\n');
            for (int t = 0; t < tab; ++t) {
                buf.append(' ');
            }
            for (int j = 0; j < 4; ++j) {
                buf.append(m[4 * i + j]);
                buf.append("  ");
            }
        }
        return buf.toString();
    }

    public static double decomposeToTRSMat3f(float[] matrix, float[] translation, float[] rotation, float[] scaleMatrix) {
        Mat4f.getTranslation(translation, matrix);
        float[] m = Mat3f.from4x4(matrix);
        float[] q = Mat3f.getMat3f();
        double det = Mat3f.polarDecompose(m, q, scaleMatrix);
        if (det < 0.0) {
            q[2] = q[2] * -1.0f;
            q[5] = q[5] * -1.0f;
            q[8] = q[8] * -1.0f;
            scaleMatrix[6] = scaleMatrix[6] * -1.0f;
            scaleMatrix[7] = scaleMatrix[7] * -1.0f;
            scaleMatrix[8] = scaleMatrix[8] * -1.0f;
        }
        Quat4f.setFromMat3f(rotation, q);
        return det;
    }

    public static String explainMat4f(float[] mat4f, int fieldwidth, int precision, float epsilon) {
        float[] quat = Quat4f.getQuat4f();
        float[] translation = Vec3f.getVec3f();
        float[] scalemat = Mat3f.getMat3f();
        float[] aa = Vec4f.getVec4f();
        float[] scalevec = Vec3f.getVec3f();
        Mat4f.det(mat4f);
        double det = Mat4f.decomposeToTRSMat3f(mat4f, translation, quat, scalemat);
        Mat3f.smooth(scalemat, epsilon);
        Mat3f.ScalingType scaletype = Mat3f.getScalingType(scalemat);
        Quat4f.setAxisAngle4fFromQuat4f(aa, quat);
        StringBuffer buf = new StringBuffer(200);
        buf.append(Mat4f.toString(mat4f, 0, fieldwidth, precision));
        buf.append("\ndeterminant = ");
        buf.append(String.format("%9.4f", det));
        buf.append("\nquaternion  = ");
        buf.append(Quat4f.toString(quat, fieldwidth, precision));
        buf.append("\nrotation axis = ");
        buf.append(Vec3f.toString(aa, fieldwidth, precision));
        buf.append("   angle = ");
        buf.append(String.format("%6.3f", Float.valueOf(aa[3])));
        buf.append("  (");
        buf.append(String.format("%5.1f", (double)aa[3] * 180.0 / Math.PI));
        buf.append(" degrees)");
        buf.append("\ntranslation=");
        buf.append(Vec3f.toString(translation, fieldwidth, precision));
        buf.append("    scaling type =");
        buf.append(scaletype.toString());
        if (scaletype == Mat3f.ScalingType.ALIGNED) {
            buf.append("\nscaling factors =");
            Mat3f.getDiagonal(scalemat, scalevec);
            buf.append(Vec3f.toString(scalevec, fieldwidth, precision));
        } else if (scaletype == Mat3f.ScalingType.SKEW) {
            buf.append("\nscaling/skewing matrix =");
            buf.append(Mat3f.toString(scalemat, 0, fieldwidth, precision));
        }
        return buf.toString();
    }

    @Deprecated
    public static Mat3f.ScalingType decomposeToTRSMat3f(float[] matrix, float[] translation, float[] rotation, float[] scaleMatrix, float epsilon) {
        Mat4f.getTranslation(translation, matrix);
        float[] m = Mat3f.from4x4(matrix);
        float[] q = new float[9];
        Mat3f.ScalingType scalingType = Mat3f.polarDecompose(m, q, scaleMatrix, epsilon);
        Quat4f.setFromMat3f(rotation, q);
        Quat4f.smooth(rotation, epsilon);
        return scalingType;
    }

    @Deprecated
    public static boolean isProjective(float[] matrix) {
        return matrix[12] != 0.0f || matrix[13] != 0.0f || matrix[14] != 0.0f || matrix[15] != 1.0f;
    }
}

