/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

public final class Mat {
    private Mat() {
    }

    public static boolean LUDecompose(float[] matrix, int m, int n, int[] p) {
        int psign = 1;
        float[] s = new float[m];
        for (int i = 0; i < m; ++i) {
            p[i] = i;
            s[i] = 0.0f;
            for (int j = 0; j < n; ++j) {
                s[i] = Math.max(s[i], Math.abs(matrix[i * n + j]));
            }
        }
        for (int k = 0; k < m; ++k) {
            float pivot;
            int pivotIndex = k;
            float pivotMax = 0.0f;
            for (int i = k; i < m; ++i) {
                int ri = p[i];
                float piv = Math.abs(matrix[ri * n + k]) / s[ri];
                if (!(piv > pivotMax)) continue;
                pivotIndex = i;
                pivotMax = piv;
            }
            int pr = p[pivotIndex];
            if (pivotIndex != k) {
                p[pivotIndex] = p[k];
                p[k] = pr;
                psign = -psign;
            }
            if ((pivot = matrix[pr * n + k]) == 0.0f) {
                return false;
            }
            for (int i = k + 1; i < m; ++i) {
                float z;
                matrix[p[i] * n + k] = z = matrix[p[i] * n + k] / pivot;
                for (int j = k + 1; j < n; ++j) {
                    int n2 = p[i] * n + j;
                    matrix[n2] = matrix[n2] - z * matrix[pr * n + j];
                }
            }
        }
        return true;
    }

    public static float[] solveLUSystem(float[] LU, int[] p, float[] b) {
        int j;
        int ri;
        int i;
        int n = b.length;
        float[] x = new float[n];
        for (i = 0; i < n; ++i) {
            ri = p[i];
            for (j = 0; j < i; ++j) {
                int n2 = ri;
                b[n2] = b[n2] - LU[ri * n + j] * b[p[j]];
            }
        }
        for (i = n - 1; i >= 0; --i) {
            ri = p[i];
            x[i] = b[ri];
            for (j = i + 1; j < n; ++j) {
                int n3 = i;
                x[n3] = x[n3] - LU[ri * n + j] * x[j];
            }
            int n4 = i;
            x[n4] = x[n4] / LU[ri * n + i];
        }
        return x;
    }

    public static void invertMatrix(float[] A, int n, float[] Ainv) {
        float[] LU = new float[n * n];
        Mat.set(LU, A, n, n);
        int[] p = new int[n];
        Mat.LUDecompose(LU, n, n, p);
        float[] b = new float[n];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < n; ++i) {
                b[i] = 0.0f;
            }
            b[j] = 1.0f;
            float[] u = Mat.solveLUSystem(LU, p, b);
            for (int i = 0; i < n; ++i) {
                Ainv[i * n + j] = u[i];
            }
        }
    }

    public static void set(float[] dest, float[] src, int m, int n) {
        for (int i = 0; i < m * n; ++i) {
            dest[i] = src[i];
        }
    }

    public static void getLUfactors(float[] matrix, int m, int[] p, float[] L, float[] U) {
        for (int i = 0; i < m; ++i) {
            int ri = p[i] * m;
            for (int j = 0; j < m; ++j) {
                if (j < i) {
                    L[i * m + j] = matrix[ri + j];
                    U[i * m + j] = 0.0f;
                    continue;
                }
                if (j == i) {
                    L[i * m + j] = 1.0f;
                    U[i * m + j] = matrix[ri + j];
                    continue;
                }
                L[i * m + j] = 0.0f;
                U[i * m + j] = matrix[ri + j];
            }
        }
    }

    public static int[] invertPermutation(int[] p) {
        int m = p.length;
        int[] invp = new int[m];
        for (int i = 0; i < m; ++i) {
            invp[p[i]] = i;
        }
        return invp;
    }

    public static float[] getPermutationMatrix(int[] p) {
        int m = p.length;
        float[] pmatrix = new float[m * m];
        for (int i = 0; i < m; ++i) {
            pmatrix[i * m + p[i]] = 1.0f;
        }
        return pmatrix;
    }

    public static float[] getInvertedPermutationMatrix(int[] p) {
        int m = p.length;
        float[] invpmatrix = new float[m * m];
        for (int i = 0; i < m; ++i) {
            invpmatrix[p[i] * m + i] = 1.0f;
        }
        return invpmatrix;
    }

    public static float[] permute(int[] p, float[] b) {
        int m = p.length;
        float[] bp = new float[m];
        for (int i = 0; i < m; ++i) {
            bp[i] = b[p[i]];
        }
        return bp;
    }

    public static void tridiagonalSolve(float[] a, float[] b, float[] c, float[] d, float[] x) {
        int i;
        int n = a.length;
        c[0] = c[0] / b[0];
        d[0] = d[0] / b[0];
        for (i = 1; i < n; ++i) {
            float id = 1.0f / (b[i] - c[i - 1] * a[i]);
            c[i] = c[i] * id;
            d[i] = (d[i] - a[i] * d[i - 1]) * id;
        }
        x[n - 1] = d[n - 1];
        for (i = n - 2; i != -1; --i) {
            x[i] = d[i] - c[i] * x[i + 1];
        }
    }

    public static void mul(float[] dst, float[] a, int an, float[] b, int bn) {
        int am = a.length / an;
        int bm = b.length / bn;
        assert (dst.length >= am * bn);
        assert (an == bm);
        for (int i = 0; i < am; ++i) {
            for (int j = 0; j < bn; ++j) {
                dst[i * bn + j] = 0.0f;
                for (int k = 0; k < an; ++k) {
                    int n = i * bn + j;
                    dst[n] = dst[n] + a[i * an + k] * b[k * bn + j];
                }
            }
        }
    }
}

