/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat;

public class CubicSpline {
    private float[] a;
    private float[] b;
    private float[] c;
    private float[] d;
    private float[] y;
    private float[] D;
    private float[] as;
    private float[] bs;
    private float[] cs;
    private float[] ds;
    private int n = 0;

    public CubicSpline(float[] points) {
        int i;
        this.y = points;
        this.n = points.length;
        this.a = new float[this.n - 1];
        this.b = new float[this.n - 1];
        this.c = new float[this.n - 1];
        this.d = new float[this.n - 1];
        this.as = new float[this.n];
        this.bs = new float[this.n];
        this.cs = new float[this.n];
        this.ds = new float[this.n];
        this.D = new float[this.n];
        this.as[0] = 0.0f;
        this.bs[0] = 2.0f;
        this.cs[0] = 1.0f;
        this.ds[0] = 3.0f * (this.y[1] - this.y[0]);
        this.as[this.n - 1] = 1.0f;
        this.bs[this.n - 1] = 2.0f;
        this.cs[this.n - 1] = 0.0f;
        this.ds[this.n - 1] = 3.0f * (this.y[this.n - 1] - this.y[this.n - 2]);
        for (i = 1; i < this.n - 1; ++i) {
            this.as[i] = 1.0f;
            this.bs[i] = 4.0f;
            this.cs[i] = 1.0f;
            this.ds[i] = 3.0f * (this.y[i + 1] - this.y[i - 1]);
        }
        Mat.tridiagonalSolve(this.as, this.bs, this.cs, this.ds, this.D);
        for (i = 0; i < this.n - 1; ++i) {
            this.a[i] = this.y[i];
            this.b[i] = this.D[i];
            this.c[i] = 3.0f * (this.y[i + 1] - this.y[i]) - 2.0f * this.D[i] - this.D[i + 1];
            this.d[i] = 2.0f * (this.y[i] - this.y[i + 1]) + this.D[i] + this.D[i + 1];
        }
    }

    public float eval(float time) {
        float t = time * (float)this.n;
        int i = (int)t;
        t -= (float)i;
        if (i < 0) {
            return this.y[0];
        }
        if (i >= this.n - 1) {
            return this.y[this.n - 1];
        }
        return this.a[i] + this.b[i] * t + this.c[i] * t * t + this.d[i] * t * t * t;
    }

    public float evalDiff(float time) {
        float t = time * (float)this.n;
        int i = (int)t;
        t -= (float)i;
        if (i < 0) {
            i = 0;
            t = 0.0f;
        }
        if (i >= this.n - 1) {
            i = this.n - 2;
            t = 1.0f;
        }
        return this.b[i] + 2.0f * this.c[i] * t + 3.0f * this.d[i] * t * t;
    }

    public float evalDiff(float time, float h) {
        float t = time * (float)this.n;
        int i = (int)t;
        t -= (float)i;
        if (i < 0) {
            i = 0;
            t = 0.0f;
        }
        if (i >= this.n - 1) {
            i = this.n - 2;
            t = 1.0f;
        }
        return (this.b[i] + 2.0f * this.c[i] * t + 3.0f * this.d[i] * t * t) / h;
    }

    public float evalDiff2(float time) {
        float t = time * (float)this.n;
        int i = (int)t;
        t -= (float)i;
        if (i < 0) {
            return 0.0f;
        }
        if (i >= this.n - 1) {
            return 0.0f;
        }
        return 2.0f * this.c[i] + 6.0f * this.d[i] * t;
    }

    public float evalDiff2(float time, float h) {
        float t = time * (float)this.n;
        int i = (int)t;
        t -= (float)i;
        if (i < 0) {
            return 0.0f;
        }
        if (i >= this.n - 1) {
            return 0.0f;
        }
        return (2.0f * this.c[i] + 6.0f * this.d[i] * t) / (h * h);
    }
}

