/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Vec3f;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Vec3fTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Test
    public void equals() {
        float[] a = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f};
        float[] b = new float[]{2.0f, 1.0f, 6.0f, 3.0f, 4.0f, 5.0f};
        Assert.assertTrue((boolean)Vec3f.equals(a, 2, b, 3));
        Assert.assertTrue((!Vec3f.equals(a, 0, b, 0) ? 1 : 0) != 0);
        float[] a3 = new float[]{1.0f, 2.0f, 3.0f};
        float[] b3 = new float[]{1.0f, 2.0f, 3.0f};
        float[] c3 = new float[]{2.0f, 2.0f, 3.0f};
        float[] d3 = new float[]{1.0f, 4.0f, 3.0f};
        float[] e3 = new float[]{1.0f, 2.0f, 5.0f};
        Assert.assertTrue((boolean)Vec3f.equals(a3, b3));
        Assert.assertTrue((!Vec3f.equals(a3, c3) ? 1 : 0) != 0);
        Assert.assertTrue((!Vec3f.equals(a3, d3) ? 1 : 0) != 0);
        Assert.assertTrue((!Vec3f.equals(a3, e3) ? 1 : 0) != 0);
    }

    @Test
    public void epsilonEquals() {
        float[] a = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.005f, 6.006f};
        float[] b = new float[]{2.0f, 1.0f, 6.0f, 3.0f, 4.0f, 5.0f};
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a, 2, b, 3, 0.01f));
        Assert.assertTrue((!Vec3f.epsilonEquals(a, 0, b, 0, 0.01f) ? 1 : 0) != 0);
        float[] a3 = new float[]{1.0f, 2.0f, 3.0f};
        float[] b3 = new float[]{1.01f, 2.02f, 3.03f};
        float[] c3 = new float[]{2.0f, 2.0f, 3.0f};
        float[] d3 = new float[]{1.0f, 4.0f, 3.0f};
        float[] e3 = new float[]{1.0f, 2.0f, 5.0f};
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a3, b3, 0.05f));
        Assert.assertTrue((!Vec3f.epsilonEquals(a3, b3, 0.02f) ? 1 : 0) != 0);
        Assert.assertTrue((!Vec3f.epsilonEquals(a3, c3, 0.1f) ? 1 : 0) != 0);
        Assert.assertTrue((!Vec3f.epsilonEquals(a3, d3, 0.1f) ? 1 : 0) != 0);
        Assert.assertTrue((!Vec3f.epsilonEquals(a3, e3, 0.1f) ? 1 : 0) != 0);
    }

    @Test
    public void set() {
        float[] a = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.005f, 6.006f};
        float[] b = new float[]{2.0f, 1.0f, 6.0f, 3.0f, 4.0f, 5.0f};
        float[] expect = new float[]{1.0f, 6.0f, 3.0f};
        Vec3f.set(a, 2, b, 1);
        Assert.assertTrue((boolean)Vec3f.equals(a, 2, expect, 0));
        float[] expect2 = new float[]{2.0f, 1.0f, 6.0f};
        Vec3f.set(a, b);
        Assert.assertTrue((boolean)Vec3f.equals(a, expect2));
        float[] a3 = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.005f, 6.006f};
        float[] expect3 = new float[]{2.0f, 1.0f, 6.0f};
        Vec3f.set(a3, 2, 2.0f, 1.0f, 6.0f);
        Assert.assertTrue((boolean)Vec3f.equals(a3, 2, expect3, 0));
        float[] a4 = new float[3];
        float[] expect4 = new float[]{2.0f, 1.0f, 6.0f};
        Vec3f.set(a4, 2.0f, 1.0f, 6.0f);
        Assert.assertTrue((boolean)Vec3f.equals(a4, expect4));
    }

    @Test
    public void add() {
        float[] dest = new float[10];
        float[] a = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.005f, 6.006f};
        float[] b = new float[]{2.0f, 1.0f, 6.0f, 3.0f, 4.0f, 5.0f};
        float[] expect = new float[]{4.003f, 10.004f, 8.005f};
        Vec3f.add(dest, 4, a, 2, b, 1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest, 4, expect, 0, 1.0E-6f));
        float[] a2 = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.005f, 6.006f};
        float[] b2 = new float[]{2.0f, 1.0f, 6.0f, 3.0f, 4.0f, 5.0f};
        float[] expect2 = new float[]{4.003f, 10.004f, 8.005f};
        Vec3f.add(a2, 2, b2, 1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a2, 2, expect2, 0, 1.0E-6f));
        float[] dest3 = new float[3];
        float[] a3 = new float[]{3.003f, 4.004f, 5.005f};
        float[] b3 = new float[]{1.0f, 6.0f, 3.0f};
        float[] expect3 = new float[]{4.003f, 10.004f, 8.005f};
        Vec3f.add(dest3, a3, b3);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest3, expect3, 1.0E-6f));
        float[] a4 = new float[]{3.003f, 4.004f, 5.005f};
        float[] b4 = new float[]{1.0f, 6.0f, 3.0f};
        float[] expect4 = new float[]{4.003f, 10.004f, 8.005f};
        Vec3f.add(a4, b4);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a4, expect4, 1.0E-6f));
    }

    @Test
    public void sub() {
        float[] dest = new float[10];
        float[] a = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.005f, 6.006f};
        float[] b = new float[]{2.0f, 1.0f, 6.0f, 3.0f, 4.0f, 5.0f};
        float[] expect = new float[]{2.003f, -1.996f, 2.005f};
        Vec3f.sub(dest, 4, a, 2, b, 1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest, 4, expect, 0, 1.0E-6f));
        float[] a2 = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.005f, 6.006f};
        float[] b2 = new float[]{2.0f, 1.0f, 6.0f, 3.0f, 4.0f, 5.0f};
        float[] expect2 = new float[]{2.003f, -1.996f, 2.005f};
        Vec3f.sub(a2, 2, b2, 1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a2, 2, expect2, 0, 1.0E-6f));
        float[] dest3 = new float[3];
        float[] a3 = new float[]{3.003f, 4.004f, 5.005f};
        float[] b3 = new float[]{1.0f, 6.0f, 3.0f};
        float[] expect3 = new float[]{2.003f, -1.996f, 2.005f};
        Vec3f.sub(dest3, a3, b3);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest3, expect3, 1.0E-6f));
        float[] a4 = new float[]{3.003f, 4.004f, 5.005f};
        float[] b4 = new float[]{1.0f, 6.0f, 3.0f};
        float[] expect4 = new float[]{2.003f, -1.996f, 2.005f};
        Vec3f.sub(a4, b4);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a4, expect4, 1.0E-6f));
    }

    @Test
    public void scale() {
        float[] a1 = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.0f, 6.0f};
        float[] a2 = new float[]{3.003f, 4.004f, 5.0f};
        float[] expect = new float[]{9.009f, 12.012f, 15.0f};
        Vec3f.scale(3.0f, a1, 2);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a1, 2, expect, 0, 1.0E-6f));
        Vec3f.scale(3.0f, a2);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a2, expect, 1.0E-6f));
        a1 = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.0f, 6.0f};
        a2 = new float[4];
        expect = new float[]{9.009f, 12.012f, 15.0f};
        Vec3f.scale(3.0f, a2, 1, a1, 2);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a2, 1, expect, 0, 1.0E-6f));
        a1 = new float[3];
        a2 = new float[]{3.003f, 4.004f, 5.0f};
        expect = new float[]{9.009f, 12.012f, 15.0f};
        Vec3f.scale(3.0f, a1, a2);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a1, expect, 1.0E-6f));
    }

    @Test
    public void scaleAdd() {
        float[] dest = new float[10];
        float[] a = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.005f, 6.006f};
        float[] b = new float[]{2.0f, 1.0f, 6.0f, 3.0f, 4.0f, 5.0f};
        float[] expect = new float[]{10.009f, 18.012f, 18.015f};
        Vec3f.scaleAdd(dest, 4, 3.0f, a, 2, b, 1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest, 4, expect, 0, 1.0E-5f));
        Vec3f.scaleAdd(3.0f, a, 2, b, 1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a, 2, expect, 0, 1.0E-5f));
        float[] dest1 = new float[3];
        float[] a1 = new float[]{3.003f, 4.004f, 5.005f};
        float[] b1 = new float[]{1.0f, 6.0f, 3.0f};
        Vec3f.scaleAdd(dest1, 3.0f, a1, b1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest1, expect, 1.0E-5f));
        Vec3f.scaleAdd(3.0f, a1, b1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a1, expect, 1.0E-5f));
    }

    @Test
    public void negate() {
        float[] dest = new float[10];
        float[] a = new float[]{1.001f, 2.002f, 3.003f, 4.004f, 5.005f, 6.006f};
        float[] expect = new float[]{-3.003f, -4.004f, -5.005f};
        Vec3f.negate(dest, 4, a, 2);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest, 4, expect, 0, 1.0E-6f));
        Vec3f.negate(a, 2);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a, 2, expect, 0, 1.0E-6f));
        float[] dest1 = new float[3];
        float[] a1 = new float[]{3.003f, 4.004f, 5.005f};
        Vec3f.negate(dest1, a1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest1, expect, 1.0E-6f));
        Vec3f.negate(a1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a1, expect, 1.0E-6f));
    }

    @Test
    public void cross() {
        float[] dest = new float[10];
        float[] a = new float[]{1.001f, 2.002f, 3.0f, 4.0f, 5.0f, 6.006f};
        float[] b = new float[]{2.0f, 1.0f, 6.0f, 3.0f, 4.0f, 5.0f};
        float[] expect = new float[]{-18.0f, -4.0f, 14.0f};
        Vec3f.cross(dest, 4, a, 2, b, 1);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest, 4, expect, 0, 1.0E-5f));
        float[] dest2 = new float[3];
        float[] a2 = new float[]{3.0f, 4.0f, 5.0f};
        float[] b2 = new float[]{1.0f, 6.0f, 3.0f};
        Vec3f.cross(dest2, a2, b2);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest2, expect, 1.0E-5f));
    }

    @Test
    public void dot() {
        float result = 0.0f;
        float[] a = new float[]{1.001f, 2.002f, 3.0f, 4.0f, 5.0f, 6.006f};
        float[] b = new float[]{2.0f, 2.0f, 6.0f, 4.0f, 4.0f, 5.0f};
        float expect = 50.0f;
        result = Vec3f.dot(a, 2, b, 1);
        Assert.assertTrue((Math.abs(result - expect) < 1.0E-6f ? 1 : 0) != 0);
        float[] a2 = new float[]{3.0f, 4.0f, 5.0f};
        float[] b2 = new float[]{2.0f, 6.0f, 4.0f};
        float result2 = Vec3f.dot(a2, b2);
        Assert.assertTrue((Math.abs(result2 - expect) < 1.0E-6f ? 1 : 0) != 0);
    }

    @Test
    public void lengthSq() {
        float result = 0.0f;
        float[] a = new float[]{1.001f, 2.002f, 2.0f, 3.0f, 4.0f, 6.006f};
        float expect = 29.0f;
        result = Vec3f.lengthSq(a, 2);
        Assert.assertTrue((Math.abs(result - expect) < 1.0E-6f ? 1 : 0) != 0);
        float[] a2 = new float[]{2.0f, 3.0f, 4.0f};
        float result2 = Vec3f.lengthSq(a2);
        Assert.assertTrue((Math.abs(result2 - expect) < 1.0E-6f ? 1 : 0) != 0);
    }

    @Test
    public void length() {
        float result = 0.0f;
        float[] a = new float[]{1.001f, 2.002f, 2.0f, 3.0f, 4.0f, 6.006f};
        float expect = 29.0f;
        result = Vec3f.length(a, 2);
        Assert.assertTrue((Math.abs(result * result - expect) < 1.0E-6f ? 1 : 0) != 0);
        float[] a2 = new float[]{2.0f, 3.0f, 4.0f};
        float result2 = Vec3f.length(a2);
        Assert.assertTrue((Math.abs(result2 * result2 - expect) < 1.0E-6f ? 1 : 0) != 0);
    }

    @Test
    public void interpolate() {
    }

    @Test
    public void normalize() {
        float[] dest = new float[10];
        float[] a = new float[]{1.001f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f};
        float len = (float)Math.sqrt(50.0);
        float[] expect = new float[]{3.0f / len, 4.0f / len, 5.0f / len};
        Vec3f.normalize(dest, 4, a, 2);
        float newLen = Vec3f.length(dest, 4);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest, 4, expect, 0, 1.0E-5f));
        Assert.assertTrue((Math.abs(newLen - 1.0f) < 1.0E-5f ? 1 : 0) != 0);
        Vec3f.normalize(a, 2);
        float newLen2 = Vec3f.length(dest, 4);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a, 2, expect, 0, 1.0E-5f));
        Assert.assertTrue((Math.abs(newLen2 - 1.0f) < 1.0E-5f ? 1 : 0) != 0);
        float[] dest2 = new float[3];
        float[] a2 = new float[]{3.0f, 4.0f, 5.0f};
        Vec3f.normalize(dest2, a2);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(dest2, expect, 1.0E-5f));
        Vec3f.normalize(a2);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a2, expect, 1.0E-5f));
    }

    @Test
    public void toStringTest() {
        float[] a = new float[]{1.001f, 2.0f, 3.1f, 4.2f, 5.3f, 6.0f};
        float[] a2 = new float[]{3.1f, 4.2f, 5.3f};
        String expect = "(3.1, 4.2, 5.3)";
        String result = Vec3f.toString(a, 2);
        String result2 = Vec3f.toString(a2);
        Assert.assertTrue((boolean)result.equals(expect));
        Assert.assertTrue((boolean)result2.equals(expect));
    }
}

