/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat3f;
import hmi.math.Vec3f;

public final class SpatialTransform {
    public static final int R = 9;
    public static final int SPATIALTRANSFORM_SIZE = 12;
    public static final float[] ID = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f};

    private SpatialTransform() {
    }

    public static float[] getSpatialTransform() {
        return new float[12];
    }

    public static void setFromMat3fVec3f(float[] dst, float[] m, float[] tr) {
        int i = 0;
        while (i < 9) {
            dst[i] = m[i];
            ++i;
        }
        dst[9] = tr[0];
        dst[10] = tr[1];
        dst[11] = tr[2];
    }

    public static void setFromQuat4fVec3f(float[] dst, float[] q, float[] tr) {
        Mat3f.setFromQuatScale(dst, q, 1.0f);
        dst[9] = tr[0];
        dst[10] = tr[1];
        dst[11] = tr[2];
    }

    public static void set(float[] dst, float[] src) {
        System.arraycopy(src, 0, dst, 0, 12);
    }

    public static void set(float[] dst, int dIndex, float[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, dst, dIndex, 12);
    }

    public static void setFromQuat4fVec3f(float[] dst, int dstIndex, float[] q, int qIndex, float[] tr, int trIndex) {
        Mat3f.setFromQuatScale(dst, dstIndex, q, qIndex, 1.0f);
        dst[dstIndex + 9] = tr[trIndex];
        dst[dstIndex + 9 + 1] = tr[trIndex + 1];
        dst[dstIndex + 9 + 2] = tr[trIndex + 2];
    }

    public static void transformMotion(float[] dest, float[] trans, float[] src) {
        Mat3f.transform(trans, dest, src);
        float cx = src[3] - (trans[10] * src[2] - trans[11] * src[1]);
        float cy = src[4] - (trans[11] * src[0] - trans[9] * src[2]);
        float cz = src[5] - (trans[9] * src[1] - trans[10] * src[0]);
        Mat3f.transform(trans, dest, 3, cx, cy, cz);
    }

    public static void transformMotion(float[] dest, int destI, float[] trans, int transI, float[] src, int srcI) {
        Mat3f.transform(trans, transI, dest, destI, src, srcI);
        float cx = src[3 + srcI] - (trans[transI + 9 + 1] * src[srcI + 2] - trans[transI + 9 + 2] * src[srcI + 1]);
        float cy = src[4 + srcI] - (trans[transI + 9 + 2] * src[srcI] - trans[transI + 9] * src[srcI + 2]);
        float cz = src[5 + srcI] - (trans[transI + 9] * src[srcI + 1] - trans[transI + 9 + 1] * src[srcI]);
        Mat3f.transform(trans, transI, dest, 3 + destI, cx, cy, cz);
    }

    public static void transformForce(float[] dest, float[] trans, float[] src) {
        Vec3f.cross(dest, 3, trans, 9, src, 3);
        Vec3f.sub(dest, 0, src, 0, dest, 3);
        Mat3f.transform(trans, 0, dest, 3);
        Mat3f.transform(trans, 0, dest, 3, src, 3);
    }

    public static void transformForce(float[] dest, int destIndex, float[] trans, int transIndex, float[] src, int srcIndex) {
        Vec3f.cross(dest, destIndex + 3, trans, transIndex + 9, src, srcIndex + 3);
        Vec3f.sub(dest, destIndex, src, srcIndex, dest, destIndex + 3);
        Mat3f.transform(trans, transIndex, dest, destIndex);
        Mat3f.transform(trans, transIndex, dest, destIndex + 3, src, srcIndex + 3);
    }

    public static void transformMotionTranspose(float[] dest, float[] trans, float[] src) {
        Mat3f.transformTranspose(trans, dest, src);
        Mat3f.transformTranspose(trans, 0, dest, 3, src, 3);
        dest[3] = dest[3] + (trans[10] * dest[2] - trans[11] * dest[1]);
        dest[4] = dest[4] + (trans[11] * dest[0] - trans[9] * dest[2]);
        dest[5] = dest[5] + (trans[9] * dest[1] - trans[10] * dest[0]);
    }

    public static void transformMotionTranspose(float[] dest, int destI, float[] trans, int transI, float[] src, int srcI) {
        Mat3f.transformTranspose(trans, transI, dest, destI, src, srcI);
        Mat3f.transformTranspose(trans, transI, dest, 3 + destI, src, 3 + srcI);
        int n = destI + 3;
        dest[n] = dest[n] + (trans[transI + 9 + 1] * dest[destI + 2] - trans[transI + 9 + 2] * dest[destI + 1]);
        int n2 = destI + 4;
        dest[n2] = dest[n2] + (trans[transI + 9 + 2] * dest[destI] - trans[transI + 9] * dest[destI + 2]);
        int n3 = destI + 5;
        dest[n3] = dest[n3] + (trans[transI + 9] * dest[destI + 1] - trans[transI + 9 + 1] * dest[destI]);
    }

    public static void transformForceTranspose(float[] dest, float[] trans, float[] src) {
        Mat3f.transformTranspose(trans, 0, dest, 0, src, 3);
        float fx = dest[0];
        float fy = dest[1];
        float fz = dest[2];
        Vec3f.cross(dest, 3, trans, 9, dest, 0);
        Mat3f.transformTranspose(trans, dest, src);
        Vec3f.add(dest, 0, dest, 3);
        Vec3f.set(dest, 3, fx, fy, fz);
    }

    public static void transformForceTranspose(float[] dest, int destIndex, float[] trans, int transIndex, float[] src, int srcIndex) {
        Mat3f.transformTranspose(trans, transIndex, dest, destIndex, src, srcIndex + 3);
        float fx = dest[destIndex];
        float fy = dest[destIndex + 1];
        float fz = dest[destIndex + 2];
        Vec3f.cross(dest, destIndex + 3, trans, transIndex + 9, dest, destIndex);
        Mat3f.transformTranspose(trans, transIndex, dest, destIndex, src, srcIndex);
        Vec3f.add(dest, destIndex, dest, destIndex + 3);
        Vec3f.set(dest, destIndex + 3, fx, fy, fz);
    }

    public static void mul(float[] dest, float[] a, float[] b) {
        Mat3f.mul(dest, a, b);
        Mat3f.transformTranspose(b, 0, dest, 9, a, 9);
        Vec3f.add(dest, 9, b, 9);
    }

    public static void mul(float[] dest, int dIndex, float[] a, int aIndex, float[] b, int bIndex) {
        Mat3f.mul(dest, dIndex, a, aIndex, b, bIndex);
        Mat3f.transformTranspose(b, bIndex, dest, dIndex + 9, a, aIndex + 9);
        Vec3f.add(dest, dIndex + 9, b, bIndex + 9);
    }

    public static void transpose(float[] dst) {
        Mat3f.transform(dst, 0, dst, 9);
        Vec3f.scale(-1.0f, dst, 9);
        Mat3f.transpose(dst);
    }

    public static void transpose(float[] dest, float[] a) {
        Mat3f.transform(a, 0, dest, 9, a, 9);
        Vec3f.scale(-1.0f, dest, 9);
        Mat3f.transpose(dest, a);
    }

    public static boolean epsilonEquals(float[] a, float[] b, float epsilon) {
        if (!Mat3f.epsilonEquals(a, b, epsilon)) {
            return false;
        }
        return Vec3f.epsilonEquals(a, 9, b, 9, epsilon);
    }

    public static String toString(float[] a) {
        return String.valueOf(Mat3f.toString(a)) + Vec3f.toString(a, 9);
    }

    public static String toString(float[] a, int aIndex) {
        return String.valueOf(Mat3f.toStringTabbed(a, aIndex)) + Vec3f.toString(a, aIndex + 9);
    }
}

